/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.profile;

import java.io.IOException;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.slee.profile.ProfileSpecificationDescriptor;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.profile.ProfileVerifier;

public class ConcreteProfileManagementGenerator {
    private static Logger logger = Logger.getLogger(ConcreteProfileManagementGenerator.class);
    private ClassPool pool = null;
    private CtClass cmpProfileConcreteClass = null;
    private CtClass cmpProfileInterface = null;
    private CtClass profileManagementInterface = null;
    private CtClass profileManagementAbstractClass = null;
    private CtClass sleeProfileManagementInterface = null;
    private String cmpProfileInterfaceName = null;
    private String profileManagementInterfaceName = null;
    private String managementAbstractClassName = null;
    private int combination = -1;
    private CtClass profileMBeanConcreteInterface;
    private CtClass sleeProfileMBean;
    private CtClass profileMBeanConcreteClass;
    private String deployPath;

    public ConcreteProfileManagementGenerator(ProfileSpecificationDescriptor profileSpecificationDescriptor) {
        if ((DeployableUnitIDImpl)((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getDeployableUnit() != null) {
            this.deployPath = ((DeployableUnitIDImpl)((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getDeployableUnit()).getDUDeployer().getTempClassDeploymentDir().getAbsolutePath();
            this.pool = ((DeployableUnitIDImpl)((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getDeployableUnit()).getDUDeployer().getClassPool();
        } else {
            this.deployPath = SleeContainer.getDeployPath();
            this.pool = ConcreteClassGeneratorUtils.createClassPool();
        }
        if (ClassPool.doPruning) {
            ClassPool.doPruning = false;
        }
        this.cmpProfileInterfaceName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getCMPInterfaceName();
        this.profileManagementInterfaceName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getManagementInterfaceName();
        this.managementAbstractClassName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getManagementAbstractClassName();
        this.combination = ProfileVerifier.checkCombination(this.cmpProfileInterfaceName, this.profileManagementInterfaceName, this.managementAbstractClassName);
    }

    public Class generateConcreteProfileCMP() {
        if (this.combination == -1) {
            logger.error((Object)"Profile Specification doesn't match any combination from the JSLEE spec 1.0 section 10.5.2");
            return null;
        }
        String tmpClassName = this.cmpProfileInterfaceName + "Impl";
        try {
            this.cmpProfileConcreteClass = this.pool.get(tmpClassName).getClassPool().makeClass(tmpClassName);
        }
        catch (NotFoundException e) {
            this.cmpProfileConcreteClass = this.pool.makeClass(tmpClassName);
        }
        try {
            this.cmpProfileInterface = this.pool.get(this.cmpProfileInterfaceName);
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        try {
            this.sleeProfileManagementInterface = this.pool.get("javax.slee.profile.ProfileManagement");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        CtClass[] interfaces = null;
        if (this.combination == 1 || this.combination == 2) {
            interfaces = new CtClass[]{this.cmpProfileInterface, this.sleeProfileManagementInterface};
            ConcreteClassGeneratorUtils.createInterfaceLinks(this.cmpProfileConcreteClass, interfaces);
        } else {
            if (this.managementAbstractClassName != null) {
                try {
                    this.profileManagementAbstractClass = this.pool.get(this.managementAbstractClassName);
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                    return null;
                }
                ConcreteClassGeneratorUtils.createInheritanceLink(this.cmpProfileConcreteClass, this.profileManagementAbstractClass);
            }
            if (this.profileManagementInterfaceName != null) {
                interfaces = new CtClass[3];
                try {
                    this.profileManagementInterface = this.pool.get(this.profileManagementInterfaceName);
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                    return null;
                }
                interfaces[2] = this.profileManagementInterface;
            } else {
                interfaces = new CtClass[]{this.cmpProfileInterface, this.sleeProfileManagementInterface};
            }
            ConcreteClassGeneratorUtils.createInterfaceLinks(this.cmpProfileConcreteClass, interfaces);
        }
        try {
            CtClass[] parameters = new CtClass[]{this.pool.get("org.mobicents.slee.container.deployment.interceptors.ProfileManagementInterceptor"), this.pool.get("org.mobicents.slee.container.profile.SleeProfileManager"), this.pool.get("java.lang.String")};
            this.createConstructorWithParameter(parameters, this.cmpProfileConcreteClass, false);
        }
        catch (NotFoundException nfe) {
            String s = "Unexpected Exception - could not find class. Constructor with parameters not created";
            logger.error((Object)s, (Throwable)nfe);
            throw new RuntimeException(s, nfe);
        }
        Map cmpProfileInterfaceMethods = ClassUtils.getInterfaceMethodsFromInterface(this.cmpProfileInterface);
        this.generateConcreteMethods(this.cmpProfileConcreteClass, cmpProfileInterfaceMethods, "profileManagementInterceptor");
        Map profileManagementInterfaceMethods = ClassUtils.getInterfaceMethodsFromInterface(this.sleeProfileManagementInterface);
        this.generateConcreteMethods(this.cmpProfileConcreteClass, profileManagementInterfaceMethods, "profileManagementInterceptor");
        try {
            try {
                this.pool.get(tmpClassName).writeFile(this.deployPath);
                this.pool.get(tmpClassName).detach();
                logger.debug((Object)("Concrete Class " + this.cmpProfileInterfaceName + "Impl" + " generated in the following path " + this.deployPath));
            }
            catch (Exception e) {
                String s = "Unexpected exception generating class ";
                logger.error((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
        }
        finally {
            this.cmpProfileConcreteClass.defrost();
        }
        this.createPersistentStateHolderClass();
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(this.cmpProfileInterfaceName + "Impl");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return clazz;
    }

    public Class generateProfileMBeanInterface() {
        if (this.combination == -1) {
            logger.error((Object)"Profile Specification doesn't match any combination from the JSLEE spec 1.0 section 10.5.2");
            return null;
        }
        try {
            this.profileMBeanConcreteInterface = this.pool.get(String.valueOf(this.cmpProfileInterfaceName) + "MBean").getClassPool().makeInterface(String.valueOf(this.cmpProfileInterfaceName) + "MBean");
        }
        catch (NotFoundException e2) {
            this.profileMBeanConcreteInterface = this.pool.makeInterface(String.valueOf(this.cmpProfileInterfaceName) + "MBean");
        }
        try {
            this.sleeProfileMBean = this.pool.get("javax.slee.profile.ProfileMBean");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        ConcreteClassGeneratorUtils.createInterfaceLinks(this.profileMBeanConcreteInterface, new CtClass[]{this.sleeProfileMBean});
        CtClass[] exceptions = new CtClass[3];
        try {
            exceptions[0] = this.pool.get("javax.slee.management.ManagementException");
            exceptions[1] = this.pool.get("javax.slee.InvalidStateException");
            exceptions[2] = this.pool.get("javax.slee.profile.ProfileImplementationException");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        if (this.profileManagementInterfaceName != null) {
            try {
                this.profileManagementInterface = this.pool.get(this.profileManagementInterfaceName);
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return null;
            }
            ConcreteClassGeneratorUtils.copyMethods(this.profileManagementInterface, this.profileMBeanConcreteInterface, exceptions);
        } else {
            try {
                this.cmpProfileInterface = this.pool.get(this.cmpProfileInterfaceName);
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return null;
            }
            ConcreteClassGeneratorUtils.copyMethods(this.cmpProfileInterface, this.profileMBeanConcreteInterface, exceptions);
        }
        try {
            try {
                this.pool.get(String.valueOf(this.cmpProfileInterfaceName) + "MBean").writeFile(this.deployPath);
                this.pool.get(String.valueOf(this.cmpProfileInterfaceName) + "MBean").detach();
                logger.debug((Object)("Concrete Interface " + this.cmpProfileInterfaceName + "MBean" + " generated in the following path " + this.deployPath));
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.profileMBeanConcreteInterface.defrost();
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(this.cmpProfileInterfaceName) + "MBean");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return clazz;
    }

    public Class generateConcreteProfileMBean() {
        if (this.combination == -1) {
            logger.error((Object)"Profile Specification doesn't match any combination from the JSLEE spec 1.0 section 10.5.2");
            return null;
        }
        String tmpClassName = this.cmpProfileInterfaceName + "MBeanImpl";
        try {
            this.profileMBeanConcreteClass = this.pool.get(tmpClassName).getClassPool().makeClass(tmpClassName);
        }
        catch (NotFoundException e2) {
            this.profileMBeanConcreteClass = this.pool.makeClass(tmpClassName);
        }
        CtClass jmxMBean = null;
        try {
            jmxMBean = this.pool.get("javax.management.StandardMBean");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        try {
            this.profileMBeanConcreteInterface = this.pool.get(String.valueOf(this.cmpProfileInterfaceName) + "MBean");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return null;
        }
        CtClass[] interfaces = new CtClass[]{this.sleeProfileMBean, this.profileMBeanConcreteInterface};
        ConcreteClassGeneratorUtils.createInterfaceLinks(this.profileMBeanConcreteClass, interfaces);
        ConcreteClassGeneratorUtils.createInheritanceLink(this.profileMBeanConcreteClass, jmxMBean);
        try {
            CtClass[] parameters = new CtClass[]{this.pool.get("org.mobicents.slee.container.deployment.interceptors.ProfileManagementInterceptor"), this.pool.get("java.lang.Object")};
            this.createConstructorWithParameter(parameters, this.profileMBeanConcreteClass, true);
        }
        catch (NotFoundException nfe) {
            logger.error((Object)"Constructor With Parameter not created");
            nfe.printStackTrace();
        }
        Map profileMBeanInterfaceMethods = ClassUtils.getInterfaceMethodsFromInterface(this.profileMBeanConcreteInterface);
        this.generateConcreteMethods(this.profileMBeanConcreteClass, profileMBeanInterfaceMethods, "profileManagementInterceptor");
        try {
            try {
                this.pool.get(tmpClassName).writeFile(this.deployPath);
                this.pool.get(tmpClassName).detach();
                logger.info((Object)("Concrete Class " + tmpClassName + " generated in the following path " + this.deployPath));
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.profileMBeanConcreteClass.defrost();
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(this.cmpProfileInterfaceName + "MBeanImpl");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return clazz;
    }

    protected void createConstructorWithParameter(CtClass[] parameters, CtClass concreteClass, boolean mbean) {
        CtConstructor constructorWithParameter = new CtConstructor(parameters, concreteClass);
        String constructorBody = "{";
        if (mbean) {
            constructorBody = String.valueOf(constructorBody) + "super(" + SleeContainerUtils.class.getName() + ".getCurrentThreadClassLoader().loadClass(\"" + this.cmpProfileInterfaceName + "MBean" + "\"));";
        }
        int i = 0;
        while (i < parameters.length) {
            String parameterName = parameters[i].getName();
            parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1);
            String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
            parameterName = firstCharLowerCase.concat(parameterName.substring(1));
            try {
                CtField ctField = new CtField(parameters[i], parameterName, concreteClass);
                if (ctField.getName().equals("java.lang.Object")) {
                    ctField.setModifiers(1);
                } else {
                    ctField.setModifiers(2);
                }
                concreteClass.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            int paramNumber = i + 1;
            constructorBody = String.valueOf(constructorBody) + parameterName + "=$" + paramNumber + ";";
            ++i;
        }
        CtField[] ctFields = concreteClass.getDeclaredFields();
        int i2 = 0;
        while (i2 < ctFields.length) {
            int j = 0;
            boolean isProfileManagementInterceptor = false;
            while (j < parameters.length && !isProfileManagementInterceptor) {
                try {
                    if (ctFields[i2].getType().getName().equals("org.mobicents.slee.container.deployment.interceptors.ProfileManagementInterceptor")) {
                        isProfileManagementInterceptor = true;
                    }
                }
                catch (NotFoundException e1) {
                    e1.printStackTrace();
                }
                ++j;
            }
            if (isProfileManagementInterceptor) {
                if (!mbean) {
                    constructorBody = String.valueOf(constructorBody) + ctFields[i2].getName() + ".setProfileManager(" + "sleeProfileManager); ";
                    constructorBody = String.valueOf(constructorBody) + ctFields[i2].getName() + ".setProfileKey(" + "string); ";
                } else {
                    constructorBody = String.valueOf(constructorBody) + ctFields[i2].getName() + ".setProfile(" + "object); ";
                }
            }
            ++i2;
        }
        constructorBody = String.valueOf(constructorBody) + "}";
        logger.debug((Object)("ConstructorWithParameter to be created :" + constructorBody));
        try {
            concreteClass.addConstructor(constructorWithParameter);
            constructorWithParameter.setBody(constructorBody);
            logger.debug((Object)"ConstructorWithParameter created");
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    protected void createPersistentStateHolderClass() {
        String tmpClassName = this.cmpProfileInterfaceName + "TransientState";
        CtClass profilePersisentStateClass = null;
        try {
            profilePersisentStateClass = this.pool.get(tmpClassName).getClassPool().makeClass(tmpClassName);
        }
        catch (NotFoundException e2) {
            profilePersisentStateClass = this.pool.makeClass(tmpClassName);
        }
        try {
            try {
                ConcreteClassGeneratorUtils.createInterfaceLinks(profilePersisentStateClass, new CtClass[]{this.pool.get("java.io.Serializable")});
            }
            catch (NotFoundException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            profilePersisentStateClass.defrost();
        }
        CtMethod[] methods = this.cmpProfileInterface.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getName();
                if (methodName.startsWith("get") && !methodName.equals("getClass")) {
                    logger.info((Object)("ConcreteProfileManagementGenerator MethodName = " + methodName));
                    String fieldName = String.valueOf(methodName.substring("get".length(), "get".length() + 1).toLowerCase()) + methodName.substring("get".length() + 1);
                    try {
                        CtClass fieldType = methods[i].getReturnType();
                        CtField persistentField = new CtField(fieldType, fieldName, profilePersisentStateClass);
                        persistentField.setModifiers(1);
                        profilePersisentStateClass.addField(persistentField);
                    }
                    catch (Exception e) {
                        String s = " Error generating profile";
                        logger.error((Object)s, (Throwable)e);
                        throw new RuntimeException(s, e);
                    }
                }
                ++i;
            }
        }
        try {
            try {
                this.pool.get(tmpClassName).writeFile(this.deployPath);
                this.pool.get(tmpClassName).detach();
                logger.debug((Object)("Concrete Class " + this.cmpProfileInterfaceName + "TransientState" + " generated in the following path " + this.deployPath));
            }
            catch (Exception e) {
                logger.error((Object)"Bad error generating profile !", (Throwable)e);
                throw new RuntimeException("Unrecoverable  error genrating profile", e);
            }
        }
        finally {
            profilePersisentStateClass.defrost();
        }
    }

    private void generateConcreteMethods(CtClass source, Map interfaceMethods, String interceptor) {
        if (interfaceMethods == null) {
            return;
        }
        for (CtMethod interfaceMethod : interfaceMethods.values()) {
            if (interfaceMethod.getName().equals("profileInitialize") || interfaceMethod.getName().equals("profileLoad") || interfaceMethod.getName().equals("profileStore") || interfaceMethod.getName().equals("profileVerify")) {
                if (this.profileManagementAbstractClass == null) {
                    ConcreteClassGeneratorUtils.addInterceptedMethod(source, interfaceMethod, interceptor, false);
                    continue;
                }
                ConcreteClassGeneratorUtils.addInterceptedMethod(source, interfaceMethod, interceptor, true);
                continue;
            }
            ConcreteClassGeneratorUtils.addInterceptedMethod(source, interfaceMethod, interceptor, false);
        }
    }
}

