/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.profile;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.slee.management.DeploymentException;
import javax.slee.profile.ProfileSpecificationDescriptor;
import org.jboss.cache.Node;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.profile.ConcreteProfileManagementGenerator;
import org.mobicents.slee.container.profile.ProfileVerifier;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ProfileDeployer {
    private static Logger logger = null;
    private ConcreteProfileManagementGenerator concreteProfileManagementGenerator = null;
    private ProfileVerifier profileVerifier = null;
    protected String deployPath;
    protected static HashSet profileClassesGenerated = null;

    static {
        profileClassesGenerated = new HashSet();
        logger = Logger.getLogger(ProfileDeployer.class);
    }

    public ProfileDeployer() {
        String myPath = "./classes";
        File file = new File(myPath);
        this.deployPath = file.getPath();
    }

    public ProfileDeployer(File dirPath) {
        this.deployPath = dirPath.getPath();
    }

    public ProfileDeployer(String deployPath) {
        this.deployPath = deployPath;
    }

    public static void init() {
        profileClassesGenerated = new HashSet();
    }

    public boolean deployProfile(ProfileSpecificationDescriptor profileSpecificationDescriptor) throws DeploymentException {
        this.profileVerifier = new ProfileVerifier(profileSpecificationDescriptor);
        boolean classVerifiedSuccessfully = this.profileVerifier.verifyProfileSpecification();
        if (classVerifiedSuccessfully) {
            this.concreteProfileManagementGenerator = new ConcreteProfileManagementGenerator(profileSpecificationDescriptor);
            Class profileClass = null;
            Class profileMBeanInterface = null;
            Class profileMBeanClass = null;
            profileClass = this.concreteProfileManagementGenerator.generateConcreteProfileCMP();
            if (profileClass == null) {
                return false;
            }
            profileMBeanInterface = this.concreteProfileManagementGenerator.generateProfileMBeanInterface();
            if (profileMBeanInterface == null) {
                return false;
            }
            profileMBeanClass = this.concreteProfileManagementGenerator.generateConcreteProfileMBean();
            if (profileMBeanClass == null) {
                return false;
            }
            this.initializePersistedProfiles(profileSpecificationDescriptor.getCMPInterfaceName());
            return true;
        }
        throw new DeploymentException("Verification error in Profile " + profileSpecificationDescriptor.getName());
    }

    private void initializePersistedProfiles(String deployedProfileCmpInterfaceName) {
        block12: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Loading profile persistent state informations...");
            }
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                try {
                    profileManager.loadProfileTableNames();
                    Set allProfileTableNames = profileManager.getProfileCacheManager().getProfileTableNames();
                    if (allProfileTableNames != null) {
                        Iterator it = allProfileTableNames.iterator();
                        boolean hasProfileChildren = false;
                        while (it.hasNext()) {
                            Node childNode;
                            Map profiles;
                            String profileTableKey;
                            String cmpInterfaceName;
                            hasProfileChildren = true;
                            String profileTableName = (String)it.next();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("intializing defaultProfile for profile table=" + profileTableName));
                            }
                            if (!deployedProfileCmpInterfaceName.equals(cmpInterfaceName = (String)profileManager.loadObjectFromCache(profileTableKey = profileManager.generateProfileTableKey(profileTableName), "cmpInterfaceName"))) continue;
                            profileManager.instantiateProfile(cmpInterfaceName, profileTableName, null, true);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Profiles :");
                            }
                            if ((profiles = (childNode = (Node)profileManager.loadNodeFromCache(profileTableKey)).getChildren()) == null) continue;
                            Iterator profilesIt = profiles.values().iterator();
                            while (profilesIt.hasNext()) {
                                logger.info((Object)"Profile :");
                                Node profileNode = (Node)profilesIt.next();
                                String profileName = profileNode.getFqn().toString().substring((String.valueOf(profileManager.getRootFqn()) + "/profile:" + profileTableName + "/").length());
                                logger.info((Object)("initializing profile=" + profileName));
                                profileManager.instantiateProfile(cmpInterfaceName, profileTableName, profileName, true);
                            }
                        }
                        if (!hasProfileChildren) {
                            logger.info((Object)"No information found in the backend storage");
                        }
                        break block12;
                    }
                    logger.info((Object)"No information found in the backend storage");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                profileManager.displayAllProfilePersistentInformation();
            }
        }
    }

    public SleeTransactionManager getTransactionManager() {
        return SleeContainer.getTransactionManager();
    }
}

