/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.service;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.slee.CreateException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ServiceState;
import javax.transaction.SystemException;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.InstalledUsageParameterSet;
import org.mobicents.slee.container.component.ServiceDescriptorImpl;
import org.mobicents.slee.container.component.ServiceIDImpl;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityImpl;
import org.mobicents.slee.runtime.serviceactivity.ServiceStartedEventImpl;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class Service
implements Serializable {
    private static final long serialVersionUID = 4711716462275941571L;
    private static String tcache = TransactionManagerImpl.RUNTIME_CACHE;
    private CacheableMap serviceAttributes;
    private byte defaultPriority;
    private ServiceIDImpl serviceID;
    private static String CHILD_OBJ = "childObj";
    private static String SERVICE_ATTRS = "serviceAttributes";
    private CacheableMap childObj;
    private static final String SERVICE_ACTIVITY_CONTEXT_ID = "serviceActivityContextId";
    private static final String SERVICE_STATE = "serviceState";
    private static Logger logger = Logger.getLogger(Service.class.getName());
    private transient ServiceActivityImpl serviceActivity;
    private transient SleeContainer sleeContainer;
    boolean isRemoved;
    private static Map usageParameters = new ConcurrentReaderHashMap();
    private String cacheNodeName;

    public static String getUsageParametersPathName(ServiceID serviceId, SbbID sbbId) {
        return String.valueOf(serviceId.toString()) + "/" + sbbId.toString();
    }

    private static HashMap getUsageParameters(ServiceID serviceId) {
        HashMap retval = (HashMap)usageParameters.get(serviceId);
        if (retval == null) {
            retval = new HashMap();
            usageParameters.put(serviceId, retval);
        }
        return retval;
    }

    public static String getUsageParametersPathName(ServiceID serviceID, SbbID sbbId, String name) {
        return String.valueOf(Service.getUsageParametersPathName(serviceID, sbbId)) + "/" + SleeContainerUtils.toHex(name);
    }

    public void setState(ServiceState serviceState) {
        try {
            ServiceState oldServiceState = (ServiceState)this.serviceAttributes.get(SERVICE_STATE);
            logger.info("ServiceComponent.setState(): State service ID =  " + this.serviceID + " current State = " + oldServiceState + " new State = " + serviceState + " TX ID: " + SleeContainer.getTransactionManager().getTransaction());
        }
        catch (SystemException e) {
            logger.log(Level.WARNING, "error in setState(): ", e);
        }
        this.serviceAttributes.put(SERVICE_STATE, serviceState);
    }

    public Service(ServiceDescriptorImpl serviceDescriptor) throws RuntimeException {
        if (serviceDescriptor == null) {
            throw new NullPointerException("null descriptor or container");
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Service.Service(): creating service" + serviceDescriptor.getID());
            }
            this.serviceID = (ServiceIDImpl)serviceDescriptor.getID();
            if (usageParameters.get(this.serviceID) == null) {
                HashMap hmap = new HashMap();
                usageParameters.put(this.serviceID, hmap);
            }
            this.sleeContainer = SleeContainer.lookupFromJndi();
            this.defaultPriority = serviceDescriptor.getDefaultPriority();
            this.childObj = new CacheableMap(String.valueOf(tcache) + "-" + this.getCacheNodeName() + "#" + CHILD_OBJ);
            this.serviceAttributes = new CacheableMap(String.valueOf(tcache) + "-" + this.getCacheNodeName() + "#" + SERVICE_ATTRS);
            this.serviceActivity = new ServiceActivityImpl(this);
            String serviceActivityContextId = ((ActivityContextInterfaceImpl)this.sleeContainer.getServiceActivityContextFactory().getActivityContextInterface(this.serviceActivity)).retrieveActivityContextID();
            this.setServiceActivityContextId(serviceActivityContextId);
            this.serviceActivity.setActivityContxtId(serviceActivityContextId);
        }
        catch (Exception ex) {
            String s = "Exception encountered while loading service ";
            logger.log(Level.SEVERE, s, ex);
            throw new RuntimeException(s, ex);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Service.printNode() { serviceID = " + this.serviceID + "\n");
        if (logger.isLoggable(Level.FINE)) {
            sb.append("childObj = " + this.childObj + "/n");
        } else {
            sb.append("childObj = <not fully loaded from cache>\n");
        }
        sb.append("defaultPriority =  " + this.getDefaultPriority() + "\n").append("serviceActivity = " + this.getServiceActivityContextId() + "\n").append("serviceState = " + this.getState() + "\n").append("}");
        return sb.toString();
    }

    public ServiceState getState() {
        ServiceState serviceState = null;
        serviceState = (ServiceState)this.serviceAttributes.get(SERVICE_STATE);
        if (serviceState == null) {
            serviceState = ServiceState.INACTIVE;
            this.setState(serviceState);
        }
        return serviceState;
    }

    public String getCacheNodeName() {
        if (this.cacheNodeName != null) {
            return this.cacheNodeName;
        }
        this.cacheNodeName = "services:" + this.serviceID.getComponentKey().getName() + "-" + this.serviceID.getComponentKey().getVendor() + "-" + this.serviceID.getComponentKey().getVersion();
        return this.cacheNodeName;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public byte getDefaultPriority() {
        return this.defaultPriority;
    }

    public Collection getChildObj() {
        return this.childObj.values();
    }

    public boolean containsConvergenceName(String convergenceName) {
        return this.childObj.containsKey(convergenceName);
    }

    private ServiceComponent getServiceComponent() {
        return this.sleeContainer.getServiceComponent(this.serviceID);
    }

    public SbbEntity addChild(String convergenceName) throws CreateException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.addChild " + this.serviceID + " convergence name " + convergenceName);
        }
        this.getServiceComponent();
        SbbEntity sbbEntity = this.sleeContainer.getSbbEntityFactory().createRootSbbEnity((SbbID)this.getServiceComponent().getRootSbbComponent().getID(), this.getServiceID(), convergenceName);
        sbbEntity.setPriority(this.getDefaultPriority());
        this.childObj.put(convergenceName, sbbEntity.getSbbEntityId());
        return sbbEntity;
    }

    public void deactivate() {
        ActivityContext ac;
        this.setState(ServiceState.STOPPING);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.deactivate()  " + this.serviceID);
        }
        if ((ac = this.sleeContainer.getActivityContextFactory().getActivityContext(this.getServiceActivity())).getState().equals(ActivityContextState.ACTIVE)) {
            this.sleeContainer.getSleeEndpoint().scheduleActivityEndedEvent(this.serviceActivity);
        }
    }

    public String getRootSbbEntityId(String convergenceName) {
        return (String)this.childObj.get(convergenceName);
    }

    public void removeConvergenceName(String name) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.removeConvergenceName() " + this.serviceID + " name = " + name);
        }
        if (this.childObj.containsKey(name)) {
            this.childObj.remove(name);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.removeConvergenceName(): nothing to remove! ");
        }
    }

    public void removeAllConvergenceNames() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.removeAllConvergenceNames() " + this.serviceID);
        }
        this.childObj.clear();
    }

    public ServiceActivityImpl getServiceActivity() {
        String serviceActivityContextId = this.getServiceActivityContextId();
        if (this.serviceActivity == null || !this.serviceActivity.getActivityContextId().equals(serviceActivityContextId)) {
            this.serviceActivity = (ServiceActivityImpl)this.sleeContainer.getActivityContextFactory().getActivityFromKey(serviceActivityContextId);
            if (this.serviceActivity == null) {
                this.serviceActivity = new ServiceActivityImpl(this);
                this.serviceActivity.setActivityContxtId(serviceActivityContextId);
                this.sleeContainer.getActivityContextFactory().createActivityContext((Object)this.serviceActivity, serviceActivityContextId);
            }
        }
        return this.serviceActivity;
    }

    public void removeFromCache() throws SystemException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.removeFromCache() " + this.serviceID);
        }
        this.sleeContainer.getServiceActivityContextFactory().removeServiceActivityContextInterface(this.getServiceActivity());
        this.serviceAttributes.remove();
        this.childObj.remove();
    }

    private String getServiceActivityContextId() {
        return (String)this.serviceAttributes.get(SERVICE_ACTIVITY_CONTEXT_ID);
    }

    private void setServiceActivityContextId(String serviceACId) {
        assert (serviceACId != null) : "Service Activity Context ID should not be null.";
        this.serviceAttributes.put(SERVICE_ACTIVITY_CONTEXT_ID, serviceACId);
    }

    public static HashMap getUsageParameterTable(ServiceID serviceID) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.getUsageParameterTable() " + serviceID);
        }
        return (HashMap)usageParameters.get(serviceID);
    }

    public static InstalledUsageParameterSet getDefaultUsageParameterSet(ServiceID serviceId, SbbID sbbId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.getDefaultUsageParameterSet(): " + serviceId + " sbbID = " + sbbId);
        }
        String key = Service.getUsageParametersPathName(serviceId, sbbId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.getDefaultUsageParameterSet: " + usageParameters + " key = " + key);
        }
        return (InstalledUsageParameterSet)Service.getUsageParameters(serviceId).get(key);
    }

    public static InstalledUsageParameterSet getNamedUsageParameter(ServiceID serviceId, SbbID sbbId, String name) {
        String key = Service.getUsageParametersPathName(serviceId, sbbId, name);
        return (InstalledUsageParameterSet)Service.getUsageParameters(serviceId).get(key);
    }

    public static Iterator getAllUsageParameters(ServiceID serviceId) {
        return Service.getUsageParameters(serviceId).values().iterator();
    }

    protected static void removeUsageParameter(ServiceID serviceID, String pathName) {
        Service.getUsageParameters(serviceID).remove(pathName);
    }

    protected static void addUsageParameter(ServiceID serviceID, String pathName, Object usageParam) {
        Service.getUsageParameters(serviceID).put(pathName, usageParam);
    }

    public static void removeAllUsageParameters(ServiceID serviceID) {
        usageParameters.remove(serviceID);
    }

    public void activate() throws SystemException {
        this.setState(ServiceState.ACTIVE);
        this.getServiceActivityContextId();
        this.getServiceActivity();
        String serviceActivityContextId = this.getServiceActivityContextId();
        ActivityContext ac = this.sleeContainer.getActivityContextFactory().getActivityContextById(serviceActivityContextId);
        ac.setState(ActivityContextState.ACTIVE);
        int eventTypeID = this.sleeContainer.getEventLookupFacility().getEventID("javax.slee.serviceactivity.ServiceStartedEvent", "javax.slee", "1.0");
        ServiceStartedEventImpl ev = new ServiceStartedEventImpl(this.serviceID);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Service.activate(): sending ServiceStartedEvent for service " + this.serviceID);
        }
        DeferredEvent deferredEvent = new DeferredEvent(this.sleeContainer, eventTypeID, (Object)ev, (Object)this.serviceActivity, null);
        SleeContainer.getTransactionManager().addAfterCommitAction(deferredEvent);
    }
}

