/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.service;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedSbbException;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import javax.slee.management.ManagementException;
import javax.slee.management.SbbDescriptor;
import javax.slee.management.UsageParameterSetNameAlreadyExistsException;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.DeployedComponent;
import org.mobicents.slee.container.component.InstalledUsageParameterSet;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.ServiceDescriptorImpl;
import org.mobicents.slee.container.component.ServiceIDImpl;
import org.mobicents.slee.container.deployment.ConcreteUsageParameterMBeanInterfaceGenerator;
import org.mobicents.slee.container.management.jmx.SbbUsageMBeanImpl;
import org.mobicents.slee.container.service.Service;

public class ServiceComponent
implements DeployedComponent,
Serializable {
    private ServiceIDImpl serviceID;
    private static Logger logger = Logger.getLogger(ServiceComponent.class);
    private DeployableUnitID deployableUnitID;
    private ObjectName usageMBean;
    private boolean pendingRemove;
    private transient ServiceDescriptorImpl serviceDescriptor;
    private HashMap usageParameterNames;
    private HashMap usageParameterObjectNames;
    private HashSet sbbComponents;
    private boolean isLocked;

    public ServiceComponent(ServiceDescriptorImpl serviceDescriptor) throws Exception {
        this.serviceID = (ServiceIDImpl)serviceDescriptor.getID();
        this.usageParameterNames = new HashMap();
        this.usageParameterObjectNames = new HashMap();
        this.deployableUnitID = serviceDescriptor.getDeployableUnit();
        this.serviceDescriptor = serviceDescriptor;
        this.sbbComponents = new HashSet();
        SbbID sbbid = this.serviceDescriptor.getRootSbb();
        this.enumerateSbbs(sbbid);
    }

    private void enumerateSbbs(SbbID sbbId) throws Exception {
        this.sbbComponents.add(sbbId);
        SbbDescriptor sbbDesc = SleeContainer.lookupFromJndi().getSbbComponent(sbbId);
        if (sbbDesc == null) {
            throw new Exception("Could not find SBB Component: " + sbbId);
        }
        SbbID[] sbbIds = sbbDesc.getSbbs();
        if (sbbIds != null) {
            int i = 0;
            while (i < sbbIds.length) {
                SbbID nextSbbID = sbbIds[i];
                if (!this.sbbComponents.contains(nextSbbID)) {
                    this.enumerateSbbs(sbbIds[i]);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping recursive call to avoid infinite recursion SbbID : " + nextSbbID + " in method enumerateSbbs"));
                }
                ++i;
            }
        }
    }

    public HashSet getAllUsageParameterNames() {
        HashSet retval = new HashSet();
        for (HashSet names : this.usageParameterNames.values()) {
            retval.addAll(names);
        }
        return retval;
    }

    protected void registerSbbUsageParameter(ServiceID serviceId, SbbID sbbId, ObjectName sbbUsageParameter) {
        String key = Service.getUsageParametersPathName(serviceId, sbbId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registerSbbUsageParameter: serviceId = " + serviceId + " sbbId = " + sbbId + " key = " + key));
        }
        this.usageParameterObjectNames.put(key, sbbUsageParameter);
    }

    private void registerSbbUsageParameter(ServiceID serviceId, SbbID sbbId, String name, ObjectName sbbUsageParameter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registerSbbUsageParameter: serviceId = " + serviceId + " sbbId = " + sbbId + " name = " + name + " sbbUsageParameter = " + sbbUsageParameter));
        }
        this.usageParameterObjectNames.put(Service.getUsageParametersPathName(serviceId, sbbId, name), sbbUsageParameter);
    }

    public ObjectName getUsageParameterObjectName(SbbID sbbId) {
        String key = Service.getUsageParametersPathName(this.serviceID, sbbId);
        logger.debug((Object)("getUsageParameterObjectName:  " + sbbId + " key = " + key));
        return (ObjectName)this.usageParameterObjectNames.get(key);
    }

    public ObjectName getUsageParameterObjectName(SbbID sbbId, String name) throws UnrecognizedUsageParameterSetNameException, InvalidArgumentException {
        String key = Service.getUsageParametersPathName(this.serviceID, sbbId, name);
        if (!this.getAllUsageParameterNames().contains(name)) {
            throw new UnrecognizedUsageParameterSetNameException("Illegal arg - param name not found for this service " + name);
        }
        if (this.usageParameterNames.get(sbbId.toString()) == null) {
            throw new InvalidArgumentException("no usage parameter found for this sbb");
        }
        logger.debug((Object)("getUsageParameterObjectName:  " + sbbId + " name = " + name + " key = " + key));
        return (ObjectName)this.usageParameterObjectNames.get(key);
    }

    public void installUsageParameter(SbbID sbbId, String name) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("installUsageParameter: sbbId = " + sbbId + " name = " + name));
        }
        try {
            try {
                if (sbbId == null || name == null) {
                    throw new NullPointerException(" Null arg! ");
                }
                ServiceID serviceID = this.getServiceID();
                MobicentsSbbDescriptor sbbDescriptor = (MobicentsSbbDescriptor)SleeContainer.lookupFromJndi().getSbbComponent(sbbId);
                if (sbbDescriptor == null) {
                    throw new UnrecognizedSbbException("Unrecognized Sbb");
                }
                if (this.usageParameterNames.get(sbbId.toString()) != null && ((HashSet)this.usageParameterNames.get(sbbId.toString())).contains(name)) {
                    throw new UsageParameterSetNameAlreadyExistsException("Usage Parameter already exists " + name);
                }
                Class usageParameterClass = sbbDescriptor.getUsageParameterClass();
                if (usageParameterClass == null) {
                    throw new RuntimeException("Usage parameter class not found !");
                }
                Constructor cons = usageParameterClass.getConstructor(ServiceIDImpl.class, SbbIDImpl.class);
                Object usageParm = cons.newInstance(serviceID, sbbId);
                String pathName = Service.getUsageParametersPathName(this.getServiceID(), (SbbIDImpl)sbbDescriptor.getID(), name);
                try {
                    Service.addUsageParameter(this.serviceID, pathName, usageParm);
                }
                catch (Exception ex) {
                    throw new ManagementException("Service not found " + serviceID);
                }
                HashSet<String> hset = (HashSet<String>)this.usageParameterNames.get(sbbId.toString());
                if (hset == null) {
                    hset = new HashSet<String>();
                    this.usageParameterNames.put(sbbId.toString(), hset);
                }
                hset.add(name);
                String usageParameterMBeanClassName = String.valueOf(sbbDescriptor.getUsageParametersInterface()) + "MBeanImpl";
                Class[] args = new Class[]{ServiceID.class, SbbID.class, String.class, String.class, usageParameterClass};
                Class<?> usageParameterMBeanClass = sbbDescriptor.getClassLoader().loadClass(usageParameterMBeanClassName);
                Constructor<?> constructor = usageParameterMBeanClass.getConstructor(args);
                Object[] objs = new Object[]{this.serviceID, sbbId, name, String.valueOf(sbbDescriptor.getUsageParametersInterface()) + "MBean", usageParm};
                SbbUsageMBeanImpl usageMbean = (SbbUsageMBeanImpl)constructor.newInstance(objs);
                String mbeanName = "slee:SbbUsageMBean=" + pathName;
                ObjectName oname = new ObjectName(mbeanName);
                SleeContainer.lookupFromJndi().getMBeanServer().registerMBean(usageMbean, oname);
                this.registerSbbUsageParameter(this.serviceID, sbbId, name, oname);
                InstalledUsageParameterSet usageParam = (InstalledUsageParameterSet)usageParm;
                usageParam.setName(name);
                usageParam.setSbbUsageMBean(usageMbean);
                usageMbean.setUsageParameter(usageParam);
            }
            catch (Exception e) {
                String s = "Unexpected exception !";
                logger.error((Object)s, (Throwable)e);
                try {
                    SleeContainer.getTransactionManager().setRollbackOnly();
                }
                catch (SystemException ex) {
                    s = "Tx manager Failure!";
                }
                throw e;
            }
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected error in tx manager", ex);
            }
        }
    }

    public void installDefaultUsageParameters(MobicentsSbbDescriptor descriptor, Set sbbsChecked) throws Exception {
        logger.debug((Object)("Installing default usage parameter for " + descriptor.getID()));
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(descriptor.getClassLoader());
        try {
            if (descriptor.getUsageParametersInterface() != null) {
                Class usageParameterClass = descriptor.getUsageParameterClass();
                Constructor cons = usageParameterClass.getConstructor(ServiceIDImpl.class, SbbIDImpl.class);
                Object usageParm = cons.newInstance(this.getServiceID(), descriptor.getID());
                InstalledUsageParameterSet usageParam = (InstalledUsageParameterSet)usageParm;
                String pathName = Service.getUsageParametersPathName(this.getServiceID(), (SbbID)descriptor.getID());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" Putting usage parameter into table " + pathName));
                }
                Service.addUsageParameter(this.serviceID, pathName, usageParam);
                ConcreteUsageParameterMBeanInterfaceGenerator mbeanInterfaceGenerator = new ConcreteUsageParameterMBeanInterfaceGenerator(descriptor);
                mbeanInterfaceGenerator.generateConcreteUsageParameterMBeanInterface();
                String usageParameterMBeanClassName = String.valueOf(descriptor.getUsageParametersInterface()) + "MBeanImpl";
                Class<?> usageParameterMBeanClass = Thread.currentThread().getContextClassLoader().loadClass(usageParameterMBeanClassName);
                Class[] args = new Class[]{ServiceID.class, SbbID.class, String.class, String.class, usageParameterClass};
                Constructor<?> constructor = usageParameterMBeanClass.getConstructor(args);
                Object[] objectArray = new Object[5];
                objectArray[0] = this.serviceID;
                objectArray[1] = (SbbID)descriptor.getID();
                objectArray[3] = String.valueOf(descriptor.getUsageParametersInterface()) + "MBean";
                objectArray[4] = usageParam;
                Object[] objs = objectArray;
                Object usageMbean = constructor.newInstance(objs);
                usageParam.setSbbUsageMBean((SbbUsageMBeanImpl)usageMbean);
                ((SbbUsageMBeanImpl)usageMbean).setUsageParameter(usageParam);
                String mbeanName = "slee:SbbUsageMBean=" + pathName;
                ObjectName oname = new ObjectName(mbeanName);
                SleeContainer.lookupFromJndi().getMBeanServer().registerMBean(usageMbean, oname);
                this.registerSbbUsageParameter(this.serviceID, (SbbID)descriptor.getID(), oname);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        SbbID[] sbbs = descriptor.getSbbs();
        if (sbbs == null) {
            return;
        }
        int i = 0;
        while (i < sbbs.length) {
            if (!sbbsChecked.contains(sbbs[i])) {
                sbbsChecked.add(sbbs[i]);
                MobicentsSbbDescriptor desc = (MobicentsSbbDescriptor)SleeContainer.lookupFromJndi().getSbbComponent(sbbs[i]);
                this.installDefaultUsageParameters(desc, sbbsChecked);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping recursive step for SbbID : " + sbbs[i] + " to avoid infinite recursion"));
            }
            ++i;
        }
    }

    public void removeUsageParameter(SbbID sbbId, String name) throws ManagementException, UnrecognizedUsageParameterSetNameException, UnrecognizedSbbException, InvalidArgumentException {
        if (!this.sbbComponents.contains(sbbId)) {
            throw new UnrecognizedSbbException("SBB does not belong to this service " + sbbId);
        }
        HashSet names = (HashSet)this.usageParameterNames.get(sbbId.toString());
        if (names == null) {
            throw new InvalidArgumentException("UsageParameter name " + name + " not found ");
        }
        if (!names.contains(name)) {
            throw new UnrecognizedUsageParameterSetNameException("usage parameter name not found " + name);
        }
        names.remove(name);
        String pathName = Service.getUsageParametersPathName(this.getServiceID(), sbbId, name);
        try {
            Service.removeUsageParameter(this.serviceID, pathName);
        }
        catch (Exception ex) {
            throw new ManagementException("Unexpected exception!", (Throwable)ex);
        }
        String mbeanName = "slee:SbbUsageMBean=" + pathName;
        ObjectName oname = null;
        try {
            oname = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            logger.fatal((Object)(" malformed url! " + mbeanName), (Throwable)e);
            throw new ManagementException("error unregistering mbean ", (Throwable)e);
        }
        this.usageParameterObjectNames.remove(pathName);
        try {
            SleeContainer.lookupFromJndi().getMBeanServer().unregisterMBean(oname);
        }
        catch (InstanceNotFoundException e1) {
            throw new ManagementException("Instance not found ! " + oname);
        }
        catch (MBeanRegistrationException e1) {
            logger.fatal((Object)"unexpected exception ", (Throwable)e1);
            throw new ManagementException("Instance not registered! " + oname);
        }
    }

    public String[] getNamedUsageParameterSets(SbbID sbbId) throws InvalidArgumentException {
        HashSet paramSet = (HashSet)this.usageParameterNames.get(sbbId.toString());
        String[] retval = null;
        if (paramSet != null) {
            retval = new String[paramSet.size()];
            paramSet.toArray(retval);
            return retval;
        }
        throw new InvalidArgumentException("No named usage parameters for this sbb " + sbbId);
    }

    public Iterator getSbbUsageMBeans() {
        return this.usageParameterObjectNames.values().iterator();
    }

    public DeployableUnitID getDeployableUnit() {
        return this.deployableUnitID;
    }

    public void setDeployableUnit(DeployableUnitID deployableUnitID) {
        this.deployableUnitID = deployableUnitID;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public ServiceDescriptorImpl getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public MobicentsSbbDescriptor getRootSbbComponent() {
        return (MobicentsSbbDescriptor)SleeContainer.lookupFromJndi().getSbbComponent(this.serviceDescriptor.getRootSbb());
    }

    public void setUsageMBeanName(ObjectName usageMBean) {
        this.usageMBean = usageMBean;
    }

    public ObjectName getUsageMBean() {
        return this.usageMBean;
    }

    public void markForRemove() {
        this.pendingRemove = true;
    }

    public boolean isMarkedForRemove() {
        return this.pendingRemove;
    }

    public void checkDeployment() throws DeploymentException {
    }

    public boolean isComponent(SbbID sbbId) {
        return this.sbbComponents.contains(sbbId);
    }

    public void lock() {
        this.isLocked = true;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void unlock() {
        this.isLocked = false;
    }

    public HashSet getSbbComponents() {
        return this.sbbComponents;
    }
}

