/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.xml;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.mobicents.slee.container.xml.XMLException;
import org.mobicents.slee.container.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtilsTest
extends TestCase {
    private XMLUtils xmlUtils = null;
    private Document sbbJarDocument = null;
    private String sbbJarXml = "<?xml version=\"1.0\"?><!DOCTYPE sbb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD JAIN SLEE SBB 1.0//EN\" \"http://java.sun.com/dtd/slee-sbb-jar_1_0.dtd\"><sbb-jar>    <sbb>        <description>JCC Call Forwarding SBB for JCC 1.0a</description>        <sbb-name>JCC Call Forwarding SBB</sbb-name>        <sbb-vendor>The Open Source Community</sbb-vendor>        <sbb-version>1.0</sbb-version>        <profile-spec-ref>            <profile-spec-name>CallForwardingProfile</profile-spec-name>            <profile-spec-vendor>The Open Source Community</profile-spec-vendor>            <profile-spec-version>1.0</profile-spec-version>            <profile-spec-alias>CFP</profile-spec-alias>        </profile-spec-ref>        <sbb-classes>            <sbb-abstract-class>                <sbb-abstract-class-name>com.opencloud.slee.services.jcc.callforwarding.CallForwardingSbb</sbb-abstract-class-name>                <get-profile-cmp-method>                    <profile-spec-alias-ref>CFP</profile-spec-alias-ref>                    <get-profile-cmp-method-name>getProfile</get-profile-cmp-method-name>                </get-profile-cmp-method>            </sbb-abstract-class>        </sbb-classes>        <event event-direction=\"Receive\" initial-event=\"True\">            <event-name>CallDeliveryEvent</event-name>            <event-type-ref>                <event-type-name>javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_AUTHORIZE_CALL_ATTEMPT</event-type-name>                <event-type-vendor>javax.csapi.cc.jcc</event-type-vendor>                <event-type-version>1.1</event-type-version>            </event-type-ref>            <initial-event-select variable=\"AddressProfile\" />            <event-resource-option>block</event-resource-option>        </event>    </sbb>    <sbb>        <description>JCC Call Blocking SBB for JCC 1.0a</description>        <sbb-name>JCC Call Blocking SBB</sbb-name>        <sbb-vendor>The Open Source Community</sbb-vendor>        <sbb-version>1.0</sbb-version>        <profile-spec-ref>            <profile-spec-name>CallBlockingProfile</profile-spec-name>            <profile-spec-vendor>The Open Source Community</profile-spec-vendor>            <profile-spec-version>1.0</profile-spec-version>            <profile-spec-alias>CBP</profile-spec-alias>        </profile-spec-ref>        <sbb-classes>            <sbb-abstract-class>                <sbb-abstract-class-name>com.opencloud.slee.services.jcc.callblocking.CallBlockingSbb</sbb-abstract-class-name>                <get-profile-cmp-method>                    <profile-spec-alias-ref>CBP</profile-spec-alias-ref>                    <get-profile-cmp-method-name>getProfile</get-profile-cmp-method-name>                </get-profile-cmp-method>            </sbb-abstract-class>        </sbb-classes>        <event event-direction=\"Receive\" initial-event=\"True\">            <event-name>CallDeliveryEvent</event-name>            <event-type-ref>                <event-type-name>javax.csapi.cc.jcc.JccConnectionEvent.CONNECTION_AUTHORIZE_CALL_ATTEMPT</event-type-name>                <event-type-vendor>javax.csapi.cc.jcc</event-type-vendor>                <event-type-version>1.1</event-type-version>            </event-type-ref>            <initial-event-select variable=\"AddressProfile\" />            <event-resource-option>block</event-resource-option>        </event>    </sbb></sbb-jar>";

    public XMLUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.xmlUtils = new XMLUtils();
        InputSource sbbJarSource = new InputSource(new StringReader(this.sbbJarXml));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.sbbJarDocument = builder.parse(sbbJarSource);
    }

    protected void tearDown() throws Exception {
        this.xmlUtils = null;
        super.tearDown();
    }

    public void testGetAllChildElements() throws IllegalArgumentException {
        Element parent = this.sbbJarDocument.getDocumentElement();
        String name = "sbb";
        List actualReturn = XMLUtils.getAllChildElements(parent, name);
        XMLUtilsTest.assertEquals((String)"Failed retriving node children", (String)"sbb", (String)((Node)actualReturn.get(0)).getNodeName());
        XMLUtilsTest.assertEquals((String)"Failed retriving node children", (String)"sbb", (String)((Node)actualReturn.get(1)).getNodeName());
    }

    public void testGetChildElement() throws IllegalArgumentException, XMLException {
        Element parent = this.sbbJarDocument.getDocumentElement();
        String name = "sbb";
        boolean assertUnique = false;
        Element actualReturn = XMLUtils.getChildElement(parent, name, assertUnique);
        XMLUtilsTest.assertEquals((String)"getChildElement did not return the expected node", (String)name, (String)actualReturn.getNodeName());
        assertUnique = true;
        try {
            actualReturn = XMLUtils.getChildElement(parent, name, assertUnique);
            XMLUtilsTest.fail((String)"getChildElement did not properly assert node uniqueness");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetElementTextValue() throws IllegalArgumentException, XMLException {
        Element sbbNode = XMLUtils.getChildElement(this.sbbJarDocument.getDocumentElement(), "sbb", false);
        Element descriptionNode = XMLUtils.getChildElement(sbbNode, "description", true);
        String expectedReturn = "JCC Call Forwarding SBB for JCC 1.0a";
        String actualReturn = XMLUtils.getElementTextValue(descriptionNode);
        XMLUtilsTest.assertEquals((String)"XML Node text value was not properly extracted", (String)expectedReturn, (String)actualReturn);
    }

    public void testGetElementTextValue1() throws XMLException {
        Element sbbNode = XMLUtils.getChildElement(this.sbbJarDocument.getDocumentElement(), "sbb", false);
        String expectedReturn = "JCC Call Forwarding SBB for JCC 1.0a";
        String actualReturn = XMLUtils.getElementTextValue(sbbNode, "description");
        XMLUtilsTest.assertEquals((String)"XML Node text value was not properly extracted", (String)expectedReturn, (String)actualReturn);
    }
}

