/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;

public class SleeActivityHandle {
    private static Logger logger = Logger.getLogger(SleeActivityHandle.class);
    private ActivityHandle handle;
    private String raEntityName;
    private SleeContainer container;

    public boolean equals(Object obj) {
        if (obj instanceof SleeActivityHandle) {
            return this.handle.equals((Object)((SleeActivityHandle)obj).handle);
        }
        return false;
    }

    public SleeActivityHandle(String raEntityName, ActivityHandle handle, SleeContainer container) {
        this.handle = handle;
        this.raEntityName = raEntityName;
        this.container = container;
    }

    public ActivityHandle getHandle() {
        return this.handle;
    }

    public String getRaEntityName() {
        return this.raEntityName;
    }

    public ResourceAdaptor getResourceAdaptor() {
        if (this.raEntityName == null) {
            return null;
        }
        ResourceAdaptorEntity raEntity = SleeContainer.lookupFromJndi().getResourceAdaptorEnitity(this.raEntityName);
        ResourceAdaptor ra = raEntity.getResourceAdaptor();
        return ra;
    }

    public ByteBuffer marshalledVersion() {
        ResourceAdaptorEntity raEntity = this.container.getResourceAdaptorEnitity(this.raEntityName);
        ResourceAdaptor ra = raEntity.getResourceAdaptor();
        Marshaler marshaller = ra.getMarshaler();
        try {
            return marshaller.marshalHandle(this.handle);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getActivity() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivity():  handle = " + this.handle));
        }
        ResourceAdaptorEntity raEntity = this.container.getResourceAdaptorEnitity(this.raEntityName);
        ResourceAdaptor ra = raEntity.getResourceAdaptor();
        return ra.getActivity(this.handle);
    }

    public String toString() {
        return this.handle.toString();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

