/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.SleeState;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.resource.SleeEndpoint;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.ActivityEndEventImpl;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.EventRouter;
import org.mobicents.slee.runtime.SleeEventImpl;
import org.mobicents.slee.runtime.SuspendedActivity;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class SleeEndpointImpl
implements SleeEndpoint {
    private ActivityContextFactory acf;
    private SleeContainer sleeContainer;
    private EventRouter router;
    private boolean active;
    private Map deferredActivityMap = new ConcurrentReaderHashMap(500);
    private static Logger logger = Logger.getLogger(SleeEndpointImpl.class);
    private int activityEndEventID;
    private String raEntityName;
    private static final ComponentKey activityEndKey = new ComponentKey("javax.slee.ActivityEndEvent", "javax.slee", "1.0");

    public void enqueueEvent(EventTypeID eventTypeId, Object event, Object activity, Address address) throws IllegalStateException {
        this.router.routeEvent(eventTypeId, event, activity, address);
    }

    public void enqueueEvent(int eventID, Object event, Object activity, Address address) throws IllegalStateException {
        EventTypeIDImpl eventTypeId = this.sleeContainer.getEventTypeID(eventID);
        this.enqueueEvent(eventTypeId, event, activity, address);
    }

    public void activityCreated(Object activity) {
        ActivityContext ac = this.acf.getActivityContext(activity);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activity Created is: " + ac.getActivityContextId()));
        }
    }

    public static void notifyActivityEnded(ActivityContext ac, SleeContainer sleeContainer, int activityEndEventID) throws IllegalStateException {
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean txStarted = txMgr.requireTransaction();
        try {
            try {
                logger.debug((Object)("Notifying that activity has ended:" + ac.getActivity()));
                if (!ac.getState().equals(ActivityContextState.ACTIVE)) {
                    throw new IllegalStateException("Activity is not active");
                }
                ActivityEndEventImpl eventObj = new ActivityEndEventImpl();
                SleeEventImpl event = new SleeEventImpl(activityEndEventID, (Object)eventObj, ac.getActivityContextId(), ac.getActivity(), null);
                DeferredEvent ev = new DeferredEvent(sleeContainer, activityEndEventID, (Object)eventObj, ac.getActivity(), null);
                try {
                    txMgr.addAfterCommitAction(ev);
                    logger.debug((Object)"Added deferred event");
                }
                catch (SystemException e) {
                    logger.error((Object)"Failed to add commit action", (Throwable)e);
                }
                logger.debug((Object)"Commiting the tx");
                logger.debug((Object)"The tx has committed");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    logger.error((Object)e);
                    if (txStarted) {
                        txMgr.setRollbackOnly();
                    }
                }
                catch (SystemException e2) {
                    logger.error((Object)"Failed to rollback tx", (Throwable)e2);
                }
            }
        }
        finally {
            if (txStarted) {
                try {
                    txMgr.commit();
                }
                catch (SystemException e2) {
                    logger.error((Object)"Failed to rollback tx", (Throwable)e2);
                }
            }
        }
    }

    public SleeEndpointImpl(ActivityContextFactory activityContextFactory, EventRouter router, SleeContainer container, String raEntityName) {
        this.acf = activityContextFactory;
        this.router = router;
        this.sleeContainer = container;
        this.active = true;
        this.activityEndEventID = this.sleeContainer.getEventLookupFacility().getEventID(activityEndKey);
        this.raEntityName = raEntityName;
    }

    public void activityStarted(ActivityHandle handle) throws NullPointerException, IllegalStateException, ActivityAlreadyExistsException, CouldNotStartActivityException {
        if (!this.sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
            return;
        }
        SleeActivityHandle sleeHandle = new SleeActivityHandle(this.raEntityName, handle, this.sleeContainer);
        this.activityCreated(sleeHandle);
    }

    public void activityEnding(ActivityHandle handle) throws NullPointerException, IllegalStateException, UnrecognizedActivityException {
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            b = txMgr.requireTransaction();
            SleeActivityHandle sleeHandle = new SleeActivityHandle(this.raEntityName, handle, this.sleeContainer);
            ActivityContext ac = this.acf.getActivityContext(sleeHandle);
            if (ac == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"ENDING ACTIVITY CONTEXT NULL RETURNING !!!");
                }
                return;
            }
            SleeEndpointImpl.notifyActivityEnded(ac, this.sleeContainer, this.activityEndEventID);
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                if (b) {
                    txMgr.commit();
                }
            }
            catch (SystemException se) {
                logger.error((Object)"Failed tx completing in activityEnding", (Throwable)se);
            }
        }
    }

    public static void allActivitiesEnding() {
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            b = txMgr.requireTransaction();
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            Collection acs = sleeContainer.getActivityContextFactory().getAllActivityContexts();
            HashSet uniqueACs = new HashSet();
            uniqueACs.addAll(acs);
            for (ActivityContext ac : uniqueACs) {
                if (!ac.getState().equals(ActivityContextState.ACTIVE)) continue;
                int activityEndEventID = sleeContainer.getEventLookupFacility().getEventID(activityEndKey);
                SleeEndpointImpl.notifyActivityEnded(ac, sleeContainer, activityEndEventID);
            }
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                if (b) {
                    txMgr.commit();
                }
            }
            catch (SystemException se) {
                logger.error((Object)"Failed tx completing in activityEnding", (Throwable)se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(ActivityHandle handle, Object event, int eventType, Address address) throws NullPointerException, IllegalArgumentException, IllegalStateException, ActivityIsEndingException, UnrecognizedActivityException {
        SleeActivityHandle sleeHandle = new SleeActivityHandle(this.raEntityName, handle, this.sleeContainer);
        boolean deferred = false;
        List deferredEvents = (List)this.deferredActivityMap.get(sleeHandle);
        if (deferredEvents != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event " + eventType + " for activity " + handle + " is ready to be deferred"));
            }
            deferred = true;
            List list = deferredEvents;
            synchronized (list) {
                if (!this.deferredActivityMap.containsKey(sleeHandle)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Event " + eventType + " for activity " + handle + " will not be deferred"));
                    }
                    deferred = false;
                } else {
                    EventTypeIDImpl eventTypeId = this.sleeContainer.getEventTypeID(eventType);
                    DeferredEvent ev = new DeferredEvent(this.sleeContainer, eventTypeId, event, (Object)sleeHandle, address);
                    deferredEvents.add(ev);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Event " + eventType + " for activity " + handle + " is deferred"));
                    }
                }
            }
        }
        if (!deferred) {
            try {
                logger.debug((Object)("fireEvent " + eventType));
                this.enqueueEvent(eventType, event, (Object)sleeHandle, address);
                logger.debug((Object)("fireEvent Done! " + eventType));
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new ActivityIsEndingException("Failed to enque event!");
            }
        }
    }

    public void fireEventTransacted(ActivityHandle arg0, Object arg1, int arg2, Address arg3) throws NullPointerException, IllegalArgumentException, IllegalStateException, ActivityIsEndingException, TransactionRequiredLocalException, UnrecognizedActivityException {
    }

    public ResourceAdaptorEntityState getState() {
        return null;
    }

    public void activityEndingTransacted(ActivityHandle arg0) throws NullPointerException, IllegalStateException, TransactionRequiredLocalException, UnrecognizedActivityException {
    }

    public void activityStartedTransacted(ActivityHandle ahandle) throws NullPointerException, IllegalStateException, TransactionRequiredLocalException, ActivityAlreadyExistsException, CouldNotStartActivityException {
        throw new UnsupportedOperationException("Not implemented yet: public void activityStartedTransacted(ActivityHandle ahandle)");
    }

    public void activityStartedSuspended(ActivityHandle handle) throws NullPointerException, IllegalStateException, TransactionRequiredLocalException, ActivityAlreadyExistsException, CouldNotStartActivityException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activity " + handle + " is ready to temporarily suspended"));
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        if (handle == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activity Handle is null.");
            }
            throw new NullPointerException("Activity Handle is null.");
        }
        if (!this.sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
            throw new IllegalStateException("SLEE is not running.");
        }
        if (!this.active) {
            throw new IllegalStateException("SleeEndpoint is not active.");
        }
        SleeActivityHandle sleeHandle = new SleeActivityHandle(this.raEntityName, handle, this.sleeContainer);
        this.activityCreated(sleeHandle);
        if (!this.deferredActivityMap.containsKey(sleeHandle)) {
            this.deferredActivityMap.put(sleeHandle, Collections.synchronizedList(new ArrayList()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating SuspendedActivity transactional action for the activity " + sleeHandle));
        }
        SuspendedActivity suspendedAct = new SuspendedActivity(sleeHandle, this);
        try {
            SleeContainer.getTransactionManager().addAfterRollbackAction(suspendedAct);
            SleeContainer.getTransactionManager().addAfterCommitAction(suspendedAct);
        }
        catch (SystemException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unexpected Exception!", (Throwable)e);
            }
            throw new CouldNotStartActivityException("Failed to create suspended activity transactional action", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activity " + handle + " is temporarily suspended"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDeferredEvents(SleeActivityHandle sleeHandle) {
        if (sleeHandle == null) {
            return;
        }
        List deferredEvents = (List)this.deferredActivityMap.get(sleeHandle);
        if (deferredEvents == null) {
            return;
        }
        List list = deferredEvents;
        synchronized (list) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing deferred events for SLEE activity " + sleeHandle));
            }
            for (DeferredEvent e : deferredEvents) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing deferred event " + e.getEventTypeId() + " for SLEE activity " + sleeHandle));
                }
                e.execute();
            }
            this.deferredActivityMap.remove(sleeHandle);
        }
    }
}

