/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import com.opencloud.logging.Logable;
import com.opencloud.logging.PrintWriterLog;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceAdaptorInterface;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceEventHandler;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceFactory;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceSetupInterface;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEvent;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivity;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKActivityContextInterfaceFactory;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceAdaptorSbbInterface;
import com.opencloud.sleetck.lib.resource.sbbapi.TCKResourceSbbInterface;
import com.opencloud.sleetck.lib.resource.sbbapi.TransactionIDAccess;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import javax.slee.Address;
import javax.slee.InvalidStateException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.TCKResourceEventHandlerImpl;
import org.mobicents.slee.resource.tck.TCKActivityHandle;
import org.mobicents.slee.resource.tck.TCKMarshaller;

public class TCKResourceAdaptorWrapper
implements ResourceAdaptor,
TCKResourceAdaptorSbbInterface,
Serializable {
    private static TCKResourceSetupInterface tckResourceSetup;
    private transient TCKResourceEventHandlerImpl eventHandler;
    private TCKResourceAdaptorInterface tckResourceAdaptor;
    private TCKResourceAdaptorSbbInterface factoryInterface;
    private TCKResourceSbbInterface sbbInterface;
    private TCKActivityContextInterfaceFactory tckACIFactory;
    private static Logger log;
    private Marshaler marshaller = new TCKMarshaller();

    static {
        log = Logger.getLogger(TCKResourceAdaptorWrapper.class);
    }

    public TCKResourceAdaptorWrapper() {
        try {
            tckResourceSetup = TCKResourceFactory.createResource();
            this.tckResourceAdaptor = tckResourceSetup.getResourceAdaptorInterface();
            try {
                tckResourceSetup.setLog((Logable)new PrintWriterLog(new PrintWriter(new FileWriter("TCKRA.log")), 17, true, true));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            this.sbbInterface = this.tckResourceAdaptor.getSbbInterface();
        }
        catch (TCKTestErrorException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void init(BootstrapContext context) throws ResourceException, NullPointerException {
        this.eventHandler = new TCKResourceEventHandlerImpl(context, this.tckResourceAdaptor);
        try {
            this.tckResourceAdaptor = tckResourceSetup.getResourceAdaptorInterface();
        }
        catch (TCKTestErrorException e) {
            e.printStackTrace();
        }
    }

    public void configure(Properties properties) throws InvalidStateException {
    }

    public void start() throws ResourceException {
        try {
            TCKResourceTestInterface testInterface = tckResourceSetup.getTestInterface();
            SleeContainer slee = SleeContainer.lookupFromJndi();
            int port = slee.getRmiRegistryPort();
            Registry rmiRegistry = LocateRegistry.getRegistry(port);
            Class<?> tcktest = Thread.currentThread().getContextClassLoader().loadClass("com.opencloud.sleetck.lib.resource.impl.TCKResourceTestInterfaceImpl");
            rmiRegistry.rebind("TCKResourceTestInterface", (Remote)testInterface);
            log.debug((Object)"bound TCKResourceTestInterface");
        }
        catch (Exception e) {
            throw new ResourceException("Error binding test interface", (Throwable)e);
        }
        try {
            this.tckResourceAdaptor.addEventHandler((TCKResourceEventHandler)this.eventHandler);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void stopping() {
    }

    public Object getInterface() {
        return null;
    }

    public Object getFactoryInterface() {
        return this;
    }

    public TCKResourceSbbInterface getResource() {
        return this.sbbInterface;
    }

    public TransactionIDAccess getTransactionIDAccess() {
        return SleeContainer.lookupFromJndi().getTransactionIDAccess();
    }

    public Object getActivityContextInterfaceFactory() {
        return this.tckACIFactory;
    }

    public void setActivityContextInterfaceFactory(TCKActivityContextInterfaceFactory acif) {
        this.tckACIFactory = acif;
    }

    public void entityCreated(BootstrapContext ctx) throws ResourceException {
        this.init(ctx);
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        this.start();
    }

    public void entityDeactivating() {
    }

    public void entityDeactivated() {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object event, int eventId, Address address, int arg4) {
        try {
            if (event instanceof TCKResourceEvent) {
                this.tckResourceAdaptor.onEventProcessingSuccessful(((TCKResourceEvent)event).getEventObjectID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("eventProcessingSuccessfull called for " + event));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("eventProcessingSucessful for " + event));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception ", ex);
        }
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
    }

    public void activityEnded(ActivityHandle ah) {
        try {
            TCKActivityHandle tckh = (TCKActivityHandle)ah;
            this.tckResourceAdaptor.onActivityContextInvalid(tckh.getActivityID());
        }
        catch (RemoteException e) {
            log.error((Object)"Failed activityEnded", (Throwable)e);
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle handle) {
        TCKActivityHandle tckHandle = (TCKActivityHandle)handle;
        try {
            TCKActivity retval = this.tckResourceAdaptor.getActivity(tckHandle.getActivityID());
            if (log.isDebugEnabled()) {
                log.debug((Object)("getActivity():  returning " + retval));
            }
            return retval;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to retrieve Activty!", e);
        }
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
    }

    public void serviceUninstalled(String arg0) {
    }

    public void serviceActivated(String arg0) {
    }

    public void serviceDeactivated(String arg0) {
    }
}

