/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.rmi.dgc.VMID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.facilities.NullActivityContext;
import org.mobicents.slee.runtime.facilities.NullActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ActivityContextFactoryImpl
implements ActivityContextFactory {
    private static Logger log = Logger.getLogger(ActivityContextFactoryImpl.class);
    private Map activityToActivityContextIdMap = new ConcurrentReaderHashMap(500);
    private Map activityContextIdToActivityMap = new ConcurrentReaderHashMap(500);
    private static String ACID_AC_MAP = "ActivityContextIdToActivityContextMap";
    private SleeTransactionManager tm = SleeContainer.getTransactionManager();

    public ActivityContextFactoryImpl(SleeContainer container) {
    }

    private Map getActivityContextIdToActivityContextMap() {
        SleeTransactionManager stm = SleeContainer.getTransactionManager();
        HashMap hmap = (HashMap)stm.getTxLocalData(ACID_AC_MAP);
        if (hmap == null) {
            hmap = new HashMap(20);
            stm.putTxLocalData(ACID_AC_MAP, hmap);
        }
        return hmap;
    }

    public boolean containsActivityContext(Object activity) {
        if (activity == null) {
            throw new IllegalArgumentException("an activity is null");
        }
        return this.activityToActivityContextIdMap.containsKey(activity);
    }

    public ActivityContext getActivityContext(Object activity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContext(): for Object " + activity));
        }
        if (activity == null) {
            throw new RuntimeException("an activity is null");
        }
        boolean refresh = true;
        String id = (String)this.activityToActivityContextIdMap.get(activity);
        return this.getActivityContext(id, activity, refresh);
    }

    private ActivityContext getActivityContext(String id, Object activity, boolean refresh) {
        boolean createdTx = this.tm.requireTransaction();
        boolean rollback = true;
        try {
            ActivityContext ac;
            if (id == null) {
                rollback = false;
                ActivityContext activityContext = this.createActivityContext(activity, refresh);
                return activityContext;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retreiveing AC with id " + id));
            }
            if ((ac = (ActivityContext)this.getActivityContextIdToActivityContextMap().get(id)) == null) {
                ac = this.createActivityContext(activity, id, refresh);
            } else if (refresh) {
                ac.updateLastAccessTime();
            }
            rollback = false;
            ActivityContext activityContext = ac;
            return activityContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retreive activity context.", e);
        }
        finally {
            if (createdTx) {
                try {
                    if (!rollback) {
                        this.tm.commit();
                    } else {
                        this.tm.rollback();
                    }
                }
                catch (SystemException e) {
                    throw new RuntimeException("Failed to retreive activity context.", e);
                }
            }
        }
    }

    public ActivityContext getActivityContextById(String id) {
        return this.getActivityContextById(id, true);
    }

    public ActivityContext getActivityContextById(String id, boolean updateAccessTime) {
        Object activity = this.activityContextIdToActivityMap.get(id);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContextById(): Activity for id " + id + " is " + activity));
        }
        if (activity == null) {
            return null;
        }
        return this.getActivityContext(id, activity, updateAccessTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllActivityContexts() {
        HashSet<ActivityContext> retval = new HashSet<ActivityContext>();
        Map map = this.activityContextIdToActivityMap;
        synchronized (map) {
            for (String acid : this.activityContextIdToActivityMap.keySet()) {
                ActivityContext activityContext = this.getActivityContextById(acid);
                retval.add(activityContext);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllActivityContextsNoAccessUpdate() {
        HashSet<ActivityContext> retval = new HashSet<ActivityContext>();
        Map map = this.activityContextIdToActivityMap;
        synchronized (map) {
            for (String acid : this.activityContextIdToActivityMap.keySet()) {
                ActivityContext activityContext = this.getActivityContextById(acid, false);
                retval.add(activityContext);
            }
        }
        return retval;
    }

    public void removeActivityContext(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeActiviytContext() : " + id));
        }
        if (id != null) {
            boolean createdTx = this.tm.requireTransaction();
            boolean rollback = true;
            try {
                try {
                    ActivityContext activityContext;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing AC with id " + id));
                    }
                    if ((activityContext = (ActivityContext)this.getActivityContextIdToActivityContextMap().get(id)) != null) {
                        activityContext.markForRemove();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to remove activity context.", e);
                }
            }
            finally {
                if (createdTx) {
                    try {
                        if (!rollback) {
                            this.tm.commit();
                        } else {
                            this.tm.rollback();
                        }
                    }
                    catch (SystemException e) {
                        throw new RuntimeException("Failed to remove activity context.", e);
                    }
                }
            }
            Object activity = this.activityContextIdToActivityMap.remove(id);
            this.activityToActivityContextIdMap.remove(activity);
            this.getActivityContextIdToActivityContextMap().remove(id);
        }
    }

    public int getActivityContextCount() {
        return this.activityToActivityContextIdMap.size();
    }

    public boolean isAnyACActive() {
        for (Object o : this.getAllActivityContexts()) {
            ActivityContext ac = (ActivityContext)o;
            if (ac.isRemovable()) continue;
            return true;
        }
        return false;
    }

    public String getActivityContextId(Object activity) {
        return (String)this.activityToActivityContextIdMap.get(activity);
    }

    public Object getActivityFromKey(String key) {
        Object retval = this.activityContextIdToActivityMap.get(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityFromKey () : " + key + " returning " + retval));
        }
        return retval;
    }

    private ActivityContext createActivityContext(Object activity, boolean refresh) {
        VMID vmid = new VMID();
        String id = vmid.toString();
        return this.createActivityContext(activity, id, refresh);
    }

    public ActivityContext createActivityContext(Object activity, String id) {
        return this.createActivityContext(activity, id, true);
    }

    private ActivityContext createActivityContext(Object activity, String id, boolean refresh) {
        boolean nullActivity = false;
        if (activity instanceof NullActivityImpl) {
            ((NullActivityImpl)activity).setActivityContextId(id);
            nullActivity = true;
        }
        this.activityToActivityContextIdMap.put(activity, id);
        this.activityContextIdToActivityMap.put(id, activity);
        boolean createdTx = this.tm.requireTransaction();
        boolean rollback = true;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating AC with id " + id));
            }
            ActivityContext ac = null;
            ac = !nullActivity ? new ActivityContext(id, activity, refresh) : new NullActivityContext(id, activity, refresh);
            this.getActivityContextIdToActivityContextMap().put(id, ac);
            rollback = false;
            ActivityContext activityContext = ac;
            return activityContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create activity context.", e);
        }
        finally {
            if (createdTx) {
                try {
                    if (!rollback) {
                        this.tm.commit();
                    } else {
                        this.tm.rollback();
                    }
                }
                catch (SystemException e) {
                    throw new RuntimeException("Failed to create activity context.", e);
                }
            }
        }
    }

    public void removeFromCache(String activityContextId) {
        block2: {
            try {
                SleeContainer.getTransactionManager().removeTxLocalData("ac" + activityContextId);
            }
            catch (SystemException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to remove activity context, " + activityContextId + "from tx cache"));
            }
        }
    }
}

