/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class DeferredEvent
implements TransactionalAction {
    private static Logger log = Logger.getLogger(DeferredEvent.class);
    private SleeContainer sleeContainer;
    private EventTypeID eventTypeId;
    private Object activity;
    private Object event;
    private Address address;

    public DeferredEvent(SleeContainer container, int eventId, Object event, Object activity, Address address) {
        this(container, container.getEventTypeID(eventId), event, activity, address);
    }

    public DeferredEvent(SleeContainer sleeContainer, EventTypeID eventTypeId, Object event, Object activity, Address address) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DeferredEvent() " + eventTypeId + "\n" + "Activity:" + activity + "\n" + "Activity Context:" + sleeContainer.getActivityContextFactory().getActivityContext(activity)));
        }
        this.sleeContainer = sleeContainer;
        this.eventTypeId = eventTypeId;
        this.event = event;
        this.activity = activity;
        this.address = address;
    }

    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing deferred event:" + this.eventTypeId + ",:" + this.activity));
        }
        try {
            this.sleeContainer.getSleeEndpoint().enqueueEvent(this.eventTypeId, this.event, this.activity, this.address);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Queued event:" + this.eventTypeId + ",:" + this.activity));
            }
        }
        catch (InvalidStateException e) {
            log.error((Object)"Caught InvalidStateException in enqueueingEvent", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public Object getActivity() {
        return this.activity;
    }

    public Address getAddress() {
        return this.address;
    }

    public Object getEvent() {
        return this.event;
    }

    public EventTypeID getEventTypeId() {
        return this.eventTypeId;
    }
}

