/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.SLEEException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.ServiceState;
import javax.slee.management.SleeState;
import javax.slee.profile.ProfileTableActivity;
import javax.slee.resource.ActivityHandle;
import javax.slee.serviceactivity.ServiceActivity;
import javax.transaction.SystemException;
import org.apache.commons.pool.ObjectPool;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.ETSActivityHandle;
import org.mobicents.slee.runtime.ETSThreadFactory;
import org.mobicents.slee.runtime.EventRouter;
import org.mobicents.slee.runtime.RolledBackContextImpl;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbEntityFactory;
import org.mobicents.slee.runtime.SbbInvocationState;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SbbObjectState;
import org.mobicents.slee.runtime.SleeEvent;
import org.mobicents.slee.runtime.SleeEventImpl;
import org.mobicents.slee.runtime.facilities.NullActivityFactoryImpl;
import org.mobicents.slee.runtime.facilities.NullActivityImpl;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class EventRouterImpl
implements EventRouter {
    private SleeContainer container;
    private SleeTransactionManager txMgr;
    private EventTypeID activityEndEventID;
    private SbbEntityFactory sbbEntityFactory;
    private static boolean SINGLE_THREADED = false;
    public static int EXECUTOR_POOL_SIZE = 40;
    QueuedExecutor[] execs;
    private int executorsCounter;
    public static int EXECUTOR_ETS_POOL_SIZE = 2;
    QueuedExecutor[] etsExecs;
    private int etsExecutorsCounter;
    private static Logger logger;
    private ConcurrentHashMap executors = new ConcurrentHashMap();
    private QueuedExecutor executor;
    private HashMap currentEvent;
    public static HashMap locks;

    static {
        locks = new HashMap();
        logger = Logger.getLogger(EventRouterImpl.class);
    }

    private synchronized QueuedExecutor getExecutor(Object activity) {
        if (SINGLE_THREADED) {
            if (this.executor == null) {
                this.executor = new QueuedExecutor();
            }
            return this.executor;
        }
        QueuedExecutor executor = (QueuedExecutor)this.executors.get(activity);
        if (executor == null) {
            ActivityHandle ah = null;
            if (activity instanceof SleeActivityHandle) {
                ah = ((SleeActivityHandle)activity).getHandle();
            }
            if (ah != null && ah instanceof ETSActivityHandle) {
                executor = this.etsExecs[this.etsExecutorsCounter % EXECUTOR_ETS_POOL_SIZE];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getExecutor(): adding ETS Executor" + activity + " executor " + executor));
                }
                this.executors.put(activity, (Object)executor);
                ++this.etsExecutorsCounter;
            } else {
                executor = this.execs[this.executorsCounter % EXECUTOR_POOL_SIZE];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getExecutor(): adding Executor" + activity + " executor " + executor));
                }
                this.executors.put(activity, (Object)executor);
                ++this.executorsCounter;
            }
        }
        return executor;
    }

    public void routeEvent(EventTypeID eventTypeId, Object event, Object activity, Address address) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Routing event: " + eventTypeId + " activity " + activity + " activity class " + activity.getClass().getName() + " address " + address));
        }
        if (this.container.getSleeState().equals((Object)SleeState.STOPPED)) {
            throw new SLEEException("Mobicents SLEE container is in STOPPED state. Cannot route events.");
        }
        EventExecutor ee = new EventExecutor(new EventPosting(eventTypeId, event, activity, address));
        try {
            QueuedExecutor queue = this.getExecutor(activity);
            queue.execute((Runnable)ee);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Failed to schedule event for delivery. EventTypeID[" + eventTypeId + "], Event[" + event + "], Activity[" + activity + "], Address[" + address + "]"), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FINISHED routeEvent " + eventTypeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reRouteEvent() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"called reRouteEvent()");
        }
        Thread currentThread = Thread.currentThread();
        EventPosting ep = null;
        EventRouterImpl eventRouterImpl = this;
        synchronized (eventRouterImpl) {
            ep = (EventPosting)this.currentEvent.get(currentThread);
            if (ep != null) {
                this.currentEvent.remove(currentThread);
            }
        }
        try {
            ReRoute reRoute = new ReRoute(ep);
            SleeContainer.getTransactionManager().addAfterRollbackAction(reRoute);
            SleeContainer.getTransactionManager().addAfterCommitAction(reRoute);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public EventRouterImpl(SleeContainer container) {
        this.container = container;
        this.sbbEntityFactory = container.getSbbEntityFactory();
        this.txMgr = SleeContainer.getTransactionManager();
        this.activityEndEventID = container.getEventType(new ComponentKey("javax.slee.ActivityEndEvent", "javax.slee", "1.0"));
        this.executorsCounter = 0;
        this.execs = new QueuedExecutor[EXECUTOR_POOL_SIZE];
        int i = 0;
        while (i < EXECUTOR_POOL_SIZE) {
            this.execs[i] = new QueuedExecutor();
            ++i;
        }
        this.etsExecutorsCounter = 0;
        this.etsExecs = new QueuedExecutor[EXECUTOR_ETS_POOL_SIZE];
        i = 0;
        while (i < EXECUTOR_ETS_POOL_SIZE) {
            this.etsExecs[i] = new QueuedExecutor();
            this.etsExecs[i].setThreadFactory((ThreadFactory)new ETSThreadFactory());
            ++i;
        }
    }

    private static String computeConvergenceName(SleeEvent e, ServiceComponent svc) throws Exception {
        MobicentsSbbDescriptor rootSbb = svc.getRootSbbComponent();
        return rootSbb.computeConvergenceName(e, svc);
    }

    private void processInitialEvents(ServiceID serviceId, SleeEvent eventObject) throws Exception {
        ClassLoader invokerClassLoader;
        SbbObject sbbObject;
        SbbEntity sbbEntity;
        Exception caught;
        block22: {
            caught = null;
            sbbEntity = null;
            sbbObject = null;
            invokerClassLoader = null;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            this.txMgr.begin();
            try {
                try {
                    ServiceComponent svc = this.container.getServiceComponent(serviceId);
                    if (svc == null) break block22;
                    String name = EventRouterImpl.computeConvergenceName(eventObject, svc);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("service = " + serviceId + " Convergence name = " + name));
                    }
                    Service service = this.container.getService(serviceId);
                    if (name != null) {
                        boolean found = false;
                        try {
                            found = service.containsConvergenceName(name);
                        }
                        catch (ClassCastException e) {
                            e.printStackTrace();
                            throw new Exception("Convergence name is invalid class type");
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                            throw new Exception("Convergence name is null");
                        }
                        String sbbEntityId = null;
                        if (!found) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("not found the convergence name [" + name + "]"));
                            }
                            SbbID sbbID = (SbbID)svc.getRootSbbComponent().getID();
                            MobicentsSbbDescriptor descriptor = (MobicentsSbbDescriptor)this.container.getSbbComponent(sbbID);
                            invokerClassLoader = descriptor.getClassLoader();
                            Thread.currentThread().setContextClassLoader(invokerClassLoader);
                            sbbEntity = service.addChild(name);
                            sbbEntityId = sbbEntity.getSbbEntityId();
                            ActivityContext ac = null;
                            try {
                                sbbEntity.assignSbbObject(true);
                                sbbObject = sbbEntity.getSbbObject();
                            }
                            catch (Exception ex) {
                                logger.error((Object)"Exception trhown ", (Throwable)ex);
                                sbbObject = sbbEntity.getSbbObject();
                                sbbEntity.releaseObject(true);
                                sbbEntity = null;
                                throw ex;
                            }
                            try {
                                ac = this.container.getActivityContextFactory().getActivityContextById(eventObject.getActivityContextID());
                                ac.attachSbbEntity(sbbEntityId);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Ran sbbPostCreate");
                                }
                            }
                            catch (Exception ex) {
                                if (ac != null) {
                                    ac.detachSbbEntity(sbbEntityId);
                                }
                                throw ex;
                            }
                            sbbObject.sbbStore();
                            sbbEntity.releaseObject(false);
                            break block22;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("found the convergence name [" + name + "]"));
                        }
                        String rootSbbEntityId = service.getRootSbbEntityId(name);
                        ActivityContext ac = this.container.getActivityContextFactory().getActivityContextById(eventObject.getActivityContextID());
                        ac.attachSbbEntity(rootSbbEntityId);
                        break block22;
                    }
                    logger.warn((Object)("Service with id:" + serviceId + " returns a null convergence name. Either the service does not exist or it is not interested in the event."));
                }
                catch (Exception e) {
                    logger.error((Object)"Caught an error! ", (Throwable)e);
                    caught = e;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        boolean invokeSbbRolledBack = this.handleRollback(sbbObject, null, caught, invokerClassLoader);
        if (sbbEntity == null && invokeSbbRolledBack) {
            this.handleSbbRolledBack(sbbEntity, sbbObject, eventObject, invokerClassLoader, false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Committing SLEE Originated Invocation Sequence");
        }
        this.txMgr.commit();
        if (sbbEntity != null && invokeSbbRolledBack) {
            this.handleSbbRolledBack(sbbEntity, sbbObject, eventObject, invokerClassLoader, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleRollback(SbbObject sbbObject, SleeEvent sleeEvent, Exception e, ClassLoader contextClassLoader) {
        this.txMgr.assertIsInTx();
        invokeSbbRolledBack = false;
        if (e != null && e instanceof RuntimeException) {
            if (EventRouterImpl.logger.isInfoEnabled()) {
                EventRouterImpl.logger.error((Object)"Caught RuntimeException in invoking SLEE originated invocation", (Throwable)e);
            }
            if (sbbObject != null && !sbbObject.getInvocationState().equals(SbbInvocationState.NOT_INVOKING)) {
                if (EventRouterImpl.logger.isDebugEnabled()) {
                    EventRouterImpl.logger.debug((Object)"sbbObject is not null");
                }
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    block20: {
                        Thread.currentThread().setContextClassLoader(contextClassLoader);
                        try {
                            this.txMgr.setRollbackOnly();
                        }
                        catch (SystemException ex) {
                            throw new RuntimeException("Unexpected exception ! ", ex);
                        }
                        aci = null;
                        eventObject = null;
                        if (sleeEvent != null) {
                            aci = sleeEvent.getActivityContextInterface();
                            eventObject = sleeEvent.getEventObject();
                        }
                        if (EventRouterImpl.logger.isDebugEnabled()) {
                            EventRouterImpl.logger.debug((Object)"Calling sbbExceptionThrown");
                        }
                        try {
                            sbbObject.sbbExceptionThrown(e, eventObject, aci);
                            if (EventRouterImpl.logger.isDebugEnabled()) {
                                EventRouterImpl.logger.debug((Object)"Called sbbExceptionThrown");
                            }
                        }
                        catch (Exception ex) {
                            if (!EventRouterImpl.logger.isDebugEnabled()) break block20;
                            EventRouterImpl.logger.debug((Object)"Threw an exception while invoking sbbExceptionThrown ", (Throwable)ex);
                        }
                    }
                    invokeSbbRolledBack = sbbObject.getState().equals(SbbObjectState.READY);
                    sbbObject.setState(SbbObjectState.DOES_NOT_EXIST);
                    if (!EventRouterImpl.logger.isDebugEnabled()) ** GOTO lbl49
                    EventRouterImpl.logger.debug((Object)"done it");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        } else {
            if (EventRouterImpl.logger.isDebugEnabled()) {
                EventRouterImpl.logger.debug((Object)"Runtime exception was not thrown");
            }
            if (sbbObject != null && sbbObject.getSbbContext().getRollbackOnly()) {
                if (EventRouterImpl.logger.isDebugEnabled()) {
                    EventRouterImpl.logger.debug((Object)"object is set rollbackonly=true");
                    EventRouterImpl.logger.debug((Object)("sbb rolled back context " + sbbObject.getSbbContext()));
                }
                invokeSbbRolledBack = sbbObject.getState().equals(SbbObjectState.READY);
            }
        }
lbl49:
        // 6 sources

        if (sbbObject == null && e != null) {
            invokeSbbRolledBack = true;
        }
        if (EventRouterImpl.logger.isDebugEnabled()) {
            EventRouterImpl.logger.debug((Object)("InvokeSbbRolledBack?:" + invokeSbbRolledBack));
        }
        return invokeSbbRolledBack;
    }

    public void handleSbbRolledBack(SbbEntity sbbEntity, SbbObject sbbObj, SleeEvent sleeEvent, ClassLoader contextClassLoader, boolean removeRolledBack) {
        block25: {
            if (sbbEntity == null && sbbObj == null || sbbEntity != null && sbbObj != null) {
                logger.error((Object)"Illegal State! Only one of sbbEntity or SbbObject can be specified");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking sbbRolledBack");
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    if (sbbEntity != null) {
                        String sbbId = sbbEntity.getSbbEntityId();
                        this.txMgr.begin();
                        sbbEntity = this.sbbEntityFactory.getSbbEntity(sbbId);
                    }
                    RolledBackContextImpl rollbackContext = new RolledBackContextImpl(sleeEvent == null ? null : sleeEvent.getEventObject(), sleeEvent == null ? null : new ActivityContextInterfaceImpl(this.container, sleeEvent.getActivityContextID()), removeRolledBack);
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    if (sbbEntity != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Invoking sbbRolledBack on different sbb object");
                        }
                        ObjectPool pool = sbbEntity.getObjectPool();
                        if (sbbEntity.getSbbObject() != null) {
                            sbbEntity.getSbbObject().setState(SbbObjectState.DOES_NOT_EXIST);
                            pool.invalidateObject((Object)sbbEntity.getSbbObject());
                        }
                        sbbEntity.assignSbbObject(false);
                        sbbObj = sbbEntity.getSbbObject();
                        sbbObj.sbbLoad();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Invoking sbbRolledBack");
                    }
                    if (sbbObj.getState().equals(SbbObjectState.READY)) {
                        sbbObj.sbbRolledBack(rollbackContext);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Invoked sbbRolledBack");
                    }
                    if (sbbEntity != null) {
                        sbbObj.sbbStore();
                    }
                    if (sbbEntity == null) break block25;
                    try {
                        this.txMgr.commit();
                    }
                    catch (SystemException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("tx manager System Failure ", ex);
                    }
                }
                catch (Exception e) {
                    if (sbbObj != null && sbbEntity != null) {
                        sbbObj = sbbEntity.getSbbObject();
                        sbbObj.setState(SbbObjectState.DOES_NOT_EXIST);
                    }
                    logger.error((Object)"Exception thrown in attempting to invoke sbbRolledBack", (Throwable)e);
                    sbbObj.sbbExceptionThrown(e, sleeEvent.getEventObject(), sleeEvent.getActivityContextInterface());
                }
            }
            finally {
                try {
                    if (this.txMgr.isInTx()) {
                        this.txMgr.commit();
                    }
                }
                catch (Exception e2) {
                    logger.error((Object)"Failed to commit transaction", (Throwable)e2);
                    throw new RuntimeException("Failed to commit tx ", e2);
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    private void routeQueuedEvent(EventPosting ep) {
        boolean rb;
        EventTypeID eventTypeID;
        String activityContextId;
        SleeEventImpl eventObject;
        block112: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n\n\nrouteTheEvent : [[[" + ep.event.getClass().getName() + " eventType " + ep.eventTypeID));
            }
            this.txMgr.assertIsNotInTx();
            eventObject = null;
            activityContextId = null;
            eventTypeID = null;
            rb = true;
            if (this.container.getActivityContextFactory().containsActivityContext(ep.getActivity()) || !this.container.getSleeState().equals((Object)SleeState.STOPPING)) break block112;
            try {
                if (this.txMgr.isInTx()) {
                    if (rb) {
                        logger.error((Object)"Rolling back tx in routeTheEvent.");
                        this.txMgr.setRollbackOnly();
                    } else {
                        logger.error((Object)"Transaction left open in routeTheEvent! It has to be pinned down and fixed! Debug information follows.");
                        logger.error((Object)this.txMgr.displayOngoingSleeTransactions());
                        this.txMgr.commit();
                    }
                }
            }
            catch (SystemException se) {
                logger.error((Object)"Failure in TX operation", (Throwable)se);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"routeTheEvent : done routing it! ]]] \n\n\n");
            }
            return;
        }
        try {
            try {
                ActivityContext ac = null;
                ServiceID[] serviceIDs = null;
                ServiceComponent[] services = null;
                this.txMgr.begin();
                try {
                    try {
                        ac = this.container.getActivityContextFactory().getActivityContext(ep.getActivity());
                        activityContextId = ac.getActivityContextId();
                        Thread.currentThread().setName(String.valueOf(activityContextId) + "," + ep.getEventTypeID().toString());
                        ac = null;
                        eventObject = new SleeEventImpl(ep.getEventTypeID(), ep.getEvent(), activityContextId, ep.getActivity(), ep.getAddress());
                        eventTypeID = eventObject.getEventTypeID();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Performing initial event processing.");
                        }
                        serviceIDs = this.container.getServicesByState(ServiceState.ACTIVE);
                        if (logger.isDebugEnabled()) {
                            logger.info((Object)("number of Active services = " + serviceIDs.length));
                        }
                        services = new ServiceComponent[serviceIDs.length];
                        int j = 0;
                        while (j < serviceIDs.length) {
                            services[j] = this.container.getServiceComponent(serviceIDs[j]);
                            ++j;
                        }
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Failure while routing event; first phase. Event Posting [" + ep + "]"), e);
                    }
                }
                finally {
                    this.txMgr.commit();
                }
                int i = 0;
                while (i < services.length) {
                    MobicentsSbbDescriptor rootSbb = services[i].getRootSbbComponent();
                    if (rootSbb != null) {
                        Set iet = rootSbb.getInitialEventTypes();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("svc name " + services[i].getServiceDescriptor().getID()));
                            logger.debug((Object)("root.initialEventTypes = " + iet));
                            logger.debug((Object)("eventTypeID = " + eventTypeID));
                        }
                        if (iet.contains(eventTypeID)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Initial Event processing.");
                            }
                            this.processInitialEvents(services[i].getServiceID(), eventObject);
                        }
                    }
                    ++i;
                }
                boolean gotSbb = false;
                boolean toSleep = false;
                do {
                    String rootSbbEntityId = null;
                    ClassLoader invokerClassLoader = null;
                    SbbEntity sbbEntity = null;
                    SbbObject sbbObject = null;
                    try {
                        try {
                            ClassLoader oldClassLoader;
                            Exception caught;
                            block114: {
                                if (toSleep) {
                                    Thread.sleep(100L);
                                    toSleep = false;
                                }
                                this.txMgr.begin();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Beginning invocation sequence 3");
                                }
                                caught = null;
                                SbbEntity highestPrioritySbb = null;
                                oldClassLoader = Thread.currentThread().getContextClassLoader();
                                try {
                                    try {
                                        SbbEntity rootSbbEntity;
                                        ac = this.container.getActivityContextFactory().getActivityContextById(activityContextId);
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Loaded activity context: " + activityContextId));
                                        }
                                        try {
                                            highestPrioritySbb = this.findSbbEntityForDelivering(ac, eventTypeID);
                                        }
                                        catch (Exception e) {
                                            logger.warn((Object)("Exception in findSbbEntityForDelivering( ac[" + ac + "],\n" + "  eventTypeID[" + eventTypeID + "]). \n" + "  Reason: " + e.getMessage()), (Throwable)e);
                                            highestPrioritySbb = null;
                                        }
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Highest Priority Sbb: " + highestPrioritySbb));
                                        }
                                        if (highestPrioritySbb == null) {
                                            if (logger.isDebugEnabled()) {
                                                logger.debug((Object)"No more sbbs to route to");
                                            }
                                            ac.clearDeliveredSet();
                                            gotSbb = false;
                                        } else {
                                            gotSbb = true;
                                            ac.addToDeliveredSet(highestPrioritySbb.getSbbEntityId());
                                        }
                                        if (eventTypeID.equals((Object)this.activityEndEventID)) {
                                            ac.setState(ActivityContextState.ENDING);
                                        }
                                        if (!gotSbb) break block114;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)"Got an sbb to route event to");
                                        }
                                        invokerClassLoader = highestPrioritySbb.getSbbDescriptor().getClassLoader();
                                        Thread.currentThread().setContextClassLoader(invokerClassLoader);
                                        sbbEntity = highestPrioritySbb;
                                        sbbEntity.setCurrentEvent(eventObject);
                                        if (sbbEntity.getSbbObject() == null) {
                                            sbbEntity.assignSbbObject(false);
                                            sbbObject = sbbEntity.getSbbObject();
                                        }
                                        sbbObject.sbbLoad();
                                        this.txMgr.putTxLocalData("sbb_context", sbbEntity.getSbbObject().getSbbContext());
                                        Set eventMask = sbbEntity.getMaskedEventTypes(ac.getActivityContextId());
                                        if (!eventMask.contains(eventObject.getEventTypeID())) {
                                            if (logger.isDebugEnabled()) {
                                                logger.debug((Object)("sbb entity = " + sbbEntity.getSbbEntityId()));
                                                logger.debug((Object)("Invoking event handler for: " + eventObject));
                                                logger.debug((Object)("activity = " + eventObject.getActivity()));
                                                logger.debug((Object)("activityContext = " + eventObject.getActivityContext()));
                                            }
                                            sbbObject.setSbbInvocationState(SbbInvocationState.INVOKING_EVENT_HANDLER);
                                            sbbEntity.invokeEventHandler(eventObject);
                                            if (this.txMgr.getRollbackOnly()) {
                                                throw new Exception("The transaction is marked for rollback");
                                            }
                                            sbbObject.setSbbInvocationState(SbbInvocationState.NOT_INVOKING);
                                            if (logger.isDebugEnabled()) {
                                                logger.debug((Object)"Invoked event handler");
                                            }
                                        } else if (logger.isDebugEnabled()) {
                                            logger.debug((Object)"Not invoking event handler since event is masked");
                                        }
                                        if (eventObject.getEventTypeID().equals((Object)this.activityEndEventID)) {
                                            ac.detachSbbEntity(highestPrioritySbb.getSbbEntityId());
                                        }
                                        if (sbbEntity == null || (rootSbbEntity = this.sbbEntityFactory.getSbbEntity(sbbEntity.getRootSbbId())).getAttachmentCount() != 0) break block114;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Attachment count for " + rootSbbEntity.getSbbEntityId() + " is 0"));
                                        }
                                        if (rootSbbEntity.getSbbEntityId().equals(sbbEntity.getSbbEntityId())) {
                                            rootSbbEntity.remove();
                                            break block114;
                                        }
                                        rootSbbEntityId = rootSbbEntity.getSbbEntityId();
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)("Failure while routing event; second phase. Event Posting [" + ep + "]"), (Throwable)e);
                                        if (highestPrioritySbb != null) {
                                            sbbObject = highestPrioritySbb.getSbbObject();
                                        }
                                        caught = e;
                                    }
                                }
                                finally {
                                    if (gotSbb) {
                                        try {
                                            if (this.findSbbEntityForDelivering(ac, eventTypeID) == null) {
                                                gotSbb = false;
                                                ac.clearDeliveredSet();
                                            }
                                        }
                                        catch (Exception e) {
                                            gotSbb = false;
                                            ac.clearDeliveredSet();
                                        }
                                    }
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                }
                            }
                            boolean invokeSbbRolledBack = this.handleRollback(sbbObject, eventObject, caught, invokerClassLoader);
                            boolean invokeSbbRolledBackRemove = false;
                            ClassLoader rootInvokerClassLoader = null;
                            SbbEntity rootSbbEntity = null;
                            if (!invokeSbbRolledBack && rootSbbEntityId != null) {
                                caught = null;
                                oldClassLoader = Thread.currentThread().getContextClassLoader();
                                try {
                                    try {
                                        rootSbbEntity = this.sbbEntityFactory.getSbbEntity(rootSbbEntityId);
                                        rootInvokerClassLoader = rootSbbEntity.getSbbDescriptor().getClassLoader();
                                        Thread.currentThread().setContextClassLoader(rootInvokerClassLoader);
                                        rootSbbEntity.remove();
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)("Failure while routing event; third phase. Event Posting [" + ep + "]"), (Throwable)e);
                                        caught = e;
                                    }
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                }
                                invokeSbbRolledBackRemove = this.handleRollback(null, eventObject, caught, rootInvokerClassLoader);
                            }
                            if (invokeSbbRolledBack && sbbEntity == null) {
                                this.handleSbbRolledBack(null, sbbObject, null, invokerClassLoader, false);
                            } else if (sbbEntity != null && !this.txMgr.getRollbackOnly() && sbbEntity.getSbbObject() != null) {
                                sbbObject.sbbStore();
                                sbbEntity.releaseObject(false);
                            }
                            if (this.txMgr.getRollbackOnly()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Rolling back SLEE Originated Invocation Sequence");
                                }
                                this.txMgr.rollback();
                            } else {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Committing SLEE Originated Invocation Sequence");
                                }
                                this.txMgr.commit();
                            }
                            if (invokeSbbRolledBack && sbbEntity != null) {
                                sbbEntity.getSbbEntityId();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Invoking sbbRolledBack for Op Only or Op and Remove");
                                }
                                this.handleSbbRolledBack(sbbEntity, null, eventObject, invokerClassLoader, false);
                            }
                            if (invokeSbbRolledBackRemove) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Invoking sbbRolledBack for Remove Only");
                                }
                                this.handleSbbRolledBack(rootSbbEntity, null, null, rootInvokerClassLoader, true);
                            }
                            rb = false;
                        }
                        catch (RuntimeException e) {
                            logger.error((Object)"Unhandled RuntimeException in event router: ", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Unhandled Exception in event router: ", (Throwable)e);
                        }
                        catch (Error e) {
                            logger.error((Object)"Unhandled Error in event router: ", (Throwable)e);
                            throw e;
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Unhandled Throwable in event router: ", t);
                        }
                    }
                    finally {
                        try {
                            if (this.txMgr.isInTx()) {
                                if (rb) {
                                    logger.error((Object)"Rolling back tx in routeTheEvent.");
                                    this.txMgr.setRollbackOnly();
                                } else {
                                    logger.error((Object)"Transaction left open in routeTheEvent! It has to be pinned down and fixed! Debug information follows.");
                                    logger.error((Object)this.txMgr.displayOngoingSleeTransactions());
                                    this.txMgr.commit();
                                }
                            }
                        }
                        catch (SystemException se) {
                            logger.error((Object)"Failure in TX operation", (Throwable)se);
                        }
                        if (sbbEntity != null && logger.isDebugEnabled()) {
                            logger.debug((Object)("routeTheEvent : done routing it to the sbbEntity = " + sbbEntity.getSbbEntityId() + "]]] \n\n\n"));
                        }
                    }
                } while (gotSbb);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Done with event processing -- checking for endActivity");
                }
                this.txMgr.assertIsNotInTx();
                if (eventTypeID.equals((Object)this.activityEndEventID)) {
                    this.handleActivityEndEvent(eventObject);
                }
                rb = false;
            }
            catch (RuntimeException e) {
                logger.error((Object)"Unhandled RuntimeException in event router: ", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Unhandled Exception in event router: ", (Throwable)e);
            }
            catch (Error e) {
                logger.error((Object)"Unhandled Error in event router: ", (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                logger.error((Object)"Unhandled Throwable in event router: ", t);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (this.txMgr.isInTx()) {
                    if (rb) {
                        logger.error((Object)"Rolling back tx in routeTheEvent.");
                        this.txMgr.setRollbackOnly();
                    } else {
                        logger.error((Object)"Transaction left open in routeTheEvent! It has to be pinned down and fixed! Debug information follows.");
                        logger.error((Object)this.txMgr.displayOngoingSleeTransactions());
                        this.txMgr.commit();
                    }
                }
            }
            catch (SystemException se) {
                logger.error((Object)"Failure in TX operation", (Throwable)se);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"routeTheEvent : done routing it! ]]] \n\n\n");
            }
        }
        this.txMgr.assertIsNotInTx();
    }

    public static synchronized Semaphore getSbbEntityLock(String sbbEntityId) {
        Semaphore sem;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get Sbb Entity lock [ SbbEntity  = " + sbbEntityId + "]"));
        }
        if ((sem = (Semaphore)locks.get(sbbEntityId)) == null) {
            sem = new Semaphore(1L);
            locks.put(sbbEntityId, sem);
        }
        return sem;
    }

    private void handleActivityEndEvent(SleeEventImpl eventObject) throws SystemException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Got an activity end event");
        }
        boolean hasMore = false;
        Iterator iter = null;
        do {
            boolean txCommitted;
            SbbEntity rootSbbEntity;
            Exception caught;
            boolean invokeSbbRolledBack;
            block42: {
                invokeSbbRolledBack = false;
                caught = null;
                rootSbbEntity = null;
                SbbEntity sbbEntity = null;
                ActivityContext ac = null;
                String sbbEntityId = null;
                try {
                    try {
                        this.txMgr.begin();
                        if (iter == null) {
                            ac = this.container.getActivityContextFactory().getActivityContextById(eventObject.getActivityContextID());
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Activity Ending: attachment set is " + ac.getSbbAttachmentSetForDebug()));
                            }
                            iter = ac.getSortedCopyOfSbbAttachmentSet().iterator();
                        }
                        if ((hasMore = iter.hasNext()) && (sbbEntity = this.sbbEntityFactory.getSbbEntity(sbbEntityId = (String)iter.next())) != null) {
                            if (ac == null) {
                                ac = this.container.getActivityContextFactory().getActivityContextById(eventObject.getActivityContextID());
                            }
                            ac.detachSbbEntity(sbbEntityId);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Attachment Count " + sbbEntity.getAttachmentCount()));
                            }
                            if ((rootSbbEntity = this.sbbEntityFactory.getSbbEntity(sbbEntity.getRootSbbId())) != null && rootSbbEntity.getAttachmentCount() == 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Removing sbb entity tree.");
                                }
                                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                                try {
                                    Thread.currentThread().setContextClassLoader(rootSbbEntity.getSbbDescriptor().getClassLoader());
                                    rootSbbEntity.remove();
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                }
                            }
                        }
                        if (!(hasMore = iter.hasNext())) {
                            Object o = eventObject.getActivity();
                            if (o instanceof SleeActivityHandle) {
                                SleeActivityHandle sah = (SleeActivityHandle)eventObject.getActivity();
                                sah.getResourceAdaptor().activityEnded(sah.getHandle());
                            } else if (o instanceof NullActivityImpl) {
                                NullActivityFactoryImpl nullActivityFactory = this.container.getNullActivityFactory();
                                nullActivityFactory.removeNullActivity(ac.getActivityContextId());
                            }
                            this.doAfterActivityEndEvent(eventObject, ac);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failure while handling ActivityEndEvent. Event [" + eventObject + "]"), (Throwable)e);
                        caught = e;
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    txCommitted = false;
                    if (rootSbbEntity != null) {
                        invokeSbbRolledBack = this.handleRollback(null, null, caught, rootSbbEntity.getSbbDescriptor().getClassLoader());
                    }
                    try {
                        this.txMgr.commit();
                        txCommitted = true;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Problem committing transaction!", (Throwable)ex);
                    }
                    if (txCommitted && invokeSbbRolledBack) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Invoking sbbRolledBack for Remove Only");
                        }
                        try {
                            if (rootSbbEntity != null) {
                                this.handleSbbRolledBack(rootSbbEntity, null, null, rootSbbEntity.getSbbDescriptor().getClassLoader(), true);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            logger.debug((Object)"problem in handleSbbRolledBack processing! ", (Throwable)ex);
                        }
                    }
                    throw throwable;
                }
                txCommitted = false;
                if (rootSbbEntity != null) {
                    invokeSbbRolledBack = this.handleRollback(null, null, caught, rootSbbEntity.getSbbDescriptor().getClassLoader());
                }
                try {
                    this.txMgr.commit();
                    txCommitted = true;
                }
                catch (Exception ex) {
                    logger.error((Object)"Problem committing transaction!", (Throwable)ex);
                }
                if (!txCommitted || !invokeSbbRolledBack) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Invoking sbbRolledBack for Remove Only");
                }
                try {
                    if (rootSbbEntity == null) continue;
                    this.handleSbbRolledBack(rootSbbEntity, null, null, rootSbbEntity.getSbbDescriptor().getClassLoader(), true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    logger.debug((Object)"problem in handleSbbRolledBack processing! ", (Throwable)ex);
                }
                continue;
            }
            txCommitted = false;
            if (rootSbbEntity != null) {
                invokeSbbRolledBack = this.handleRollback(null, null, caught, rootSbbEntity.getSbbDescriptor().getClassLoader());
            }
            try {
                this.txMgr.commit();
                txCommitted = true;
            }
            catch (Exception ex) {
                logger.error((Object)"Problem committing transaction!", (Throwable)ex);
            }
            if (!txCommitted || !invokeSbbRolledBack) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking sbbRolledBack for Remove Only");
            }
            try {
                if (rootSbbEntity == null) continue;
                this.handleSbbRolledBack(rootSbbEntity, null, null, rootSbbEntity.getSbbDescriptor().getClassLoader(), true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.debug((Object)"problem in handleSbbRolledBack processing! ", (Throwable)ex);
            }
        } while (hasMore);
    }

    private void removeExecutor(Object activity) {
        QueuedExecutor exec;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeExecutor : " + activity));
        }
        if ((exec = (QueuedExecutor)this.executors.get(activity)) != null) {
            Thread.currentThread().setName("InActiveQueuedExecutor");
            this.executors.remove(activity);
        }
    }

    private void doAfterActivityEndEvent(SleeEventImpl eventObject, ActivityContext ac) throws UnrecognizedServiceException, SystemException, TransactionRequiredLocalException {
        this.txMgr.mandateTransaction();
        if (ac == null) {
            ac = this.container.getActivityContextFactory().getActivityContextById(eventObject.getActivityContextID());
        }
        if (ac.getActivity() instanceof ServiceActivity) {
            ServiceActivityImpl serviceActivity = (ServiceActivityImpl)ac.getActivity();
            ServiceID serviceID = serviceActivity.getService();
            Service service = null;
            try {
                service = this.container.getService(serviceID);
            }
            catch (UnrecognizedServiceException e) {
                logger.warn((Object)("service not found, service ID: " + serviceID), (Throwable)e);
                throw e;
            }
            catch (SystemException e) {
                logger.warn((Object)("failed to lookup service, service ID: " + serviceID), (Throwable)e);
                throw e;
            }
            ac.setState(ActivityContextState.INVALID);
            logger.info((Object)"Deactivating Service -- got activity end event on service activity");
            service.setState(ServiceState.INACTIVE);
        } else {
            if (ac.getActivity() instanceof ProfileTableActivity) {
                ProfileTableActivity profileTableActivity = (ProfileTableActivity)ac.getActivity();
                SleeProfileManager.getInstance().removeProfileAfterTableActivityEnd(profileTableActivity.getProfileTableName());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Detached sbbs");
            }
            ac.removeNamingBindings();
            ac.removeFromTimers();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Removed facilities");
            }
            ac.setState(ActivityContextState.INVALID);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"activity is now invalid");
            }
            this.container.getActivityContextFactory().removeActivityContext(ac.getActivityContextId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Removed it");
            }
        }
    }

    private SbbEntity findSbbEntityForDelivering(ActivityContext ac, EventTypeID eventTypeID) throws TransactionRequiredLocalException {
        this.txMgr.mandateTransaction();
        Iterator iter = ac.getSortedCopyOfSbbAttachmentSet().iterator();
        String sbbEntityId = null;
        SbbEntity sbbe = null;
        SbbEntity tempsbbe = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ATTACHMENT SET: " + ac.getSbbAttachmentSetForDebug()));
        }
        while (iter.hasNext()) {
            sbbEntityId = (String)iter.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sbbEntityId is " + sbbEntityId));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DELIVERED SET: " + ac.getDeliveredSetForDebug()));
            }
            if (ac.deliveredSetContains(sbbEntityId)) continue;
            tempsbbe = this.sbbEntityFactory.getSbbEntity(sbbEntityId);
            Set ret = tempsbbe.getReceivedEventTypes();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received Event Types : " + ret));
            }
            if (!ret.contains(eventTypeID)) continue;
            sbbe = tempsbbe;
            break;
        }
        return sbbe;
    }

    private class EventPosting {
        private EventTypeID eventTypeID;
        private Object event;
        private Object activity;
        private Address address;

        public EventPosting(EventTypeID eventTypeID, Object event, Object activity, Address address) {
            this.eventTypeID = eventTypeID;
            this.event = event;
            this.activity = activity;
            this.address = address;
        }

        public EventTypeID getEventTypeID() {
            return this.eventTypeID;
        }

        public Object getEvent() {
            return this.event;
        }

        public Object getActivity() {
            return this.activity;
        }

        public Address getAddress() {
            return this.address;
        }

        public String toString() {
            return "eventTypeId:" + this.eventTypeID + ", event:" + this.event + ", activity:" + this.activity + ", address:" + this.address;
        }
    }

    public class EventExecutor
    implements Runnable {
        private EventPosting ep;
        private int etsPriority;

        EventExecutor(EventPosting ep) {
            this.ep = ep;
        }

        public void run() {
            try {
                EventRouterImpl.this.txMgr.assertIsNotInTx();
                EventRouterImpl.this.routeQueuedEvent(this.ep);
                if (!EventRouterImpl.this.container.getSleeState().equals((Object)SleeState.STOPPED) && this.ep.getActivity() instanceof SleeActivityHandle) {
                    SleeActivityHandle sah = (SleeActivityHandle)this.ep.getActivity();
                    sah.getResourceAdaptor().eventProcessingSuccessful(sah.getHandle(), this.ep.getEvent(), EventRouterImpl.this.container.getEventLookupFacility().getEventID(((EventTypeIDImpl)this.ep.getEventTypeID()).getComponentKey()), this.ep.address, 0);
                }
                EventRouterImpl.this.txMgr.assertIsNotInTx();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to route event: " + this.ep.getEvent() + " of type " + this.ep.getEventTypeID()), (Throwable)e);
            }
        }

        public int getPriority() {
            return this.etsPriority;
        }

        public Object getActivity() {
            return this.ep.activity;
        }
    }

    private class ReRoute
    implements TransactionalAction {
        EventPosting ep;

        public ReRoute(EventPosting ep) {
            this.ep = ep;
        }

        public void execute() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rerouting event ");
            }
            if (this.ep != null) {
                EventExecutor ee = new EventExecutor(this.ep);
                try {
                    QueuedExecutor queue = EventRouterImpl.this.getExecutor(this.ep.activity);
                    queue.execute((Runnable)ee);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"FINISHED reRouteEvent ");
            }
        }
    }
}

