/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import javax.slee.NoSuchObjectLocalException;
import javax.slee.SLEEException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.TransactionRolledbackLocalException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectConcrete;

public class SbbLocalObjectImpl
implements SbbLocalObject,
SbbLocalObjectConcrete {
    private ClassLoader contextClassLoader;
    private String sbbEntityId;
    private SleeContainer sleeContainer;
    private static Logger logger = Logger.getLogger(SbbLocalObjectImpl.class);
    private boolean rollbackOnly;
    private boolean isRemoved;

    public SbbLocalObjectImpl() {
    }

    protected SbbEntity getSbbEntity() {
        return this.sleeContainer.getSbbEntityFactory().getSbbEntity(this.sbbEntityId);
    }

    public SbbLocalObjectImpl(SleeContainer container, String sbbeId) {
        this();
        this.sleeContainer = container;
        this.sbbEntityId = sbbeId;
    }

    public SbbLocalObjectImpl(SleeContainer container, SbbEntity sbbEntity) {
        this();
        this.sleeContainer = container;
        this.sbbEntityId = sbbEntity.getSbbEntityId();
        this.contextClassLoader = sbbEntity.getSbbDescriptor().getClassLoader();
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public SbbLocalObjectImpl(SbbEntity sbbEntity) {
        this();
        this.sleeContainer = sbbEntity.getServiceContainer();
        this.contextClassLoader = sbbEntity.getSbbDescriptor().getClassLoader();
        this.sbbEntityId = sbbEntity.getSbbEntityId();
        if (sbbEntity.getSbbObject() == null) {
            try {
                sbbEntity.assignAndActivateSbbObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sbbLocalObject created for sbbEntity " + sbbEntity.getSbbEntityId()));
        }
    }

    public byte getSbbPriority() throws TransactionRequiredLocalException, NoSuchObjectLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.rollbackOnly) {
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException ex) {
                throw new SLEEException("unable to set rollbackOnly in transaction manager", (Throwable)ex);
            }
            throw new TransactionRolledbackLocalException("Unable to proceed, transaction is set to rollback");
        }
        if (this.isRemoved) {
            throw new NoSuchObjectLocalException("sbb local object is removed");
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        return this.getSbbEntity().getPriority();
    }

    public boolean isIdentical(SbbLocalObject obj) throws TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.rollbackOnly) {
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException ex) {
                throw new SLEEException("unable to set rollbackOnly in transaction manager", (Throwable)ex);
            }
            throw new TransactionRolledbackLocalException("Unable to proceed, transaction is set to rollback");
        }
        if (this.isRemoved) {
            throw new NoSuchObjectLocalException("sbb local object is removed");
        }
        return this.getClass().equals(obj.getClass()) && this.getSbbEntityId().equals(((SbbLocalObjectImpl)obj).getSbbEntityId());
    }

    public void remove() throws TransactionRequiredLocalException, NoSuchObjectLocalException, SLEEException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove() called on sbbLocalObject " + this.getSbbEntityId() + " isRollback = " + this.rollbackOnly + " isRemoved = " + this.isRemoved));
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.rollbackOnly) {
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException ex) {
                throw new SLEEException("unable to set rollbackOnly in transaction manager", (Throwable)ex);
            }
            throw new TransactionRolledbackLocalException("Unable to proceed, transaction is set to rollback");
        }
        if (this.isRemoved) {
            throw new NoSuchObjectLocalException("sbb local object is removed");
        }
        SbbEntity sbbEntity = this.getSbbEntity();
        sbbEntity.checkReEntrant();
        sbbEntity.nonSleeInitiatedCascadingRemoval();
        this.rollbackOnly = true;
        this.isRemoved = true;
    }

    public void setSbbPriority(byte priority) throws TransactionRequiredLocalException, NoSuchObjectLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.rollbackOnly) {
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException ex) {
                throw new SLEEException("unable to set rollbackOnly in transaction manager", (Throwable)ex);
            }
            try {
                SbbContext ctx = (SbbContext)SleeContainer.getTransactionManager().getTxLocalData("sbb_context");
                ctx.setRollbackOnly();
            }
            catch (Exception ex) {
                throw new SLEEException("Failed to get sbb context", (Throwable)ex);
            }
            throw new TransactionRolledbackLocalException("Could not set sbb priority");
        }
        if (this.isRemoved) {
            throw new NoSuchObjectLocalException("sbb local object is removed");
        }
        this.getSbbEntity().setPriority(priority);
    }

    public boolean equals(Object other) {
        return other.getClass().equals(SbbLocalObjectImpl.class) && this.isIdentical((SbbLocalObjectImpl)other);
    }

    public String getSbbEntityId() {
        return this.sbbEntityId;
    }
}

