/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbID;
import javax.slee.TransactionRequiredLocalException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.runtime.SbbConcrete;
import org.mobicents.slee.runtime.SbbContextImpl;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbInvocationState;
import org.mobicents.slee.runtime.SbbObjectState;

public class SbbObject
implements Serializable {
    private transient SbbObjectState state;
    private transient SbbInvocationState invocationState = SbbInvocationState.NOT_INVOKING;
    private static transient Logger log = Logger.getLogger(SbbEntity.class);
    private SbbID sbbID;
    private String sbbEntityID;
    private SbbConcrete sbbConcrete;
    private LinkedList invocationSeq;
    private MobicentsSbbDescriptor sbbDescriptor;
    private SbbContextImpl sbbContext;
    private transient SleeContainer serviceContainer;

    public SbbObject(SleeContainer serviceContainer, MobicentsSbbDescriptor sbbDescriptor) {
        log = Logger.getLogger(this.getClass());
        this.serviceContainer = serviceContainer;
        this.sbbDescriptor = sbbDescriptor;
        this.sbbID = (SbbID)sbbDescriptor.getID();
        this.createConcreteClass();
        this.invocationSeq = new LinkedList();
    }

    public void setSbbEntity(SbbEntity sbbe) {
        this.sbbEntityID = sbbe.getSbbEntityId();
        this.sbbConcrete.setSbbEntity(sbbe);
        this.setDefaultUsageParameterSet(sbbe);
        this.setUsageParameterTable(sbbe);
    }

    public SbbEntity getSbbEntity() throws TransactionRequiredLocalException {
        SleeContainer.getTransactionManager().mandateTransaction();
        return this.serviceContainer.getSbbEntityFactory().getSbbEntity(this.sbbEntityID);
    }

    public SbbObjectState getState() {
        return this.state;
    }

    public SbbInvocationState getInvocationState() {
        return this.invocationState;
    }

    public void setSbbInvocationState(SbbInvocationState state) {
        this.invocationState = state;
    }

    public void setState(SbbObjectState state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setState: current state = " + this.getState() + " new state = " + state));
        }
        this.state = state;
        if (this.sbbConcrete != null) {
            this.sbbConcrete.setState(state);
        }
        if (log.isDebugEnabled()) {
            this.invocationSeq.add(state);
        }
    }

    public Sbb getSbbConcrete() {
        return this.sbbConcrete;
    }

    public SbbContextImpl getSbbContext() {
        return this.sbbContext;
    }

    public void setSbbContext(SbbContextImpl sbbContext) {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setSbbContext " + this.getSbbID()));
            }
            if (sbbContext == null) {
                throw new NullPointerException("null arg!");
            }
            try {
                this.sbbContext = sbbContext;
                this.sbbConcrete.setSbbContext(this.sbbContext);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Exception encountered while setting sbb context ", (Throwable)ex);
            }
        }
    }

    public MobicentsSbbDescriptor getSbbDescriptor() {
        return this.sbbDescriptor;
    }

    public Set getInitalEventTypes() {
        return this.sbbDescriptor.getInitialEventTypes();
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
        if (this.getState() != SbbObjectState.POOLED && log.isDebugEnabled()) {
            log.error((Object)("unsetSbbContext: should be called from pooled state current state is " + this.getState()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unsetSbbContext " + this.getSbbID()));
        }
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        try {
            final ClassLoader cl = this.sbbDescriptor.getClassLoader();
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (this.sbbConcrete != null) {
                this.sbbConcrete.unsetSbbContext();
            }
        }
        catch (Throwable throwable) {
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                    private final /* synthetic */ ClassLoader val$oldClassLoader;
                    {
                        this.val$oldClassLoader = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void sbbCreate() throws CreateException {
        if (this.getState() != SbbObjectState.POOLED) {
            log.warn((Object)("sbbCreate: should be pooled state was " + this.getState()));
        }
        this.invocationState = SbbInvocationState.INVOKING_SBB_CREATE;
        if (log.isDebugEnabled()) {
            this.invocationSeq.add("CREATE");
        }
        this.sbbConcrete.sbbCreate();
        this.invocationState = SbbInvocationState.NOT_INVOKING;
    }

    public void sbbPostCreate() throws CreateException {
        this.invocationState = SbbInvocationState.INVOKING_SBB_POSTCREATE;
        if (log.isDebugEnabled()) {
            this.invocationSeq.add("POST CREATE");
        }
        this.sbbConcrete.sbbPostCreate();
        this.invocationState = SbbInvocationState.NOT_INVOKING;
    }

    public void sbbActivate() {
        if (this.getState() != SbbObjectState.POOLED) {
            log.warn((Object)("wrong state -- expected POOLED  was " + this.getState()));
        }
        if (log.isDebugEnabled()) {
            this.invocationSeq.add("ACTIVATE");
        }
        this.sbbConcrete.sbbActivate();
    }

    public void sbbPassivate() {
        if (log.isDebugEnabled()) {
            this.invocationSeq.add("PASSIVATE");
        }
        this.sbbConcrete.sbbPassivate();
    }

    public void sbbLoad() throws TransactionRequiredLocalException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.getState() != SbbObjectState.READY) {
            log.warn((Object)("sbbLoad called from wrong state should be READY was " + this.getState()));
        }
        this.invocationState = SbbInvocationState.INVOKING_SBB_LOAD;
        if (log.isDebugEnabled()) {
            this.invocationSeq.add("LOAD");
        }
        this.sbbConcrete.sbbLoad();
        this.invocationState = SbbInvocationState.NOT_INVOKING;
    }

    public void sbbStore() {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.getState() != SbbObjectState.READY) {
            log.warn((Object)("sbbStore called from wrong state should be READY was " + this.getState()));
        }
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        if (this.sbbConcrete != null) {
            final ClassLoader cl = this.sbbDescriptor.getClassLoader();
            try {
                if (SleeContainer.isSecurityEnabled()) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(cl);
                            return null;
                        }
                    });
                } else {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.sbbConcrete != null) {
                    this.invocationState = SbbInvocationState.INVOKING_SBB_STORE;
                    this.sbbConcrete.sbbStore();
                    this.invocationState = SbbInvocationState.NOT_INVOKING;
                    if (log.isDebugEnabled()) {
                        this.invocationSeq.add("STORE");
                        log.debug((Object)"Called sbbStore!");
                    }
                } else {
                    log.error((Object)"sbbStore not called: concrete sbb is null");
                }
            }
            catch (Throwable throwable) {
                if (SleeContainer.isSecurityEnabled()) {
                    AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                        private final /* synthetic */ ClassLoader val$oldClassLoader;
                        {
                            this.val$oldClassLoader = classLoader;
                        }

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                            return null;
                        }
                    });
                } else {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                throw throwable;
            }
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            } else {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public void sbbExceptionThrown(Exception exception, Object eventObject, ActivityContextInterface activityContextInterface) {
        this.getSbbContext().setRollbackOnly();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.sbbDescriptor.getClassLoader());
            this.sbbConcrete.sbbExceptionThrown(exception, eventObject, activityContextInterface);
            if (log.isDebugEnabled()) {
                this.invocationSeq.add("EXCEPTION THROWN");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public SbbID getSbbID() {
        return (SbbID)this.sbbDescriptor.getID();
    }

    public void setSbbID(SbbID sbbID) {
        this.sbbID = sbbID;
    }

    public void sbbRolledBack(RolledBackContext sbbRolledBackContext) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.sbbDescriptor.getClassLoader());
            this.sbbConcrete.sbbRolledBack(sbbRolledBackContext);
            if (log.isDebugEnabled()) {
                this.invocationSeq.add("ROLLED BACK");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void sbbRemove() {
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        try {
            final ClassLoader cl = this.sbbDescriptor.getClassLoader();
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (this.sbbConcrete != null) {
                this.sbbConcrete.sbbRemove();
                if (log.isDebugEnabled()) {
                    this.invocationSeq.add("REMOVE");
                    log.debug((Object)"Called sbbRemove");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"sbbRemove not called: concrete sbb is null");
            }
        }
        catch (Throwable throwable) {
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                    private final /* synthetic */ ClassLoader val$oldClassLoader;
                    {
                        this.val$oldClassLoader = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void setDefaultUsageParameterSet(SbbEntity sbbe) {
        try {
            Object usageParameterSet = sbbe.getDefaultSbbUsageParameterSet();
            if (usageParameterSet != null) {
                String usageParameterInterfaceName = this.getSbbDescriptor().getUsageParametersInterface();
                Class<?> usageParameterInterfaceClass = SleeContainerUtils.getCurrentThreadClassLoader().loadClass(usageParameterInterfaceName);
                Class<?> concreteClass = this.sbbConcrete.getClass();
                Method setter = concreteClass.getMethod("sbbSetDefaultUsageParameter", usageParameterInterfaceClass);
                setter.invoke((Object)this.sbbConcrete, usageParameterSet);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected Exception while setting default usage parameters", ex);
        }
    }

    private void setUsageParameterTable(SbbEntity sbbe) {
        HashMap usageParameterTable = Service.getUsageParameterTable(sbbe.getServiceId());
        this.sbbConcrete.sbbSetNamedUsageParameterTable(usageParameterTable);
    }

    private void createConcreteClass() {
        try {
            this.sbbConcrete = (SbbConcrete)this.sbbDescriptor.getConcreteSbbClass().newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)"unexpected exception creating concrete class!", (Throwable)ex);
            throw new RuntimeException("Unexpected exception creating concrete class for " + this.sbbID, ex);
        }
    }

    public void printInvocationSeq() {
        Iterator i = this.invocationSeq.iterator();
        String str = new String();
        while (i.hasNext()) {
            str = String.valueOf(str) + i.next().toString() + "\n";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("INVOCATION OF LIFECYCLE METHOD FOR COMPONENT: " + this.sbbID + "\n" + str));
        }
    }
}

