/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.slee.SbbID;
import org.apache.commons.pool.PoolableObjectFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.runtime.SbbContextImpl;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SbbObjectState;

public class SbbObjectPoolFactory
implements PoolableObjectFactory {
    private SbbID sbbId;
    private static Logger logger = Logger.getLogger((String)"org.mobicents.slee.runtime.SbbObjectPoolFactory");
    private SleeContainer serviceContainer;

    public SbbObjectPoolFactory(SbbID id, SleeContainer serviceContainer) {
        this.sbbId = id;
        this.serviceContainer = serviceContainer;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object sbb) throws Exception {
        SbbObject sbbObject = (SbbObject)sbb;
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Calling unsetSbbContext");
            }
            if (!sbbObject.getState().equals(SbbObjectState.DOES_NOT_EXIST)) {
                sbbObject.unsetSbbContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Called unsetSbbContext");
                }
            }
        }
        catch (Throwable throwable) {
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                    private final /* synthetic */ ClassLoader val$oldClassLoader;
                    {
                        this.val$oldClassLoader = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        sbbObject.setState(SbbObjectState.DOES_NOT_EXIST);
    }

    public Object makeObject() {
        SbbObject retval;
        MobicentsSbbDescriptor sbbDescriptor = (MobicentsSbbDescriptor)this.serviceContainer.getSbbComponent(this.sbbId);
        if (sbbDescriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("null descriptor retrieved for " + this.sbbId));
            }
            throw new NullPointerException("null descriptor!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sbbDescriptor.getConcreteSbbClass());
        }
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        try {
            final ClassLoader cl = sbbDescriptor.getClassLoader();
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Calling setSbbContext");
            }
            retval = new SbbObject(this.serviceContainer, sbbDescriptor);
            retval.setSbbContext(new SbbContextImpl(retval, this.serviceContainer));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Called setSbbContext");
            }
        }
        catch (Throwable throwable) {
            if (SleeContainer.isSecurityEnabled()) {
                AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                    private final /* synthetic */ ClassLoader val$oldClassLoader;
                    {
                        this.val$oldClassLoader = classLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                        return null;
                    }
                });
            } else {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        retval.setState(SbbObjectState.POOLED);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("making object: " + retval));
        }
        return retval;
    }

    public void passivateObject(Object sbb) throws Exception {
        SbbObject sbbObj = (SbbObject)sbb;
        sbbObj.setState(SbbObjectState.POOLED);
        if (logger.isDebugEnabled()) {
            sbbObj.printInvocationSeq();
        }
    }

    public boolean validateObject(Object sbbo) {
        boolean retval = ((SbbObject)sbbo).getState() == SbbObjectState.POOLED;
        logger.debug((Object)("vaidateObject returning " + retval));
        return retval;
    }
}

