/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

public class VersionedEntry {
    private Object key = null;
    private Object value = null;
    private boolean isDirty = false;
    private long version = 0L;
    private boolean isRemoved = false;

    private VersionedEntry() {
    }

    public VersionedEntry(VersionedEntry originalEntry) {
        this.key = originalEntry.key;
        this.value = originalEntry.value;
        this.isRemoved = originalEntry.isRemoved;
        this.version = originalEntry.version + 1L;
    }

    public VersionedEntry(Object key, Object val) {
        this.key = key;
        this.value = val;
        this.isDirty = true;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.isRemoved) {
            throw new IllegalStateException("cannot get value for a removed entry");
        }
        return this.value;
    }

    public void setValue(Object val) {
        this.isDirty = true;
        this.isRemoved = false;
        this.value = val;
    }

    public long getVersion() {
        return this.version;
    }

    public void markRemoved() {
        this.isDirty = true;
        this.isRemoved = true;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isNewerVersion(VersionedEntry other) {
        return this.version > other.getVersion();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String toString() {
        String result = "VersionedEntry: {\n  key       : " + this.key + "\n  version   : " + this.version + "\n  value     : " + this.value + "\n  isRemoved : " + this.isRemoved + "\n}";
        return result;
    }
}

