/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.mobicents.slee.runtime.cache.AbstractXAResource;
import org.mobicents.slee.runtime.cache.TxLocalMap;
import org.mobicents.slee.runtime.cache.VersionedEntry;
import org.mobicents.slee.runtime.cache.XACache;

public class XACacheXAManager
extends AbstractXAResource {
    Transaction tx = null;
    XACache xaCache = null;
    private static Logger logger = Logger.getLogger((String)XACacheXAManager.class.getName());

    XACacheXAManager(Transaction tx, XACache xacache) {
        assert (tx != null) : "transaction cannot be null";
        assert (xacache != null) : "xacache cannot be null";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering as XAResource for tx[" + tx + "]"));
        }
        this.tx = tx;
        this.xaCache = xacache;
    }

    public void end(Xid xid, int flags) throws XAException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction end. tx[" + this.tx + "], xid[" + xid + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Map txLocalView = this.xaCache.getTxLocalView(this.tx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction commit. tx[" + this.tx + "], xid[" + xid + "]"));
        }
        if (txLocalView == null) {
            logger.warn((Object)("txLocalView is null for tx[" + this.tx + "], xid[" + xid + "]\n" + "This should never happen. \n" + "If a CacheXAManager was registered with a tx, \n" + "that is only because there was access to a map strucure in the tx context."));
            return;
        }
        Map actualMaps = this.xaCache.getActualMaps();
        try {
            Map map = actualMaps;
            synchronized (map) {
                Map actualMap;
                TxLocalMap nextLocalMap;
                boolean verificationFailed = false;
                Iterator mapsIter = txLocalView.entrySet().iterator();
                while (mapsIter.hasNext() && !verificationFailed) {
                    Map.Entry entry = mapsIter.next();
                    nextLocalMap = (TxLocalMap)entry.getValue();
                    actualMap = (Map)actualMaps.get(entry.getKey());
                    boolean bl = verificationFailed = !this.verifyMap(entry.getKey(), nextLocalMap, actualMap);
                }
                if (verificationFailed) {
                    throw new XAException(6);
                }
                for (Map.Entry entry : txLocalView.entrySet()) {
                    nextLocalMap = (TxLocalMap)entry.getValue();
                    actualMap = (Map)actualMaps.get(entry.getKey());
                    if (nextLocalMap.isRemoved()) {
                        actualMaps.remove(entry.getKey());
                        continue;
                    }
                    this.commitMapChanges(entry.getKey(), nextLocalMap, actualMap);
                }
            }
        }
        finally {
            this.xaCache.removeTxLocalView(this.tx);
        }
    }

    private boolean verifyMap(Object mapKey, TxLocalMap localMap, Map actualMap) {
        if (localMap.isRemoved()) {
            return true;
        }
        boolean actualMapRemoved = false;
        if (actualMap == null) {
            actualMapRemoved = true;
        }
        Set txLocalEntries = localMap.entrySet();
        Iterator iter = txLocalEntries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            VersionedEntry txLocalEntry = (VersionedEntry)entry.getValue();
            if (!txLocalEntry.isDirty()) {
                iter.remove();
                continue;
            }
            if (actualMapRemoved) {
                this.xaCache.getActualMap(mapKey);
                return true;
            }
            VersionedEntry actualEntry = (VersionedEntry)actualMap.get(entry.getKey());
            if (actualEntry == null || txLocalEntry.isNewerVersion(actualEntry)) continue;
            if (!txLocalEntry.getValue().equals(actualEntry.getValue())) {
                logger.warn((Object)("Failed to commit XACache writes in tx[" + this.tx + ".\n" + "Reason: Entry version verification failed for Map[" + mapKey + "].\n" + "Reason: Committing entry is not newer version than the actual entry's version.\n" + " entry key[" + entry.getKey() + "]\n" + " committing entry version[" + txLocalEntry.getVersion() + "]\n" + " committing entry value[" + txLocalEntry.getValue() + "]\n" + " actual entry version[" + actualEntry.getVersion() + "].\n" + " actual entry value[" + actualEntry.getValue() + "]"));
                return false;
            }
            iter.remove();
        }
        return true;
    }

    private void commitMapChanges(Object mapKey, TxLocalMap txLocalMap, Map actualMap) {
        Set txLocalEntries = txLocalMap.entrySet();
        for (Map.Entry entry : txLocalEntries) {
            VersionedEntry txLocalEntry = (VersionedEntry)entry.getValue();
            VersionedEntry actualEntry = (VersionedEntry)actualMap.get(entry.getKey());
            if (actualEntry == null) {
                if (txLocalEntry.isRemoved()) continue;
                actualMap.put(entry.getKey(), txLocalEntry);
                continue;
            }
            if (txLocalEntry.isRemoved()) {
                actualMap.remove(entry.getKey());
                continue;
            }
            if (txLocalEntry.getValue().equals(actualEntry.getValue())) continue;
            actualMap.put(entry.getKey(), txLocalEntry);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction rollback. tx[" + this.tx + "], xid[" + xid + "]"));
        }
        this.xaCache.removeTxLocalView(this.tx);
    }
}

