/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache.tests;

import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.cache.XACache;
import org.mobicents.slee.runtime.cache.tests.TransactionManagerMockup;
import org.mobicents.slee.runtime.cache.tests.TransactionMockup;

public class ZCacheableSetAndMapEqualsTest
extends TestCase {
    private TransactionManagerMockup txm = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.txm = new TransactionManagerMockup();
        XACache.setTransactionManager(this.txm);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(ZCacheableSetAndMapEqualsTest.class);
    }

    public void testCacheableMapEquality() throws Exception {
        TransactionMockup tx1 = new TransactionMockup();
        TransactionMockup tx2 = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx1);
        this.txm.pushCurrentTransaction(tx2);
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction currentTX = this.txm.getTransaction();
        CacheableMap map1 = new CacheableMap("TEST_1_MAP");
        map1.put("ENTRY", "VALUE");
        currentTX.commit();
        this.txm.popCurrentTransaction();
        tx1 = this.txm.getTransaction();
        map1 = new CacheableMap("TEST_1_MAP");
        this.txm.popCurrentTransaction();
        tx2 = this.txm.getTransaction();
        CacheableMap map2 = new CacheableMap("TEST_1_MAP");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Maps should be equal even if they do not contain local copies of entires", (boolean)map1.equals(map2));
        map1.containsKey("ENTRY");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Maps should be equal even if one contains local copy of entries", (boolean)map1.equals(map2));
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Maps should be equal even if one contains local copy of entries", (boolean)map2.equals(map1));
        map2.containsKey("ENTRY");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Maps should be equal.", (boolean)map1.equals(map2));
        tx1.commit();
        map2.remove();
        tx2.commit();
    }

    public void testCacheableSetEquality() throws Exception {
        this.txm.pushCurrentTransaction(new TransactionMockup());
        this.txm.pushCurrentTransaction(new TransactionMockup());
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction currentTX = this.txm.getTransaction();
        CacheableSet set1 = new CacheableSet("TEST_1_SET");
        set1.add("ENTRY");
        currentTX.commit();
        this.txm.popCurrentTransaction();
        Transaction tx1 = this.txm.getTransaction();
        set1 = new CacheableSet("TEST_1_SET");
        this.txm.popCurrentTransaction();
        Transaction tx2 = this.txm.getTransaction();
        CacheableSet set2 = new CacheableSet("TEST_1_SET");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Sets should be equal even if they do not contain local copies of entires", (boolean)set1.equals(set2));
        set1.contains("ENTRY");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Sets should be equal even if one contains local copy of entries", (boolean)set1.equals(set2));
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Sets should be equal even if one contains local copy of entries", (boolean)set2.equals(set1));
        set2.contains("ENTRY");
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Sets should be equal.", (boolean)set1.equals(set2));
        tx1.commit();
        set2.remove();
        tx2.commit();
    }

    public void testCacheableSetConcurrentAccess() throws Exception {
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx1 = this.txm.getTransaction();
        CacheableMap setEntry = new CacheableMap("SETENTRY");
        setEntry.put("KEY", "STRINGENTRY");
        CacheableSet set = new CacheableSet("SET");
        set.add(setEntry);
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx2 = this.txm.getTransaction();
        setEntry = new CacheableMap("SETENTRY");
        setEntry.put("KEY", "STRINGENTRY");
        set = new CacheableSet("SET");
        set.add(setEntry);
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx3 = this.txm.getTransaction();
        setEntry = new CacheableMap("SETENTRY");
        setEntry.put("KEY", "ANOTHERSTRINGENTRY");
        set = new CacheableSet("SET");
        set.add(setEntry);
        tx1.commit();
        tx2.commit();
        boolean exceptionThrown = false;
        try {
            tx3.commit();
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Exception should be thrown when commiting a different set on a not newer tx", (boolean)exceptionThrown);
        this.txm.pushCurrentTransaction(new TransactionMockup());
        set = new CacheableSet("SET");
        set.remove();
        this.txm.getTransaction().commit();
    }

    public void testCacheableMapConcurrentAccess() throws Exception {
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx1 = this.txm.getTransaction();
        CacheableMap map = new CacheableMap("MAP");
        CacheableMap mapEntry = new CacheableMap("MAPENTRY");
        map.put("KEY", mapEntry);
        mapEntry.put("KEY", "STRINGENTRY");
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx2 = this.txm.getTransaction();
        map = new CacheableMap("MAP");
        mapEntry = new CacheableMap("MAPENTRY");
        map.put("KEY", mapEntry);
        mapEntry.put("KEY", "STRINGENTRY");
        this.txm.pushCurrentTransaction(new TransactionMockup());
        Transaction tx3 = this.txm.getTransaction();
        map = new CacheableMap("MAP");
        mapEntry = new CacheableMap("MAPENTRY");
        map.put("KEY", mapEntry);
        mapEntry.put("KEY", "ANOTHERSTRINGENTRY");
        tx1.commit();
        tx2.commit();
        boolean exceptionThrown = false;
        try {
            tx3.commit();
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        ZCacheableSetAndMapEqualsTest.assertTrue((String)"Exception should be thrown when commiting a different map on a not newer tx", (boolean)exceptionThrown);
        this.txm.pushCurrentTransaction(new TransactionMockup());
        map = new CacheableMap("MAP");
        map.remove();
        this.txm.getTransaction().commit();
    }
}

