/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache.tests;

import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.XACache;
import org.mobicents.slee.runtime.cache.tests.TransactionManagerMockup;
import org.mobicents.slee.runtime.cache.tests.TransactionMockup;

public class ZConcurrencyCacheableMapTest
extends TestCase {
    private TransactionManagerMockup txm = null;
    private CacheableMap cmap = null;

    public ZConcurrencyCacheableMapTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ZConcurrencyCacheableMapTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.txm = new TransactionManagerMockup();
        TransactionMockup tx = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx);
        XACache.setTransactionManager(this.txm);
        this.cmap = new CacheableMap("testMap");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testWriteInTx1CommitReadInTx2() throws Exception {
        String key1 = "key-testWriteInTx1CommitReadInTx2";
        String val1 = "value1";
        this.cmap.put(key1, "value1");
        Transaction tx = this.txm.getTransaction();
        tx.commit();
        this.txm.pushCurrentTransaction(new TransactionMockup());
        CacheableMap cmap2 = new CacheableMap("testMap");
        Object val2 = cmap2.get(key1);
        ZConcurrencyCacheableMapTest.assertEquals((String)"entry written in tx 1 should be visible in tx 2", (Object)val1, val2);
    }

    public void testPutRemoveCommitRead() throws Exception {
        String key1 = "key1-testPutRemoveCommitRead";
        String key2 = "key2-testPutRemoveCommitRead";
        String val1 = "value1";
        String val2 = "value2";
        this.cmap.put(key1, val1);
        this.cmap.put(key2, val2);
        this.cmap.remove();
        Transaction tx = this.txm.getTransaction();
        tx.commit();
        this.txm.pushCurrentTransaction(new TransactionMockup());
        CacheableMap cmap2 = new CacheableMap("testMap");
        val1 = cmap2.get(key1);
        val2 = cmap2.get(key2);
        ZConcurrencyCacheableMapTest.assertNull((String)"entry written in tx 1 in a map that is removed in tx 1 should not be be visible in tx 2", (Object)val1);
        ZConcurrencyCacheableMapTest.assertNull((String)"entry written in tx 1 in a map that is removed in tx 1 should not be be visible in tx 2", (Object)val2);
    }

    public void testPutNullCommitRead() throws Exception {
        String key1 = "key1-testPutRemoveCommitRead";
        this.cmap.put(key1, (Object)null);
        Transaction tx = this.txm.getTransaction();
        tx.commit();
        this.txm.pushCurrentTransaction(new TransactionMockup());
        CacheableMap cmap2 = new CacheableMap("testMap");
        boolean nullValueFound = cmap2.containsKey(key1);
        ZConcurrencyCacheableMapTest.assertTrue((String)"null value entry written in tx 1 should be visible as null in tx 2", (boolean)nullValueFound);
        Object val = cmap2.get(key1);
        ZConcurrencyCacheableMapTest.assertNull((String)"null value entry written in tx 1 should exist as null in tx 2", val);
    }

    public void testWriteInTx1RollbackReadInTx2() throws Exception {
        String val1 = "value1";
        String key1 = "key-testWriteInTx1RollbackReadInTx2";
        boolean found1 = this.cmap.containsKey(key1);
        ZConcurrencyCacheableMapTest.assertFalse((String)"key1 should not be found, because it hasn't been inserted yet.", (boolean)found1);
        this.cmap.put("key1", val1);
        Transaction tx = this.txm.getTransaction();
        tx.rollback();
        this.txm.pushCurrentTransaction(new TransactionMockup());
        CacheableMap cmap2 = new CacheableMap("testMap");
        boolean found2 = cmap2.containsKey(key1);
        ZConcurrencyCacheableMapTest.assertFalse((String)"entry written in tx 1, which then rolled back, should not be visible in tx 2", (boolean)found2);
    }

    public void testPhantomReadsDisallowed() throws Exception {
        String key1 = "key1-testPutRemoveCommitRead";
        String key2 = "key2-testPutRemoveCommitRead";
        String val1 = "value1";
        String val2 = "value2";
        this.cmap.setAllowPhantomReads(false);
        this.cmap.put(key1, val1);
        boolean real = this.cmap.containsKey(key1);
        ZConcurrencyCacheableMapTest.assertTrue((String)"key 1 was written in tx 1 and it shoud be still visible", (boolean)real);
        TransactionMockup tx2 = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx2);
        CacheableMap cmap2 = new CacheableMap("testMap");
        cmap2.put(key2, val2);
        tx2.commit();
        this.txm.popCurrentTransaction();
        boolean phantom = this.cmap.containsKey(key2);
        ZConcurrencyCacheableMapTest.assertFalse((String)"key 2 was written in tx 2 after tx 1 started and it shoud be therefore invisible", (boolean)phantom);
    }

    public void testWriteRemoveCommitRead() throws Exception {
        String key1 = "key1-testPutRemoveCommitRead";
        String val1 = "value1";
        this.cmap.put(key1, val1);
        this.cmap.remove();
        Transaction tx = this.txm.getTransaction();
        tx.commit();
        TransactionMockup tx2 = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx2);
        CacheableMap cmap2 = new CacheableMap("testMap");
        boolean removedFound = cmap2.containsKey(key1);
        tx2.commit();
        this.txm.popCurrentTransaction();
        ZConcurrencyCacheableMapTest.assertFalse((String)"key 1 was written and removed in tx 1 which committed, it should not be visible in tx 2 ", (boolean)removedFound);
    }
}

