/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.cache.XACache;
import org.mobicents.slee.runtime.cache.tests.TransactionManagerMockup;
import org.mobicents.slee.runtime.cache.tests.TransactionMockup;

public class ZXACacheTest
extends TestCase {
    private TransactionManagerMockup txm = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.txm = new TransactionManagerMockup();
        TransactionMockup tx = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx);
        XACache.setTransactionManager(this.txm);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ZXACacheTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ZXACacheTest.class);
    }

    public void testNewCacheableMapInstance() {
        new CacheableMap("mapKey1");
    }

    public void testNewCMapForNullKey() {
        try {
            new CacheableMap(null);
            ZXACacheTest.fail((String)"new CacheableMap(null) should throw NPE. Map key cannot be null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNewCSet() {
        new CacheableSet("setKey1");
    }

    public void testNewCSetForNullKey() {
        try {
            new CacheableSet(null);
            ZXACacheTest.fail((String)"new CacheableSet(null) should throw NPE. Set key cannot be null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetMapWithoutTransaction() {
        this.txm.pushCurrentTransaction(null);
        new CacheableMap("key1");
    }
}

