/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import javax.slee.facilities.TimerID;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class NullActivityContext
extends ActivityContext {
    private static transient Logger logger = Logger.getLogger(NullActivityContext.class);
    private static final String tcache = TransactionManagerImpl.RUNTIME_CACHE;
    private static final String txLocalNullACEndCheckKey = "tx-local-flag-NullActivityContextImplicitEndCheck";
    private static final String txLocalNullACCreatedKey = "tx-local-flag-NullActivityContextCreation";
    private static final String txLocalOutstandingEventsKey = "tx-local-flag-OutstandingEvents";
    private CacheableMap cacheMap = new CacheableMap(String.valueOf(tcache) + "-" + this.getNodeNameInCache());

    public NullActivityContext(String activityContextId, Object activity, boolean refreshAccessTime) throws SystemException {
        super(activityContextId, activity, refreshAccessTime);
        if (this.cacheMap.get(txLocalNullACCreatedKey) == null) {
            this.cacheMap.put(txLocalNullACCreatedKey, Boolean.TRUE);
            this.cacheMap.put(txLocalOutstandingEventsKey, new Integer(0));
            this.scheduleCheckForNullActivityImplicitEnd();
        }
    }

    public void detachSbbEntity(String sbbEntityId) {
        super.detachSbbEntity(sbbEntityId);
        this.scheduleCheckForNullActivityImplicitEnd();
    }

    public boolean detachTimer(TimerID timerID, boolean checkForActivityEnd) {
        if (super.detachTimer(timerID, checkForActivityEnd)) {
            this.scheduleCheckForNullActivityImplicitEnd();
            return true;
        }
        return false;
    }

    public boolean removeNameBinding(String aciName) {
        if (super.removeNameBinding(aciName)) {
            this.scheduleCheckForNullActivityImplicitEnd();
            return true;
        }
        return false;
    }

    public String getNodeNameInCache() {
        return "null" + super.getNodeNameInCache();
    }

    private void scheduleCheckForNullActivityImplicitEnd() {
        if (this.getState() != ActivityContextState.ENDING) {
            if (this.cacheMap.get(txLocalNullACEndCheckKey) != null) {
                return;
            }
            this.cacheMap.put(txLocalNullACEndCheckKey, Boolean.TRUE);
            logger.info((Object)("schedule checking for implicit end of null activity on ac " + this.getActivityContextId()));
            TransactionalAction implicitEndCheck = new TransactionalAction(){

                public void execute() {
                    NullActivityContext.this.checkForNullActivityImplicitEnd();
                }
            };
            this.getTxManager().addPrepareCommitAction(implicitEndCheck);
        }
    }

    private void checkForNullActivityImplicitEnd() {
        logger.info((Object)("Checking for implicit end of null activity on ac " + this.getActivityContextId()));
        this.cacheMap.remove(txLocalNullACEndCheckKey);
        if (!this.isEnding() && !this.isInvalid() && this.isSbbAttachmentSetEmpty() && this.isAttachedTimersEmpty() && this.isNamingBindingEmpty() && this.getOutstandingEvents() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"scheduling activity end event");
            }
            this.getSleeContainer().getSleeEndpoint().scheduleActivityEndedEvent(this.getActivity());
        }
    }

    private Integer getOutstandingEvents() {
        return (Integer)this.cacheMap.get(txLocalOutstandingEventsKey);
    }

    private void setOutstandingEvents(Integer i) {
        this.cacheMap.put(txLocalOutstandingEventsKey, i);
    }

    public int incrementAndGetOutstandingEvents() {
        logger.info((Object)(String.valueOf(this.getActivityContextId()) + ":incrementAndGetOutstandingEvents()"));
        int outstandingEvents = this.getOutstandingEvents() + 1;
        this.setOutstandingEvents(outstandingEvents);
        return outstandingEvents;
    }

    public int decrementAndGetOutstandingEvents() {
        logger.info((Object)(String.valueOf(this.getActivityContextId()) + ":decrementAndGetOutstandingEvents()"));
        int outstandingEvents = this.getOutstandingEvents() - 1;
        this.setOutstandingEvents(outstandingEvents);
        if (outstandingEvents == 0) {
            this.scheduleCheckForNullActivityImplicitEnd();
        }
        return outstandingEvents;
    }
}

