/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import java.util.Set;
import javax.slee.FactoryException;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.management.SleeState;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactoryImpl;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.facilities.NullActivityImpl;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class NullActivityFactoryImpl
implements NullActivityFactory {
    private SleeContainer sleeContainer;
    private static Logger logger;
    private static String setNodeName;
    private static String NULL_ACTIVITY_CACHE;
    private Set nullActivities;

    static {
        setNodeName = "nullactivities";
        NULL_ACTIVITY_CACHE = TransactionManagerImpl.RUNTIME_CACHE;
        logger = Logger.getLogger(NullActivityFactoryImpl.class);
    }

    public NullActivityFactoryImpl(SleeContainer serviceContainer) throws Exception {
        this.sleeContainer = serviceContainer;
    }

    public NullActivity createNullActivity() throws TransactionRequiredLocalException, FactoryException {
        if (!this.sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
            return null;
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        NullActivityImpl nullActivity = new NullActivityImpl();
        ActivityContextFactoryImpl acf = this.sleeContainer.getActivityContextFactory();
        ActivityContext activityContext = acf.getActivityContext(nullActivity);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NullActivityFactory.createNullActivity() Creating null activity " + nullActivity + " received ac " + activityContext.getActivityContextId()));
        }
        this.getNullActivities().add(activityContext.getActivityContextId());
        return nullActivity;
    }

    public void removeNullActivity(String acid) {
        this.getNullActivities().remove(acid);
    }

    public void restart() throws Exception {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"NullActivityFactory.restart(): restarting null activity factory after failover!");
        }
        ActivityContextFactoryImpl acf = SleeContainer.lookupFromJndi().getActivityContextFactory();
        for (String acid : this.getNullActivities()) {
            logger.info((Object)("NullActivityFactory.restart(): restoring null activity " + acid));
            NullActivityImpl nullActivity = new NullActivityImpl();
            acf.createActivityContext((Object)nullActivity, acid);
        }
    }

    public NullActivity createNullActivityNoTx() throws TransactionRequiredLocalException, FactoryException {
        NullActivityImpl nullActivity = new NullActivityImpl();
        ActivityContextFactoryImpl acf = this.sleeContainer.getActivityContextFactory();
        ActivityContext activityContext = acf.getActivityContext(nullActivity);
        this.getNullActivities().add(activityContext.getActivityContextId());
        return nullActivity;
    }

    private synchronized Set getNullActivities() {
        return this.nullActivities != null ? this.nullActivities : (this.nullActivities = new CacheableSet(String.valueOf(NULL_ACTIVITY_CACHE) + "-" + setNodeName));
    }

    public String toString() {
        Set nullActivities = this.getNullActivities();
        return "NullActivityFactory[nullActivities=" + nullActivities + ",size=" + nullActivities.size() + "]";
    }
}

