/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.FacilityException;
import javax.slee.management.SleeState;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileTableActivity;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import javax.slee.profile.UnrecognizedQueryNameException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ProfileFacilityImpl
implements ProfileFacility {
    private static Logger logger = Logger.getLogger(ProfileFacilityImpl.class);
    public static final String JNDI_NAME = "profile";

    public Collection getProfiles(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, TransactionRolledbackLocalException, FacilityException {
        ProfileSpecificationID profileSpecificationID;
        SleeProfileManager profileManager = SleeProfileManager.getInstance();
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        try {
            profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
        }
        catch (SystemException e) {
            throw new FacilityException("System-level failure");
        }
        if (profileSpecificationID == null) {
            throw new UnrecognizedProfileTableNameException();
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        Collection profiles = profileManager.findAllProfilesByTableName(profileTableName);
        ArrayList<ProfileID> profileIDs = new ArrayList<ProfileID>();
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            profileIDs.add(new ProfileID(profileTableName, (String)it.next()));
        }
        Collection immutableCollection = Collections.unmodifiableCollection(profileIDs);
        if (startedTx) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"started tx so committing it");
                }
                SleeContainer.getTransactionManager().commit();
            }
            catch (Exception e) {
                throw new TransactionRolledbackLocalException("Failed to commit transaction");
            }
        }
        return immutableCollection;
    }

    public Collection getProfilesByIndexedAttribute(String profileTableName, String attributeName, Object attributeValue) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedAttributeException, AttributeNotIndexedException, AttributeTypeMismatchException, TransactionRolledbackLocalException, FacilityException {
        SleeProfileManager profileManager = SleeProfileManager.getInstance();
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        if (attributeName == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            throw new NullPointerException();
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        try {
            ProfileSpecificationID profileSpecification = profileManager.findProfileSpecId(profileTableName);
            if (profileSpecification == null) {
                throw new UnrecognizedProfileTableNameException();
            }
        }
        catch (SystemException e) {
            throw new FacilityException("System-level failure");
        }
        Collection profiles = null;
        try {
            profiles = profileManager.getProfilesByIndexedAttribute(profileTableName, attributeName, attributeValue, false);
        }
        catch (SystemException e1) {
            throw new FacilityException("System-level failure");
        }
        ArrayList<ProfileID> profileIDs = new ArrayList<ProfileID>();
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            profileIDs.add(new ProfileID(profileTableName, (String)it.next()));
        }
        if (startedTx) {
            try {
                logger.debug((Object)"started tx so committing it");
                SleeContainer.getTransactionManager().commit();
            }
            catch (Exception e) {
                throw new TransactionRolledbackLocalException("Failed to commit transaction");
            }
        }
        return Collections.unmodifiableCollection(profileIDs);
    }

    public ProfileID getProfileByIndexedAttribute(String profileTableName, String attributeName, Object attributeValue) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedAttributeException, AttributeNotIndexedException, AttributeTypeMismatchException, TransactionRolledbackLocalException, FacilityException {
        SleeProfileManager profileManager = SleeProfileManager.getInstance();
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        if (attributeName == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            throw new NullPointerException();
        }
        try {
            ProfileSpecificationID profileSpecification = profileManager.findProfileSpecId(profileTableName);
            if (profileSpecification == null) {
                throw new UnrecognizedProfileTableNameException();
            }
        }
        catch (SystemException e) {
            throw new FacilityException("System-level failure");
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        Collection profiles = null;
        try {
            profiles = profileManager.getProfilesByIndexedAttribute(profileTableName, attributeName, attributeValue, true);
        }
        catch (SystemException e1) {
            throw new FacilityException("System-level failure");
        }
        if (startedTx) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"started tx so committing it");
                }
                SleeContainer.getTransactionManager().commit();
            }
            catch (Exception e) {
                throw new TransactionRolledbackLocalException("Failed to commit transaction");
            }
        }
        if (profiles.isEmpty()) {
            return null;
        }
        return new ProfileID(profileTableName, (String)profiles.iterator().next());
    }

    public ProfileTableActivity getProfileTableActivity(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, TransactionRolledbackLocalException, FacilityException {
        SleeProfileManager sleeProfileManager = SleeProfileManager.getInstance();
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        if (!sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
            throw new FacilityException("Cannot obtain profile activity. Slee container is not in RUNNING state, but " + sleeContainer.getSleeState());
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        try {
            ProfileSpecificationID profileSpecificationID = sleeProfileManager.findProfileSpecId(profileTableName);
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException();
            }
            ProfileTableActivityImpl profileTableActivityImpl = sleeProfileManager.createProfileTableActivity(profileTableName);
            return profileTableActivityImpl;
        }
        catch (SystemException ex) {
            throw new FacilityException("Unexpected exception", (Throwable)ex);
        }
        finally {
            try {
                if (startedTx) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException e) {
                throw new FacilityException("error committing tx", (Throwable)e);
            }
        }
    }

    public Collection getProfilesByStaticQuery(String arg0, String arg1, Object[] arg2) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedQueryNameException, AttributeTypeMismatchException, TransactionRolledbackLocalException, FacilityException {
        return null;
    }
}

