/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.jboss;

import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.facilities.NullActivityFactoryImpl;
import org.mobicents.slee.runtime.facilities.TimerFacilityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class RuntimeRestoreTask
implements Runnable {
    Logger logger = Logger.getLogger(RuntimeRestoreTask.class);

    public void run() {
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                this.logger.info((Object)"Restore state after restart!");
                txmgr.begin();
                NullActivityFactoryImpl naf = sleeContainer.getNullActivityFactory();
                naf.restart();
                TimerFacilityImpl timerFacility = (TimerFacilityImpl)SleeContainer.getTimerFacility();
                timerFacility.restart();
                rb = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.error((Object)"An exception occurred while restoring facility", (Throwable)ex);
                try {
                    if (txmgr.isInTx() && rb) {
                        txmgr.setRollbackOnly();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error restoring cache!", e);
                }
            }
        }
        finally {
            try {
                if (txmgr.isInTx()) {
                    txmgr.commit();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error restoring cache!!", ex);
            }
        }
    }
}

