/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.serviceactivity;

import java.util.Hashtable;
import javax.slee.ActivityContextInterface;
import javax.slee.FactoryException;
import javax.slee.ServiceID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityContextInterfaceFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityImpl;

public class ServiceActivityContextInterfaceFactoryImpl
implements ServiceActivityContextInterfaceFactory {
    private static Logger logger = Logger.getLogger(ServiceActivityContextInterfaceFactoryImpl.class);
    private SleeContainer serviceContainer;
    private Hashtable serviceActivityContextInterfaceTable;
    public static String JNDI_NAME = "activitycontextinterfacefactory";

    public ServiceActivityContextInterfaceFactoryImpl(SleeContainer serviceContainer) {
        this.serviceContainer = serviceContainer;
        this.serviceActivityContextInterfaceTable = new Hashtable();
    }

    public ActivityContextInterface getActivityContextInterface(ServiceActivity serviceActivityImpl) throws NullPointerException, TransactionRequiredLocalException, UnrecognizedActivityException, FactoryException {
        SleeContainer.getTransactionManager().mandateTransaction();
        ServiceID serviceId = ((ServiceActivityImpl)serviceActivityImpl).getServiceID();
        String acId = (String)this.serviceActivityContextInterfaceTable.get(serviceId);
        if (acId == null) {
            ActivityContext ac = this.serviceContainer.getActivityContextFactory().getActivityContext(serviceActivityImpl);
            this.serviceActivityContextInterfaceTable.put(serviceId, ac.getActivityContextId());
            acId = ac.getActivityContextId();
        }
        return new ActivityContextInterfaceImpl(this.serviceContainer, acId);
    }

    public void removeServiceActivityContextInterface(ServiceActivityImpl serviceActivity) {
        ActivityContext ac = this.serviceContainer.getActivityContextFactory().getActivityContext(serviceActivity);
        ac.removeNamingBindings();
        ac.removeFromTimers();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removed facilities");
        }
        ac.setState(ActivityContextState.INVALID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"activity is now invalid");
        }
        this.serviceContainer.getActivityContextFactory().removeActivityContext(ac.getActivityContextId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Removed it");
        }
        this.serviceActivityContextInterfaceTable.remove(serviceActivity.getServiceID());
    }
}

