/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.transaction;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.TransactionRequiredLocalException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.transaction.TransactionManagerImplMBean;
import org.mobicents.slee.runtime.transaction.TransactionalAction;
import org.mobicents.slee.runtime.transaction.TxLocalEntry;

public class TransactionManagerImpl
extends ServiceMBeanSupport
implements TransactionManagerImplMBean {
    private static Logger logger = Logger.getLogger(TransactionManagerImpl.class);
    public static String TCACHE = "tcache";
    public static String DEPLOYMENT_CACHE = "deploymentCache";
    public static String PROFILE_CACHE = "profileCache";
    public static String RUNTIME_CACHE = "runtimeCache";
    private HashMap treeCaches;
    private ObjectName tcacheName;
    private ObjectName deploymentTreeCacheName;
    private ObjectName runtimeTreeCacheName;
    private ObjectName profileTreeCacheName;
    private TransactionManager txMgr;
    private Map sleeTransactions = new ConcurrentReaderHashMap();
    private Map txDeferredTable = new ConcurrentReaderHashMap();

    private static String getFileAndLine() {
        Exception ex = new Exception();
        StringBuffer sbuf = new StringBuffer().append("\n");
        int i = 2;
        while (i < 8) {
            String fname = ex.getStackTrace()[i].getFileName();
            int line = ex.getStackTrace()[i].getLineNumber();
            sbuf.append("[" + fname).append(":" + line + "]");
            ++i;
        }
        return sbuf.toString();
    }

    public static String getRootFqn(String cacheName) {
        return "";
    }

    public TransactionManagerImpl() {
        super(TransactionManagerImplMBean.class);
        this.treeCaches = new HashMap();
    }

    public void mandateTransaction() throws TransactionRequiredLocalException {
        Transaction tx = null;
        try {
            tx = this.getTransaction();
            if (tx == null) {
                throw new TransactionRequiredLocalException("Transaction Mandatory");
            }
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw new IllegalStateException("There is no active tx, tx is in state: " + tx.getStatus());
            }
        }
        catch (SystemException e) {
            logger.error((Object)"Caught SystemException in getting transaction/ status", (Throwable)e);
        }
    }

    public static Integer makeKey(Transaction tx) {
        return new Integer(tx.hashCode());
    }

    public void setRollbackOnly() throws SystemException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setrollbackonly called on tx:" + TransactionManagerImpl.makeKey(this.getTransaction())));
        }
        this.txMgr.setRollbackOnly();
    }

    public boolean getRollbackOnly() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx.getStatus() == 1;
    }

    public boolean requireTransaction() {
        Transaction tx;
        block4: {
            tx = this.getTransaction();
            if (tx != null) break block4;
            this.begin();
            return true;
        }
        try {
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw new IllegalStateException("Transaction is in illegal state: " + tx.getStatus());
            }
        }
        catch (SystemException e) {
            logger.error((Object)"Caught SystemException in checking transaction", (Throwable)e);
        }
        return false;
    }

    public boolean isInTx() throws SystemException {
        return this.getTransaction() != null;
    }

    public Transaction getTransaction() {
        try {
            return this.txMgr.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException("Failed to obtain active JTA transaction");
        }
    }

    public void begin() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            String err = "Transaction already started, cannot nest tx. Ongoing Tx: " + tx;
            SystemException se = new SystemException(err);
            logger.error((Object)err, (Throwable)se);
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw se;
        }
        try {
            this.txMgr.begin();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Transaction started.");
            }
            this.logTxID();
        }
        catch (NotSupportedException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Failed to begin transaction.", (Throwable)e);
            }
            throw new SystemException("Failed to begin transaction." + (Object)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Tx after begin:" + this.txMgr.getTransaction()));
        }
        if ((tx = this.getTransaction()) != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Tx state is " + this.txMgr.getTransaction().getStatus()));
        }
        SynchronizationHandler handler = new SynchronizationHandler(tx);
        try {
            tx.registerSynchronization((Synchronization)handler);
        }
        catch (RollbackException e) {
            logger.error((Object)e);
        }
    }

    private void logTxID() {
        if (logger.isDebugEnabled()) {
            Transaction t = this.getTransaction();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Context local TxID: " + t));
            }
            if (logger.isTraceEnabled()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    logger.trace((Object)"Call stack", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new SystemException("Failed to commit transaction since there is no transaction to commit!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Committing tx");
        }
        this.logTxID();
        if (tx.getStatus() == 1) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transaction marked for roll back, cannot commit, ending with rollback: " + TransactionManagerImpl.makeKey(tx)));
                }
                this.rollback();
                return;
            }
            finally {
                this.removeEntry(tx);
            }
        }
        if (tx.getStatus() != 0) throw new SystemException("Failed to commit transaction since transaction is in state: " + tx.getStatus());
        try {
            try {
                this.txMgr.commit();
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)"Committed tx");
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to commit tx: \n", (Throwable)e);
                this.log.error((Object)this.displayOngoingSleeTransactions());
            }
            return;
        }
        finally {
            this.removeEntry(tx);
        }
    }

    public void rollback() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new SystemException("Failed to rollback transaction since there is no transaction to rollback!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Rolling-back tx.");
        }
        this.logTxID();
        if (tx.getStatus() == 0 && tx.getStatus() == 1) {
            throw new SystemException("Failed to rollback transaction since transaction is in state: " + tx.getStatus());
        }
        this.txMgr.rollback();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Committed tx");
        }
    }

    private TxLocalEntry removeEntry(Transaction tx) {
        return (TxLocalEntry)this.txDeferredTable.remove(TransactionManagerImpl.makeKey(tx));
    }

    private void executeAfterCommitActions(Transaction tx) {
        Integer tid = TransactionManagerImpl.makeKey(tx);
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(tid);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing commit actions for transaction: " + tid));
        }
        if (entry != null) {
            entry.executeAfterCommitActions();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("no commit actions to execute for the tx! " + tid));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Done executing afterCommitAction " + tid));
        }
    }

    private void executePrepareActions(Transaction tx) {
        TxLocalEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing Prepare actions for transaction : " + tx));
        }
        if ((entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx))) != null) {
            entry.executePrepareActions();
        }
    }

    private void executeAfterRollbackActions(Transaction tx) {
        TxLocalEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing rollback actions for transaction:" + tx));
        }
        if ((entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx))) != null) {
            entry.executeAfterRollbackActions();
        }
    }

    public List getCommitActions() throws SystemException {
        this.assertIsInTx();
        Transaction tx = this.getTransaction();
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx));
        if (entry != null) {
            return entry.getAfterCommitActions();
        }
        return null;
    }

    public List getPrepareActions() throws SystemException {
        this.assertIsInTx();
        Transaction tx = this.getTransaction();
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx));
        if (entry != null) {
            return entry.getPrepareActions();
        }
        return null;
    }

    public Object getTxLocalData(Object key) {
        this.assertIsInTx();
        Transaction tx = this.getTransaction();
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx));
        if (entry != null) {
            return entry.getData(key);
        }
        return null;
    }

    public void putTxLocalData(Object key, Object value) {
        this.assertIsInTx();
        Transaction tx = this.getTransaction();
        Integer tid = TransactionManagerImpl.makeKey(tx);
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(tid);
        if (entry == null) {
            entry = new TxLocalEntry(tid.toString());
            this.txDeferredTable.put(tid, entry);
        }
        entry.putData(key, value);
    }

    public void removeTxLocalData(Object key) throws SystemException {
        this.assertIsInTx();
        Transaction tx = this.getTransaction();
        TxLocalEntry entry = (TxLocalEntry)this.txDeferredTable.get(TransactionManagerImpl.makeKey(tx));
        if (entry == null) {
            return;
        }
        entry.removeData(key);
    }

    public void addAfterCommitAction(TransactionalAction action) throws SystemException {
        this.assertIsInTx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding commit action: " + action));
        }
        TxLocalEntry entry = this.getEntry();
        entry.addAfterCommitAction(action);
    }

    public void addPrepareCommitAction(TransactionalAction action) {
        this.assertIsInTx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding prepare action: " + action));
        }
        TxLocalEntry entry = this.getEntry();
        entry.addPrepareAction(action);
    }

    private TxLocalEntry getEntry() {
        TxLocalEntry entry;
        Transaction tx = this.getTransaction();
        Integer tid = TransactionManagerImpl.makeKey(tx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX is " + tid));
        }
        if ((entry = (TxLocalEntry)this.txDeferredTable.get(tid)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Entry not already there");
            }
            entry = new TxLocalEntry(tid.toString());
            this.txDeferredTable.put(tid, entry);
        }
        return entry;
    }

    public void addAfterRollbackAction(TransactionalAction action) throws SystemException {
        this.assertIsInTx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding rollback action: " + action));
        }
        TxLocalEntry entry = this.getEntry();
        entry.addAfterRollbackAction(action);
    }

    private TreeCache getTreeCache(String treeCacheName) {
        return (TreeCache)this.treeCaches.get(treeCacheName);
    }

    public void putObject(String cacheName, String fqn, Object key, Object object) {
        this.assertIsInTx();
        if (logger.isDebugEnabled()) {
            ((List)this.sleeTransactions.get(this.getTransaction())).add("putObject(" + cacheName + "," + fqn + "," + key + "," + object + ")" + TransactionManagerImpl.getFileAndLine());
        }
        try {
            this.getTreeCache(cacheName).put(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn, key, object);
        }
        catch (UpgradeException ex) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.getTreeCache(cacheName).put(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn, key, object);
            }
            catch (CacheException e1) {
                this.log.error((Object)this.displayOngoingSleeTransactions());
                throw new RuntimeException(ex.getMessage(), e1);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void createNode(String cacheName, String fqn, Map data) {
        this.mandateTransaction();
        if (data == null) {
            logger.warn((Object)"createNode(String cacheName, String fqn, Map data): Storing null in distributed cache. Potentially wasteful operation.");
        }
        try {
            this.getTreeCache(cacheName).put(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn, data);
        }
        catch (UpgradeException ex) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)this.displayOngoingSleeTransactions());
            }
            try {
                this.getTreeCache(cacheName).put(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn, data);
            }
            catch (CacheException e1) {
                this.log.error((Object)this.displayOngoingSleeTransactions());
                throw new RuntimeException(ex.getMessage(), e1);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void clearNode(String cacheName, String fqn) {
        this.mandateTransaction();
        try {
            this.getTreeCache(cacheName).removeData(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn);
        }
        catch (UpgradeException ex) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.getTreeCache(cacheName).removeData(String.valueOf(TransactionManagerImpl.getRootFqn(cacheName)) + "/" + fqn);
            }
            catch (CacheException e1) {
                this.log.error((Object)this.displayOngoingSleeTransactions());
                throw new RuntimeException(ex.getMessage(), e1);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Object getObject(String tcache, String fqn, Object key) {
        this.assertIsInTx();
        if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
            ((List)this.sleeTransactions.get(this.getTransaction())).add("getObject(" + tcache + "," + fqn + "," + key + ")" + TransactionManagerImpl.getFileAndLine());
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getObject ( " + tcache + "," + fqn + "," + key + ")"));
            }
            String localFqn = String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn;
            Object object = this.getTreeCache(tcache).get(localFqn, key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(">>> getObject ( " + tcache + "," + fqn + "," + key + ") returning \t" + object));
            }
            return object;
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed getObject(" + TransactionManagerImpl.getRootFqn(tcache) + "/" + fqn + "/" + key + ")"), (Throwable)ex);
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Set getKeys(String tcache, String fqn) {
        this.assertIsInTx();
        String localFqn = String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn;
        try {
            if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
                ((List)this.sleeTransactions.get(this.getTransaction())).add("getKeys (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
            }
            Set keys = this.getTreeCache(tcache).getKeys(localFqn);
            return keys;
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException("Timeout occured", ex);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed getKeys(" + localFqn + ")"), (Throwable)ex);
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Node getNode(String tcache, String fqn) {
        this.assertIsInTx();
        String localFqn = String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn;
        try {
            if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
                ((List)this.sleeTransactions.get(this.getTransaction())).add("getNode (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
            }
            if (this.getTreeCache(tcache).exists(localFqn)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getNode " + tcache + " fqn = " + fqn));
                }
                Node retval = this.getTreeCache(tcache).get(localFqn);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(">>> getNode " + tcache + " fqn = " + fqn));
                }
                return retval;
            }
            return null;
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException("Timeout occured", ex);
        }
        catch (Exception ex) {
            logger.error((Object)("Failed getNode(" + localFqn + ")"), (Throwable)ex);
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayOngoingSleeTransactions() {
        if (logger.isDebugEnabled()) {
            Map map = this.sleeTransactions;
            synchronized (map) {
                Iterator iter = this.sleeTransactions.keySet().iterator();
                logger.error((Object)("current tx is " + this.getTransaction()));
                String msg = "---------+ Begin dump of SLEE TX map: +-------------------------- \n";
                while (iter.hasNext()) {
                    List ll;
                    Object tx = iter.next();
                    msg = String.valueOf(msg) + "----+ Transaction: " + tx + " started by (stack trace): \n";
                    Exception ex = (Exception)((List)this.sleeTransactions.get(tx)).get(0);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(os);
                    ex.printStackTrace(ps);
                    ps.close();
                    msg = String.valueOf(msg) + os.toString() + "\n";
                    List list = ll = (List)this.sleeTransactions.get(tx);
                    synchronized (list) {
                        Iterator it = ll.iterator();
                        it.next();
                        while (it.hasNext()) {
                            msg = String.valueOf(msg) + it.next() + "\n";
                        }
                    }
                    msg = String.valueOf(msg) + "-------------------------------------------";
                }
                msg = String.valueOf(msg) + "\nEnd dump of SLEE TX map: -------------------------- \n";
                return msg;
            }
        }
        return "";
    }

    public Set getChildrenNames(String tcache, String fqn) throws SystemException {
        if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
            ((List)this.sleeTransactions.get(this.getTransaction())).add("getChildrenNames (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
        }
        try {
            return this.getTreeCache(tcache).getChildrenNames(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn);
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new SystemException(ex.getMessage());
        }
        catch (Exception ex) {
            this.log.error((Object)("failed getChildrenNames ( " + fqn + ")"));
            this.log.error((Object)this.displayOngoingSleeTransactions());
            throw new SystemException(ex.getMessage());
        }
    }

    public void removeObject(String tcache, String nodeName, Object attributeKey) {
        this.assertIsInTx();
        if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
            ((List)this.sleeTransactions.get(this.getTransaction())).add("removeObject (" + tcache + " , " + nodeName + "," + attributeKey + ") " + TransactionManagerImpl.getFileAndLine());
        }
        try {
            this.getTreeCache(tcache).remove(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + nodeName, attributeKey);
        }
        catch (UpgradeException ex) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)("Failed to remove object with key '" + nodeName + "/" + attributeKey + "' from cache '" + tcache + "'. Will retry."), (Throwable)e);
            }
            try {
                this.getTreeCache(tcache).remove(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + nodeName, attributeKey);
            }
            catch (CacheException e1) {
                this.log.error((Object)this.displayOngoingSleeTransactions(), (Throwable)e1);
                throw new RuntimeException(ex.getMessage(), e1);
            }
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void removeNode(String tcache, String fqn) {
        this.assertIsInTx();
        try {
            if (fqn.startsWith("/")) {
                this.log.warn((Object)("Illegal start of name " + fqn));
            }
            if (logger.isDebugEnabled()) {
                this.log.debug((Object)("removeNode(): Removing node " + TransactionManagerImpl.getRootFqn(tcache) + "/" + fqn + " from Cache!"));
                ((List)this.sleeTransactions.get(this.getTransaction())).add("removeNode (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
            }
            if (this.nodeExists(tcache, fqn)) {
                this.getTreeCache(tcache).remove(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn);
            } else if (logger.isDebugEnabled()) {
                this.log.debug((Object)"removeNode(): node not found - nothing to remove");
            }
        }
        catch (UpgradeException ex) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.getTreeCache(tcache).remove(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn);
            }
            catch (CacheException e1) {
                this.log.error((Object)this.displayOngoingSleeTransactions());
                throw new RuntimeException(ex.getMessage(), e1);
            }
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            logger.error((Object)this.displayOngoingSleeTransactions(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Map getChildren(String tcache, String fqn) throws SystemException {
        String localFqn;
        block7: {
            this.assertIsInTx();
            if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
                ((List)this.sleeTransactions.get(this.getTransaction())).add("getChildren (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
            }
            localFqn = String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn;
            if (this.getTreeCache(tcache).exists(localFqn)) break block7;
            return null;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getChildren (" + tcache + "," + fqn + ")" + TransactionManagerImpl.getFileAndLine()));
            }
            Node node = this.getTreeCache(tcache).get(localFqn);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getChildren (" + tcache + "," + fqn + ")" + TransactionManagerImpl.getFileAndLine()));
            }
            return node.getChildren();
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new SystemException(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException("trouble getting children");
        }
    }

    public void cleanUpCache(String tcache) throws SystemException {
        try {
            if (!this.getTreeCache(tcache).exists(TransactionManagerImpl.getRootFqn(tcache))) {
                return;
            }
            this.getTreeCache(tcache).remove(TransactionManagerImpl.getRootFqn(tcache));
        }
        catch (CacheException ex) {
            logger.error((Object)"Failed to clean SLEE cache. This could lead to unexpected behaviour! Recommendation: Restart SLEE VM!", (Throwable)ex);
            throw new SystemException("Failed to clean SLEE cache. " + ex.getMessage());
        }
    }

    public void removeChildren(String tcache, String fqn) throws SystemException {
        this.assertIsInTx();
        if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
            ((List)this.sleeTransactions.get(this.getTransaction())).add("removeChildren (" + tcache + " , " + fqn + ")" + TransactionManagerImpl.getFileAndLine());
        }
        try {
            String localFqn = String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn;
            if (!this.getTreeCache(tcache).exists(localFqn)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeChildren (" + tcache + "," + fqn + ")" + TransactionManagerImpl.getFileAndLine()));
            }
            this.getTreeCache(tcache).remove(localFqn);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeChildren (" + tcache + "," + fqn + ")" + TransactionManagerImpl.getFileAndLine()));
            }
        }
        catch (TimeoutException ex) {
            logger.error((Object)this.displayOngoingSleeTransactions());
            throw new SystemException(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException(ex.getMessage());
        }
    }

    public void removeChild(String tcache, String fqnRoot, String key) {
        this.assertIsInTx();
        try {
            if (logger.isDebugEnabled() && this.sleeTransactions.get(this.getTransaction()) != null) {
                ((List)this.sleeTransactions.get(this.getTransaction())).add("removeChild (" + tcache + " , " + fqnRoot + " , " + key + ")" + TransactionManagerImpl.getFileAndLine());
            }
            this.getTreeCache(tcache).remove(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqnRoot, (Object)key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startService() throws Exception {
        this.initTreeCache();
        this.txMgr = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        SleeContainer.registerWithJndi("slee", "SleeTransactionManager", this);
    }

    public void stopService() throws Exception {
        SleeContainer.unregisterWithJndi("SleeTransactionManager");
    }

    public void assertIsInTx() {
        this.mandateTransaction();
    }

    public void assertIsNotInTx() {
        Transaction t = this.getTransaction();
        if (t != null) {
            throw new IllegalStateException("Should NOT be in an tx!! TxID: " + t);
        }
    }

    public void setTreeCacheName(ObjectName newTreeCacheName) {
        this.tcacheName = newTreeCacheName;
    }

    public void setDeploymentTreeCacheName(ObjectName newTreeCacheName) {
        this.deploymentTreeCacheName = newTreeCacheName;
    }

    public void setProfileTreeCacheName(ObjectName newTreeCacheName) {
        this.profileTreeCacheName = newTreeCacheName;
    }

    public void setRuntimeTreeCacheName(ObjectName runtimeCacheName) {
        this.runtimeTreeCacheName = runtimeCacheName;
    }

    public ObjectName getTreeCacheName() {
        return this.tcacheName;
    }

    private synchronized void initTreeCache() throws MBeanProxyCreationException {
        TreeCacheMBean tcm;
        if (this.getTreeCache(RUNTIME_CACHE) == null) {
            tcm = (TreeCacheMBean)MBeanProxy.get(TreeCacheMBean.class, (ObjectName)this.runtimeTreeCacheName, (MBeanServer)this.server);
            TreeCache runtimeTreeCache = tcm.getInstance();
            this.treeCaches.put(RUNTIME_CACHE, runtimeTreeCache);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runtimeTreeCache = " + this.getTreeCache(RUNTIME_CACHE)));
            }
        }
        if (this.getTreeCache(TCACHE) == null) {
            tcm = (TreeCacheMBean)MBeanProxy.get(TreeCacheMBean.class, (ObjectName)this.tcacheName, (MBeanServer)this.server);
            TreeCache tcache = tcm.getInstance();
            this.treeCaches.put(TCACHE, tcache);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("treeCache = " + this.getTreeCache(TCACHE)));
            }
        }
        if (this.getTreeCache(DEPLOYMENT_CACHE) == null) {
            tcm = (TreeCacheMBean)MBeanProxy.get(TreeCacheMBean.class, (ObjectName)this.deploymentTreeCacheName, (MBeanServer)this.server);
            TreeCache deploymentTreeCache = tcm.getInstance();
            this.treeCaches.put(DEPLOYMENT_CACHE, deploymentTreeCache);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deploymentTreeCache = " + this.getTreeCache(DEPLOYMENT_CACHE)));
            }
        }
        if (this.getTreeCache(PROFILE_CACHE) == null) {
            tcm = (TreeCacheMBean)MBeanProxy.get(TreeCacheMBean.class, (ObjectName)this.profileTreeCacheName, (MBeanServer)this.server);
            TreeCache profileTreeCache = tcm.getInstance();
            this.treeCaches.put(PROFILE_CACHE, profileTreeCache);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileTreeCache = " + this.getTreeCache(PROFILE_CACHE)));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("comparing caches profileCache / tcache " + (this.getTreeCache(PROFILE_CACHE) == this.getTreeCache(TCACHE))));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("comparing caches pofileCache / deploymentCache " + (this.getTreeCache(PROFILE_CACHE) == this.getTreeCache(DEPLOYMENT_CACHE))));
        }
    }

    public boolean nodeExists(String tcache, String fqn) {
        return this.getTreeCache(tcache).exists(String.valueOf(TransactionManagerImpl.getRootFqn(tcache)) + "/" + fqn);
    }

    public Object getObject(String cacheName, String fqn, String key) throws SystemException {
        return this.getObject(cacheName, fqn, (Object)key);
    }

    public void putObject(String cacheName, String fqn, String key, Object object) {
        this.putObject(cacheName, fqn, (Object)key, object);
    }

    public int getStatus() throws SystemException {
        int status = 0;
        Transaction tx = null;
        tx = this.getTransaction();
        if (tx == null) {
            throw new SystemException("No Tx associated with current thread!!!");
        }
        status = tx.getStatus();
        return status;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.txMgr.setTransactionTimeout(timeout);
    }

    public Transaction suspend() throws SystemException {
        return this.txMgr.suspend();
    }

    public void resume(Transaction txToResume) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.txMgr.resume(txToResume);
    }

    class SynchronizationHandler
    implements Synchronization {
        private Transaction tx;

        public SynchronizationHandler(Transaction tx) {
            this.tx = tx;
            List<Exception> llist = Collections.synchronizedList(new LinkedList());
            llist.add(new Exception());
            TransactionManagerImpl.this.sleeTransactions.put(tx, llist);
        }

        public void afterCompletion(int status) {
            TransactionManagerImpl.this.sleeTransactions.remove(this.tx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("afterCompletion, status is " + status + " tx is " + TransactionManagerImpl.makeKey(this.tx)));
            }
            switch (status) {
                case 3: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Transaction: " + TransactionManagerImpl.makeKey(this.tx) + " has committed"));
                    }
                    TransactionManagerImpl.this.executeAfterCommitActions(this.tx);
                    break;
                }
                case 4: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Transaction: " + TransactionManagerImpl.makeKey(this.tx) + " has rolled-back"));
                    }
                    TransactionManagerImpl.this.executeAfterRollbackActions(this.tx);
                    break;
                }
                default: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Transaction is in state:" + status));
                    }
                    throw new IllegalStateException("Transaction is in state " + status);
                }
            }
        }

        public void beforeCompletion() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("beforeCompletion, tx is " + TransactionManagerImpl.makeKey(this.tx)));
            }
            TransactionManagerImpl.this.executePrepareActions(this.tx);
        }
    }
}

