/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test;

import java.util.Hashtable;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.apache.log4j.Category;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.ProfileSpecificationIDImpl;

public class ConnectorClient {
    protected RMIAdaptor rmiserver = null;
    protected Category log;

    public ConnectorClient() {
    }

    public ConnectorClient(String jndiurl) {
        this();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.provider.url", jndiurl);
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
            InitialContext ctx = new InitialContext(env);
            this.rmiserver = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
            if (this.rmiserver == null) {
                System.out.println("RMIAdaptor is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName oname) {
        MBeanInfo info = null;
        try {
            info = this.rmiserver.getMBeanInfo(oname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public Object invokeOperation(ObjectName oname, String methodname, Object[] pParams, String[] pSignature) throws Exception {
        Object result = null;
        try {
            result = this.rmiserver.invoke(oname, methodname, pParams, pSignature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            ConnectorClient connector = new ConnectorClient("jnp://localhost:2000");
            ObjectName name = new ObjectName("slee:name=ProfileProvisoning");
            ComponentKey componentKey = new ComponentKey("jean/nist-sip/1.0");
            ProfileSpecificationIDImpl profileSpecificationID = new ProfileSpecificationIDImpl(componentKey);
            Object[] params = new Object[]{profileSpecificationID, "jean"};
            String[] sig = new String[]{"javax.slee.profile.ProfileSpecificationID", "java.lang.String"};
            Object result = connector.invokeOperation(name, "createProfileTable", params, sig);
            result = connector.invokeOperation(name, "getProfileTables", null, null);
            System.out.println("Result after createProfleTable : " + result);
            params = new Object[]{"jean"};
            sig = new String[]{"java.lang.String"};
            result = connector.invokeOperation(name, "removeProfileTable", params, sig);
            result = connector.invokeOperation(name, "getProfileTables", null, null);
            System.out.println("Result after removeProfleTable " + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

