/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.junit;

import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllTestsAgregator {
    public static final String testClassNamePattern = "Z\\w+Test\\.class";
    public static final String classes = "classes";

    public static void main(String[] args) {
        AllTestsAgregator.suite();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String mobicents_HOME = System.getProperty("MOBICENTS_HOME");
        File rootDir = new File(String.valueOf(mobicents_HOME) + "/classes");
        if (!rootDir.exists()) {
            System.out.println("ERROR DIR[" + rootDir + "] DOES NOT EXIST");
            return suite;
        }
        suite.addTest(AllTestsAgregator.digInDir(rootDir));
        return suite;
    }

    private static Test digInDir(File dir) {
        TestSuite suite = new TestSuite();
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                suite.addTest(AllTestsAgregator.digInDir(f));
            } else {
                String fileName = f.getName();
                if (Pattern.matches(testClassNamePattern, fileName)) {
                    String className = fileName.split("\\.")[0];
                    String packageName = "";
                    String parentName = f.getParentFile().getPath();
                    int index = parentName.indexOf(classes);
                    packageName = parentName.substring(index + classes.length() + 1, parentName.length());
                    packageName = packageName.replace(File.separator.charAt(0), ".".charAt(0));
                    Class<?> testClass = null;
                    try {
                        testClass = Class.forName(String.valueOf(packageName) + "." + className);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (testClass == null) {
                        System.out.println("TESTS CLASS IS NULL");
                    } else {
                        Method method = null;
                        try {
                            method = testClass.getMethod("suite", null);
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        if (method != null) {
                            System.out.println("ADDDING[" + testClass + "]");
                            suite.addTestSuite(testClass);
                        } else {
                            System.out.println("CLASS[" + testClass + "] MATCHES PATTERN BUT DOESNT HAVE suite() METHOD!!");
                        }
                    }
                }
            }
            ++i;
        }
        return suite;
    }
}

