/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.suite;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import java.util.Vector;
import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.mobicents.slee.test.suite.JUnitSleeTestUtils;

public class ComponentIDLookup {
    private JUnitSleeTestUtils utils;

    public ComponentIDLookup(JUnitSleeTestUtils utils) {
        this.utils = utils;
    }

    public EventTypeID lookupEventTypeID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        EventTypeID[] matches = this.lookupEventTypeIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public EventTypeID[] lookupEventTypeIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        EventTypeID[] allEventTypeIDs = this.utils.getDeploymentMBeanProxy().getEventTypes();
        return (EventTypeID[])this.findMatches((ComponentID[])allEventTypeIDs, name, vendor, version, (ComponentID[])new EventTypeID[0]);
    }

    public ProfileSpecificationID lookupProfileSpecificationID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ProfileSpecificationID[] matches = this.lookupProfileSpecificationIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public ProfileSpecificationID[] lookupProfileSpecificationIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ProfileSpecificationID[] allProfileSpecificationIDs = this.utils.getDeploymentMBeanProxy().getProfileSpecifications();
        return (ProfileSpecificationID[])this.findMatches((ComponentID[])allProfileSpecificationIDs, name, vendor, version, (ComponentID[])new ProfileSpecificationID[0]);
    }

    public ResourceAdaptorID lookupResourceAdaptorID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ResourceAdaptorID[] matches = this.lookupResourceAdaptorIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public ResourceAdaptorID[] lookupResourceAdaptorIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ResourceAdaptorID[] allResourceAdaptorIDs = this.utils.getDeploymentMBeanProxy().getResourceAdaptors();
        return (ResourceAdaptorID[])this.findMatches((ComponentID[])allResourceAdaptorIDs, name, vendor, version, (ComponentID[])new ResourceAdaptorID[0]);
    }

    public ResourceAdaptorTypeID lookupResourceAdaptorTypeID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ResourceAdaptorTypeID[] matches = this.lookupResourceAdaptorTypeIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public ResourceAdaptorTypeID[] lookupResourceAdaptorTypeIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ResourceAdaptorTypeID[] allResourceAdaptorTypeIDs = this.utils.getDeploymentMBeanProxy().getResourceAdaptorTypes();
        return (ResourceAdaptorTypeID[])this.findMatches((ComponentID[])allResourceAdaptorTypeIDs, name, vendor, version, (ComponentID[])new ResourceAdaptorTypeID[0]);
    }

    public SbbID lookupSbbID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        SbbID[] matches = this.lookupSbbIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public SbbID[] lookupSbbIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        SbbID[] allSbbIDs = this.utils.getDeploymentMBeanProxy().getSbbs();
        return (SbbID[])this.findMatches((ComponentID[])allSbbIDs, name, vendor, version, (ComponentID[])new SbbID[0]);
    }

    public ServiceID lookupServiceID(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ServiceID[] matches = this.lookupServiceIDs(name, vendor, version);
        return matches == null ? null : matches[0];
    }

    public ServiceID[] lookupServiceIDs(String name, String vendor, String version) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        ServiceID[] allServiceIDs = this.utils.getDeploymentMBeanProxy().getServices();
        return (ServiceID[])this.findMatches((ComponentID[])allServiceIDs, name, vendor, version, (ComponentID[])new ServiceID[0]);
    }

    private ComponentID[] findMatches(ComponentID[] componentIDs, String name, String vendor, String version, ComponentID[] emptyArray) throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        DeploymentMBeanProxy deployment = this.utils.getDeploymentMBeanProxy();
        Vector<ComponentID> matches = new Vector<ComponentID>();
        int i = 0;
        while (i < componentIDs.length) {
            ComponentDescriptor descriptor = deployment.getDescriptor(componentIDs[i]);
            if (!(name != null && !name.equals(descriptor.getName()) || vendor != null && !vendor.equals(descriptor.getVendor()) || version != null && !version.equals(descriptor.getVersion()))) {
                matches.addElement(componentIDs[i]);
            }
            ++i;
        }
        return matches.isEmpty() ? null : matches.toArray(emptyArray);
    }
}

