/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.suite;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.UnrecognizedComponentException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileTableAlreadyExistsException;
import javax.slee.profile.UnrecognizedProfileSpecificationException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import org.mobicents.slee.test.suite.ComponentIDLookup;
import org.mobicents.slee.test.suite.JUnitSleeTestUtils;

public class ProfileUtils {
    private JUnitSleeTestUtils utils;
    private ProfileProvisioningMBeanProxy profileProvisioningProxy;
    private ProfileSpecificationID stdAddressProfileSpecID;

    public ProfileUtils(JUnitSleeTestUtils utils) {
        this.utils = utils;
    }

    public ProfileProvisioningMBeanProxy getProfileProvisioningProxy() throws TCKTestErrorException {
        if (this.profileProvisioningProxy == null) {
            ObjectName profileProvisioningName = this.utils.getSleeManagementMBeanProxy().getProfileProvisioningMBean();
            this.profileProvisioningProxy = this.utils.getMBeanProxyFactory().createProfileProvisioningMBeanProxy(profileProvisioningName);
        }
        return this.profileProvisioningProxy;
    }

    public void createStandardAddressProfileTable(String tableName) throws TCKTestErrorException, ManagementException, UnrecognizedProfileSpecificationException, InvalidArgumentException, ProfileTableAlreadyExistsException, UnrecognizedComponentException {
        String tckPrefix = "tck.";
        if (!tableName.startsWith(tckPrefix)) {
            throw new TCKTestErrorException("Standard address profiles created by the tck must start with the \"" + tckPrefix + "\" prefix");
        }
        this.getProfileProvisioningProxy().createProfileTable(this.getStdAddressProfileSpecID(), tableName);
    }

    public void removeProfileTable(String tableName) throws TCKTestErrorException, UnrecognizedProfileTableNameException, ManagementException {
        this.getProfileProvisioningProxy().removeProfileTable(tableName);
    }

    public ProfileSpecificationID getStdAddressProfileSpecID() throws TCKTestErrorException, ManagementException, UnrecognizedComponentException {
        if (this.stdAddressProfileSpecID == null) {
            this.stdAddressProfileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("AddressProfileSpec", "javax.slee", "1.0");
            if (this.stdAddressProfileSpecID == null) {
                throw new TCKTestErrorException("Standard address profile specification not found");
            }
        }
        return this.stdAddressProfileSpecID;
    }

    public List getTCKStdAddressProfileTables() throws TCKTestErrorException, ManagementException, UnrecognizedProfileTableNameException, UnrecognizedComponentException {
        Vector<String> rTableNames = new Vector<String>();
        String tckPrefix = "tck.";
        for (String tableName : this.getProfileProvisioningProxy().getProfileTables()) {
            ProfileSpecificationID profSpecID = this.getProfileProvisioningProxy().getProfileSpecification(tableName);
            if (!profSpecID.equals((Object)this.getStdAddressProfileSpecID()) || !tableName.startsWith(tckPrefix)) continue;
            rTableNames.addElement(tableName);
        }
        return rTableNames;
    }
}

