/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.s3scala;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IOUtils$ {
    public static IOUtils$ MODULE$;

    static {
        new IOUtils$();
    }

    public InputStream toInputStream(File file) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(file);){
            int length = 0;
            byte[] buf = new byte[8192];
            while (length != -1) {
                length = in.read(buf);
                if (length <= 0) continue;
                out.write(buf, 0, length);
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public byte[] toBytes(InputStream in) {
        byte[] byArray;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int length = 0;
            byte[] buf = new byte[8192];
            while (length != -1) {
                length = in.read(buf);
                if (length <= 0) continue;
                out.write(buf, 0, length);
            }
            byArray = out.toByteArray();
        }
        finally {
            in.close();
        }
        return byArray;
    }

    public void write(File file, byte[] bytes) {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes);
        }
    }

    public void deleteDirectory(File dir) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & java.io.Serializable & Serializable)file -> {
            Boolean bl;
            if (file.isDirectory()) {
                this.deleteDirectory((File)file);
                bl = BoxedUnit.UNIT;
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)file.delete());
            }
            return bl;
        });
        dir.delete();
    }

    public void serializeObject(java.io.Serializable obj, File file) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(obj);
        }
    }

    public <T> T deserializeObject(File file) {
        Object object;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
            object = in.readObject();
        }
        return (T)object;
    }

    private IOUtils$() {
        MODULE$ = this;
    }
}

