/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade;

import java.util.Collection;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.admin.indices.upgrade.get.IndexUpgradeStatus;
import org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.junit.Assert;

public class UpgradeAssertions {
    private static Collection<IndexUpgradeStatus> getUpgradeStatus(Client client, String ... indices) throws Exception {
        UpgradeStatusResponse upgradeStatusResponse = (UpgradeStatusResponse)client.admin().indices().prepareUpgradeStatus(indices).get();
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)upgradeStatusResponse);
        return upgradeStatusResponse.getIndices().values();
    }

    public static void assertNotUpgraded(Client client, String ... index) throws Exception {
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            Assert.assertTrue((String)("index " + status.getIndex() + " should not be zero sized"), (status.getTotalBytes() != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("index " + status.getIndex() + " should have recovered some segments from transaction log"), (status.getTotalBytes() >= status.getToUpgradeBytes() ? 1 : 0) != 0);
            Assert.assertTrue((String)("index " + status.getIndex() + " should need upgrading"), (status.getToUpgradeBytes() != 0L ? 1 : 0) != 0);
        }
    }

    public static void assertUpgraded(Client client, String ... index) throws Exception {
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            Assert.assertTrue((String)("index " + status.getIndex() + " should not be zero sized"), (status.getTotalBytes() != 0L ? 1 : 0) != 0);
            Assert.assertEquals((String)("index " + status.getIndex() + " should be upgraded"), (long)0L, (long)status.getToUpgradeBytes());
        }
        IndicesSegmentResponse segsRsp = index == null ? (IndicesSegmentResponse)client.admin().indices().prepareSegments(new String[0]).execute().actionGet() : (IndicesSegmentResponse)client.admin().indices().prepareSegments(index).execute().actionGet();
        for (IndexSegments indexSegments : segsRsp.getIndices().values()) {
            for (IndexShardSegments shard : indexSegments) {
                for (ShardSegments segs : shard.getShards()) {
                    for (Segment seg : segs.getSegments()) {
                        Assert.assertEquals((String)("Index " + indexSegments.getIndex() + " has unupgraded segment " + seg.toString()), (long)Version.CURRENT.luceneVersion.major, (long)seg.version.major);
                        Assert.assertEquals((String)("Index " + indexSegments.getIndex() + " has unupgraded segment " + seg.toString()), (long)Version.CURRENT.luceneVersion.minor, (long)seg.version.minor);
                    }
                }
            }
        }
    }

    public static void assertNoAncientSegments(Client client, String ... index) throws Exception {
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            Assert.assertTrue((String)("index " + status.getIndex() + " should not be zero sized"), (status.getTotalBytes() != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("index " + status.getIndex() + " should not have any ancient segments"), (status.getToUpgradeBytesAncient() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("index " + status.getIndex() + " should have recovered some segments from transaction log"), (status.getTotalBytes() >= status.getToUpgradeBytes() ? 1 : 0) != 0);
            Assert.assertTrue((String)("index " + status.getIndex() + " should need upgrading"), (status.getToUpgradeBytes() != 0L ? 1 : 0) != 0);
        }
    }

    public static boolean hasOldButNotAncientSegments(Client client, String index) throws Exception {
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            if (status.getToUpgradeBytes() <= status.getToUpgradeBytesAncient()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpgraded(Client client, String index) throws Exception {
        ESLogger logger = Loggers.getLogger(UpgradeAssertions.class);
        int toUpgrade = 0;
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            logger.info("Index: " + status.getIndex() + ", total: " + status.getTotalBytes() + ", toUpgrade: " + status.getToUpgradeBytes(), new Object[0]);
            toUpgrade = (int)((long)toUpgrade + status.getToUpgradeBytes());
        }
        return toUpgrade == 0;
    }

    public static boolean hasAncientSegments(Client client, String index) throws Exception {
        for (IndexUpgradeStatus status : UpgradeAssertions.getUpgradeStatus(client, index)) {
            if (status.getToUpgradeBytesAncient() == 0L) continue;
            return true;
        }
        return false;
    }
}

