/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.recycler;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;

public class MockPageCacheRecycler
extends PageCacheRecycler {
    private static final ConcurrentMap<Object, Throwable> ACQUIRED_PAGES = Maps.newConcurrentMap();
    private final Random random;

    public static void ensureAllPagesAreReleased() throws Exception {
        boolean success;
        final HashMap masterCopy = Maps.newHashMap(ACQUIRED_PAGES);
        if (!masterCopy.isEmpty() && !(success = ESTestCase.awaitBusy(new Predicate<Object>(){

            public boolean apply(Object input) {
                return Sets.intersection(masterCopy.keySet(), ACQUIRED_PAGES.keySet()).isEmpty();
            }
        }))) {
            masterCopy.keySet().retainAll(ACQUIRED_PAGES.keySet());
            ACQUIRED_PAGES.keySet().removeAll(masterCopy.keySet());
            if (!masterCopy.isEmpty()) {
                Throwable t = (Throwable)masterCopy.entrySet().iterator().next().getValue();
                throw new RuntimeException(masterCopy.size() + " pages have not been released", t);
            }
        }
    }

    @Inject
    public MockPageCacheRecycler(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
        long seed = settings.getAsLong("test.cluster.node.seed", Long.valueOf(0L));
        this.random = new Random(seed);
    }

    private <T> Recycler.V<T> wrap(final Recycler.V<T> v) {
        ACQUIRED_PAGES.put(v, new Throwable());
        return new Recycler.V<T>(){

            public void close() {
                Throwable t = (Throwable)ACQUIRED_PAGES.remove(v);
                if (t == null) {
                    throw new IllegalStateException("Releasing a page that has not been acquired");
                }
                Object ref = this.v();
                if (ref instanceof Object[]) {
                    Arrays.fill((Object[])ref, 0, Array.getLength(ref), null);
                } else if (ref instanceof byte[]) {
                    Arrays.fill((byte[])ref, 0, Array.getLength(ref), (byte)MockPageCacheRecycler.this.random.nextInt(256));
                } else if (ref instanceof long[]) {
                    Arrays.fill((long[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextLong());
                } else if (ref instanceof int[]) {
                    Arrays.fill((int[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextInt());
                } else if (ref instanceof double[]) {
                    Arrays.fill((double[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextDouble() - 0.5);
                } else if (ref instanceof float[]) {
                    Arrays.fill((float[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextFloat() - 0.5f);
                } else {
                    for (int i = 0; i < Array.getLength(ref); ++i) {
                        Array.set(ref, i, (byte)MockPageCacheRecycler.this.random.nextInt(256));
                    }
                }
                v.close();
            }

            public T v() {
                return v.v();
            }

            public boolean isRecycled() {
                return v.isRecycled();
            }
        };
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        Recycler.V page = super.bytePage(clear);
        if (!clear) {
            Arrays.fill((byte[])page.v(), 0, ((byte[])page.v()).length, (byte)this.random.nextInt(256));
        }
        return this.wrap(page);
    }

    public Recycler.V<int[]> intPage(boolean clear) {
        Recycler.V page = super.intPage(clear);
        if (!clear) {
            Arrays.fill((int[])page.v(), 0, ((int[])page.v()).length, this.random.nextInt());
        }
        return this.wrap(page);
    }

    public Recycler.V<long[]> longPage(boolean clear) {
        Recycler.V page = super.longPage(clear);
        if (!clear) {
            Arrays.fill((long[])page.v(), 0, ((long[])page.v()).length, this.random.nextLong());
        }
        return this.wrap(page);
    }

    public Recycler.V<Object[]> objectPage() {
        return this.wrap(super.objectPage());
    }
}

