/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStatsAction;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;

public class MockInternalClusterInfoService
extends InternalClusterInfoService {
    private final ClusterName clusterName;
    private volatile NodeStats[] stats = new NodeStats[3];
    public static final Map<ShardRouting, String> DEV_NULL_MAP = Collections.unmodifiableMap(new StaticValueMap("/dev/null"));

    public static NodeStats makeStats(String nodeName, DiskUsage usage) {
        FsInfo.Path path = new FsInfo.Path("/dev/null", null, usage.getTotalBytes(), usage.getFreeBytes(), usage.getFreeBytes());
        FsInfo.Path[] paths = new FsInfo.Path[]{path};
        FsInfo fsInfo = new FsInfo(System.currentTimeMillis(), paths);
        return new NodeStats(new DiscoveryNode(nodeName, (TransportAddress)DummyTransportAddress.INSTANCE, Version.CURRENT), System.currentTimeMillis(), null, null, null, null, null, fsInfo, null, null, null, null);
    }

    @Inject
    public MockInternalClusterInfoService(Settings settings, NodeSettingsService nodeSettingsService, TransportNodesStatsAction transportNodesStatsAction, TransportIndicesStatsAction transportIndicesStatsAction, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, nodeSettingsService, transportNodesStatsAction, transportIndicesStatsAction, clusterService, threadPool);
        this.clusterName = ClusterName.clusterNameFromSettings((Settings)settings);
        this.stats[0] = MockInternalClusterInfoService.makeStats("node_t1", new DiskUsage("node_t1", "n1", "/dev/null", 100L, 100L));
        this.stats[1] = MockInternalClusterInfoService.makeStats("node_t2", new DiskUsage("node_t2", "n2", "/dev/null", 100L, 100L));
        this.stats[2] = MockInternalClusterInfoService.makeStats("node_t3", new DiskUsage("node_t3", "n3", "/dev/null", 100L, 100L));
    }

    public void setN1Usage(String nodeName, DiskUsage newUsage) {
        this.stats[0] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public void setN2Usage(String nodeName, DiskUsage newUsage) {
        this.stats[1] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public void setN3Usage(String nodeName, DiskUsage newUsage) {
        this.stats[2] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public CountDownLatch updateNodeStats(ActionListener<NodesStatsResponse> listener) {
        NodesStatsResponse response = new NodesStatsResponse(this.clusterName, this.stats);
        listener.onResponse((Object)response);
        return new CountDownLatch(0);
    }

    public CountDownLatch updateIndicesStats(ActionListener<IndicesStatsResponse> listener) {
        return new CountDownLatch(0);
    }

    public ClusterInfo getClusterInfo() {
        ClusterInfo clusterInfo = super.getClusterInfo();
        return new ClusterInfo(clusterInfo.getNodeLeastAvailableDiskUsages(), clusterInfo.getNodeMostAvailableDiskUsages(), clusterInfo.shardSizes, DEV_NULL_MAP);
    }

    private static final class StaticValueMap
    extends AbstractMap<ShardRouting, String> {
        private final String value;

        private StaticValueMap(String value) {
            this.value = value;
        }

        @Override
        public String get(Object key) {
            return this.value;
        }

        @Override
        public Set<Map.Entry<ShardRouting, String>> entrySet() {
            throw new UnsupportedOperationException("this is a test-only map that only supports #get(Object key)");
        }
    }

    public static class TestPlugin
    extends Plugin {
        public String name() {
            return "mock-cluster-info-service";
        }

        public String description() {
            return "a mock cluster info service for testing";
        }

        public void onModule(ClusterModule module) {
            module.clusterInfoServiceImpl = MockInternalClusterInfoService.class;
        }
    }
}

