/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.test.ESTestCase;

public class TestShardRouting {
    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state, long version) {
        return new ShardRouting(index, shardId, currentNodeId, null, null, primary, state, version, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), true, -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, long version) {
        return new ShardRouting(index, shardId, currentNodeId, relocatingNodeId, null, primary, state, version, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), true, -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, AllocationId allocationId, long version) {
        return new ShardRouting(index, shardId, currentNodeId, relocatingNodeId, null, primary, state, version, TestShardRouting.buildUnassignedInfo(state), allocationId, true, -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, RestoreSource restoreSource, boolean primary, ShardRoutingState state, long version) {
        return new ShardRouting(index, shardId, currentNodeId, relocatingNodeId, restoreSource, primary, state, version, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), true, -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, RestoreSource restoreSource, boolean primary, ShardRoutingState state, long version, UnassignedInfo unassignedInfo) {
        return new ShardRouting(index, shardId, currentNodeId, relocatingNodeId, restoreSource, primary, state, version, unassignedInfo, TestShardRouting.buildAllocationId(state), true, -1L);
    }

    private static AllocationId buildAllocationId(ShardRoutingState state) {
        switch (state) {
            case UNASSIGNED: {
                return null;
            }
            case INITIALIZING: 
            case STARTED: {
                return AllocationId.newInitializing();
            }
            case RELOCATING: {
                AllocationId allocationId = AllocationId.newInitializing();
                return AllocationId.newRelocation((AllocationId)allocationId);
            }
        }
        throw new IllegalStateException("illegal state");
    }

    private static UnassignedInfo buildUnassignedInfo(ShardRoutingState state) {
        switch (state) {
            case UNASSIGNED: 
            case INITIALIZING: {
                return new UnassignedInfo(ESTestCase.randomFrom(UnassignedInfo.Reason.values()), "auto generated for test");
            }
            case STARTED: 
            case RELOCATING: {
                return null;
            }
        }
        throw new IllegalStateException("illegal state");
    }
}

