/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.StreamsUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;

public abstract class CliToolTestCase
extends ESTestCase {
    @Before
    public void setPathHome() {
        System.setProperty("es.default.path.home", CliToolTestCase.createTempDir().toString());
    }

    @After
    public void clearPathHome() {
        System.clearProperty("es.default.path.home");
    }

    public static String[] args(String command) {
        if (!Strings.hasLength((String)command)) {
            return Strings.EMPTY_ARRAY;
        }
        return command.split("\\s+");
    }

    public static void assertTerminalOutputContainsHelpFile(CaptureOutputTerminal terminal, String classPath) throws IOException {
        ArrayList<String> nonEmptyLines = new ArrayList<String>();
        for (String line : terminal.getTerminalOutput()) {
            String originalPrintedLine = line.replaceAll(System.lineSeparator(), "");
            if (!Strings.isNullOrEmpty((String)originalPrintedLine)) continue;
            nonEmptyLines.add(originalPrintedLine);
        }
        CliToolTestCase.assertThat(nonEmptyLines, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        String expectedDocs = StreamsUtils.copyToStringFromClasspath(classPath);
        for (String nonEmptyLine : nonEmptyLines) {
            CliToolTestCase.assertThat((Object)expectedDocs, (Matcher)Matchers.containsString((String)nonEmptyLine.replaceAll(System.lineSeparator(), "")));
        }
    }

    public static class CaptureOutputTerminal
    extends MockTerminal {
        List<String> terminalOutput = new ArrayList<String>();

        public CaptureOutputTerminal() {
            super(Terminal.Verbosity.NORMAL);
        }

        public CaptureOutputTerminal(Terminal.Verbosity verbosity) {
            super(verbosity);
        }

        @Override
        protected void doPrint(String msg, Object ... args) {
            this.terminalOutput.add(String.format(Locale.ROOT, msg, args));
        }

        @Override
        public void print(String msg, Object ... args) {
            this.doPrint(msg, args);
        }

        @Override
        public void printStackTrace(Throwable t) {
            this.terminalOutput.add(ExceptionsHelper.stackTrace((Throwable)t));
        }

        public List<String> getTerminalOutput() {
            return this.terminalOutput;
        }
    }

    public static class MockTerminal
    extends Terminal {
        private static final PrintWriter DEV_NULL = new PrintWriter(new DevNullWriter());

        public MockTerminal() {
            super(Terminal.Verbosity.NORMAL);
        }

        public MockTerminal(Terminal.Verbosity verbosity) {
            super(verbosity);
        }

        protected void doPrint(String msg, Object ... args) {
        }

        public String readText(String text, Object ... args) {
            return null;
        }

        public char[] readSecret(String text, Object ... args) {
            return new char[0];
        }

        public void print(String msg, Object ... args) {
        }

        public void printStackTrace(Throwable t) {
        }

        public PrintWriter writer() {
            return DEV_NULL;
        }

        private static class DevNullWriter
        extends Writer {
            private DevNullWriter() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }
}

