/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.List;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushResponse;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ReusePeerRecoverySharedTest {
    public static void testCase(Settings indexSettings, Runnable restartCluster, ESLogger logger, boolean useSyncIds) {
        ElasticsearchAssertions.assertAcked(ESIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(Settings.builder().put(indexSettings).put(new Object[]{"index.routing.rebalance.enable", EnableAllocationDecider.Rebalance.NONE})));
        ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout("30s").get();
        logger.info("--> indexing docs", new Object[0]);
        for (int i = 0; i < 1000; ++i) {
            ESIntegTestCase.client().prepareIndex("test", "type").setSource("field", (Object)"value").execute().actionGet();
            if (i % 200 != 0) continue;
            ESIntegTestCase.client().admin().indices().prepareFlush(new String[0]).execute().actionGet();
        }
        if (ESTestCase.randomBoolean()) {
            ESIntegTestCase.client().admin().indices().prepareFlush(new String[0]).execute().actionGet();
        }
        logger.info("--> running cluster health", new Object[0]);
        ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout("30s").get();
        ESIntegTestCase.client().admin().indices().prepareForceMerge(new String[]{"test"}).setMaxNumSegments(100).get();
        ESIntegTestCase.client().admin().indices().prepareFlush(new String[0]).setWaitIfOngoing(true).setForce(true).get();
        if (!useSyncIds) {
            logger.info("--> disabling allocation while the cluster is shut down", new Object[0]);
            ESIntegTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.settingsBuilder().put(new Object[]{"cluster.routing.allocation.enable", EnableAllocationDecider.Allocation.NONE})).get();
            logger.info("--> full cluster restart", new Object[0]);
            restartCluster.run();
            logger.info("--> waiting for cluster to return to green after first shutdown", new Object[0]);
            ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout("30s").get();
        } else {
            logger.info("--> trying to sync flush", new Object[0]);
            Assert.assertEquals((long)((SyncedFlushResponse)ESIntegTestCase.client().admin().indices().prepareSyncedFlush(new String[]{"test"}).get()).failedShards(), (long)0L);
            ReusePeerRecoverySharedTest.assertSyncIdsNotNull();
        }
        logger.info("--> disabling allocation while the cluster is shut down{}", new Object[]{useSyncIds ? "" : " a second time"});
        ESIntegTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.settingsBuilder().put(new Object[]{"cluster.routing.allocation.enable", EnableAllocationDecider.Allocation.NONE})).get();
        logger.info("--> full cluster restart", new Object[0]);
        restartCluster.run();
        logger.info("--> waiting for cluster to return to green after {}shutdown", new Object[]{useSyncIds ? "" : "second "});
        ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout("30s").get();
        if (useSyncIds) {
            ReusePeerRecoverySharedTest.assertSyncIdsNotNull();
        }
        RecoveryResponse recoveryResponse = (RecoveryResponse)ESIntegTestCase.client().admin().indices().prepareRecoveries(new String[]{"test"}).get();
        for (RecoveryState recoveryState : (List)recoveryResponse.shardRecoveryStates().get("test")) {
            long recovered = 0L;
            for (RecoveryState.File file : recoveryState.getIndex().fileDetails()) {
                if (!file.name().startsWith("segments")) continue;
                recovered += file.length();
            }
            if (!recoveryState.getPrimary() && !useSyncIds) {
                logger.info("--> replica shard {} recovered from {} to {}, recovered {}, reuse {}", new Object[]{recoveryState.getShardId().getId(), recoveryState.getSourceNode().name(), recoveryState.getTargetNode().name(), recoveryState.getIndex().recoveredBytes(), recoveryState.getIndex().reusedBytes()});
                Assert.assertThat((String)"no bytes should be recovered", (Object)recoveryState.getIndex().recoveredBytes(), (Matcher)Matchers.equalTo((Object)recovered));
                Assert.assertThat((String)"data should have been reused", (Object)recoveryState.getIndex().reusedBytes(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
                Assert.assertThat((String)"all bytes should be reused except of the segments file", (Object)recoveryState.getIndex().reusedBytes(), (Matcher)Matchers.equalTo((Object)(recoveryState.getIndex().totalBytes() - recovered)));
                Assert.assertThat((String)"no files should be recovered except of the segments file", (Object)recoveryState.getIndex().recoveredFileCount(), (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((String)"all files should be reused except of the segments file", (Object)recoveryState.getIndex().reusedFileCount(), (Matcher)Matchers.equalTo((Object)(recoveryState.getIndex().totalFileCount() - 1)));
                Assert.assertThat((String)"> 0 files should be reused", (Object)recoveryState.getIndex().reusedFileCount(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                continue;
            }
            if (useSyncIds && !recoveryState.getPrimary()) {
                logger.info("--> replica shard {} recovered from {} to {} using sync id, recovered {}, reuse {}", new Object[]{recoveryState.getShardId().getId(), recoveryState.getSourceNode().name(), recoveryState.getTargetNode().name(), recoveryState.getIndex().recoveredBytes(), recoveryState.getIndex().reusedBytes()});
            }
            Assert.assertThat((Object)recoveryState.getIndex().recoveredBytes(), (Matcher)Matchers.equalTo((Object)0L));
            Assert.assertThat((Object)recoveryState.getIndex().reusedBytes(), (Matcher)Matchers.equalTo((Object)recoveryState.getIndex().totalBytes()));
            Assert.assertThat((Object)recoveryState.getIndex().recoveredFileCount(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)recoveryState.getIndex().reusedFileCount(), (Matcher)Matchers.equalTo((Object)recoveryState.getIndex().totalFileCount()));
        }
    }

    public static void assertSyncIdsNotNull() {
        IndexStats indexStats = ((IndicesStatsResponse)ESIntegTestCase.client().admin().indices().prepareStats(new String[]{"test"}).get()).getIndex("test");
        for (ShardStats shardStats : indexStats.getShards()) {
            Assert.assertNotNull(shardStats.getCommitStats().getUserData().get("sync_id"));
        }
    }
}

