/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.cache.request.IndicesRequestCache;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.threadpool.ThreadPool;

public class MockSearchService
extends SearchService {
    private static final Map<SearchContext, Throwable> ACTIVE_SEARCH_CONTEXTS = new ConcurrentHashMap<SearchContext, Throwable>();

    public static void assertNoInFLightContext() {
        HashMap<SearchContext, Throwable> copy = new HashMap<SearchContext, Throwable>(ACTIVE_SEARCH_CONTEXTS);
        if (!copy.isEmpty()) {
            throw new AssertionError("There are still " + copy.size() + " in-flight contexts", (Throwable)copy.values().iterator().next());
        }
    }

    @Inject
    public MockSearchService(Settings settings, NodeSettingsService nodeSettingsService, ClusterService clusterService, IndicesService indicesService, IndicesWarmer indicesWarmer, ThreadPool threadPool, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, DfsPhase dfsPhase, QueryPhase queryPhase, FetchPhase fetchPhase, IndicesRequestCache indicesQueryCache) {
        super(settings, nodeSettingsService, clusterService, indicesService, indicesWarmer, threadPool, scriptService, pageCacheRecycler, bigArrays, dfsPhase, queryPhase, fetchPhase, indicesQueryCache);
    }

    protected void putContext(SearchContext context) {
        super.putContext(context);
        ACTIVE_SEARCH_CONTEXTS.put(context, new RuntimeException());
    }

    protected SearchContext removeContext(long id) {
        SearchContext removed = super.removeContext(id);
        if (removed != null) {
            ACTIVE_SEARCH_CONTEXTS.remove(removed);
        }
        return removed;
    }

    public static class TestPlugin
    extends Plugin {
        public String name() {
            return "mock-search-service";
        }

        public String description() {
            return "a mock search service for testing";
        }

        public void onModule(SearchModule module) {
            module.searchServiceImpl = MockSearchService.class;
        }
    }
}

