/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.util.ArrayList;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.test.ESIntegTestCase;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class AbstractNumericTestCase
extends ESIntegTestCase {
    protected static long minValue;
    protected static long maxValue;
    protected static long minValues;
    protected static long maxValues;

    @Override
    public void setupSuiteScopeCluster() throws Exception {
        int i;
        this.createIndex("idx");
        this.createIndex("idx_unmapped");
        ArrayList<Object> builders = new ArrayList<IndexRequestBuilder>();
        int numDocs = 10;
        for (i = 0; i < 10; ++i) {
            builders.add(AbstractNumericTestCase.client().prepareIndex("idx", "type", "" + i).setSource(XContentFactory.jsonBuilder().startObject().field("value", i + 1).startArray("values").value(i + 2).value(i + 3).endArray().endObject()));
        }
        minValue = 1L;
        minValues = 2L;
        maxValue = 10L;
        maxValues = 12L;
        this.indexRandom(true, builders);
        this.prepareCreate("empty_bucket_idx").addMapping("type", new Object[]{"value", "type=integer"}).execute().actionGet();
        builders = new ArrayList();
        for (i = 0; i < 2; ++i) {
            builders.add(AbstractNumericTestCase.client().prepareIndex("empty_bucket_idx", "type", "" + i).setSource(XContentFactory.jsonBuilder().startObject().field("value", i * 2).endObject()));
        }
        this.indexRandom(true, builders);
        this.ensureSearchable(new String[0]);
    }

    public abstract void testEmptyAggregation() throws Exception;

    public abstract void testUnmapped() throws Exception;

    public abstract void testSingleValuedField() throws Exception;

    public abstract void testSingleValuedField_getProperty() throws Exception;

    public abstract void testSingleValuedField_PartiallyUnmapped() throws Exception;

    public abstract void testSingleValuedField_WithValueScript() throws Exception;

    public abstract void testSingleValuedField_WithValueScript_WithParams() throws Exception;

    public abstract void testMultiValuedField() throws Exception;

    public abstract void testMultiValuedField_WithValueScript() throws Exception;

    public abstract void testMultiValuedField_WithValueScript_WithParams() throws Exception;

    public abstract void testScript_SingleValued() throws Exception;

    public abstract void testScript_SingleValued_WithParams() throws Exception;

    public abstract void testScriptMultiValued() throws Exception;

    public abstract void testScriptMultiValuedWithParams() throws Exception;

    public abstract void testOrderByEmptyAggregation() throws Exception;
}

