/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SnapshotSharedTest {
    public static void testBasicWorkflow(ESLogger logger, ESIntegTestCase testCase, AfterSnapshotAction afterSnapshotAction, Matcher<Version> snapshotVersion) {
        int i;
        int i2;
        logger.info("-->  creating repository", new Object[0]);
        ElasticsearchAssertions.assertAcked(ESIntegTestCase.client().admin().cluster().preparePutRepository("test-repo").setType("fs").setSettings(Settings.settingsBuilder().put(new Object[]{"location", testCase.randomRepoPath()}).put("compress", ESTestCase.randomBoolean()).put("chunk_size", (long)ESTestCase.randomIntBetween(100, 1000), ByteSizeUnit.BYTES)));
        testCase.createIndex("test-idx-1", "test-idx-2", "test-idx-3");
        testCase.ensureGreen(new String[0]);
        logger.info("--> indexing some data", new Object[0]);
        for (int i3 = 0; i3 < 100; ++i3) {
            testCase.index("test-idx-1", "doc", Integer.toString(i3), "foo", "bar" + i3);
            testCase.index("test-idx-2", "doc", Integer.toString(i3), "foo", "baz" + i3);
            testCase.index("test-idx-3", "doc", Integer.toString(i3), "foo", "baz" + i3);
        }
        testCase.refresh();
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-1"}).get(), 100L);
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-2"}).get(), 100L);
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-3"}).get(), 100L);
        ListenableActionFuture flushResponseFuture = null;
        if (ESTestCase.randomBoolean()) {
            ArrayList<String> indicesToFlush = new ArrayList<String>();
            for (int i4 = 1; i4 < 4; ++i4) {
                if (!ESTestCase.randomBoolean()) continue;
                indicesToFlush.add("test-idx-" + i4);
            }
            if (!indicesToFlush.isEmpty()) {
                Object[] indices = indicesToFlush.toArray(new String[indicesToFlush.size()]);
                logger.info("--> starting asynchronous flush for indices {}", new Object[]{Arrays.toString(indices)});
                flushResponseFuture = ESIntegTestCase.client().admin().indices().prepareFlush((String[])indices).execute();
            }
        }
        logger.info("--> snapshot", new Object[0]);
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareCreateSnapshot("test-repo", "test-snap").setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        Assert.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        String snapshotName = ESIntegTestCase.getMinimumVersionInCluster().onOrAfter(Version.V_2_2_0) ? ESTestCase.randomFrom("test-snap", "_all", "*", "*-snap", "test*") : "test-snap";
        SnapshotInfo snapshotInfo = (SnapshotInfo)((GetSnapshotsResponse)ESIntegTestCase.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0);
        Assert.assertThat((Object)snapshotInfo.state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        Assert.assertThat((Object)snapshotInfo.version(), snapshotVersion);
        logger.info("--> delete some data", new Object[0]);
        for (i2 = 0; i2 < 50; ++i2) {
            ESIntegTestCase.client().prepareDelete("test-idx-1", "doc", Integer.toString(i2)).get();
        }
        for (i2 = 50; i2 < 100; ++i2) {
            ESIntegTestCase.client().prepareDelete("test-idx-2", "doc", Integer.toString(i2)).get();
        }
        for (i2 = 0; i2 < 100; i2 += 2) {
            ESIntegTestCase.client().prepareDelete("test-idx-3", "doc", Integer.toString(i2)).get();
        }
        ElasticsearchAssertions.assertAllSuccessful((BroadcastResponse)testCase.refresh());
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-1"}).get(), 50L);
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-2"}).get(), 50L);
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-3"}).get(), 50L);
        logger.info("--> close indices", new Object[0]);
        ESIntegTestCase.client().admin().indices().prepareClose(new String[]{"test-idx-1", "test-idx-2"}).get();
        afterSnapshotAction.run(new String[]{"test-idx-1", "test-idx-2", "test-idx-3"}, 50);
        logger.info("--> restore all indices from the snapshot", new Object[0]);
        RestoreSnapshotResponse restoreSnapshotResponse = (RestoreSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareRestoreSnapshot("test-repo", "test-snap").setWaitForCompletion(true).execute().actionGet();
        Assert.assertThat((Object)restoreSnapshotResponse.getRestoreInfo().totalShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        testCase.ensureGreen(new String[0]);
        for (i = 0; i < 5; ++i) {
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-1"}).get(), 100L);
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-2"}).get(), 100L);
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-3"}).get(), 50L);
        }
        logger.info("--> delete indices", new Object[0]);
        ESIntegTestCase.cluster().wipeIndices("test-idx-1", "test-idx-2");
        logger.info("--> restore one index after deletion", new Object[0]);
        restoreSnapshotResponse = (RestoreSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareRestoreSnapshot("test-repo", "test-snap").setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-2"}).execute().actionGet();
        Assert.assertThat((Object)restoreSnapshotResponse.getRestoreInfo().totalShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        testCase.ensureGreen(new String[0]);
        for (i = 0; i < 5; ++i) {
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESIntegTestCase.client().prepareSearch(new String[]{"test-idx-1"}).get(), 100L);
        }
        ClusterState clusterState = ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState();
        Assert.assertThat((Object)clusterState.getMetaData().hasIndex("test-idx-1"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)clusterState.getMetaData().hasIndex("test-idx-2"), (Matcher)Matchers.equalTo((Object)false));
        if (flushResponseFuture != null) {
            flushResponseFuture.actionGet();
        }
    }

    public static void testSnapshotMoreThanOnce(ESLogger logger, ESIntegTestCase testCase, AfterSnapshotAction actionBetweenSnapshots, int numberOfReplicas) throws Exception {
        logger.info("-->  creating repository", new Object[0]);
        ElasticsearchAssertions.assertAcked(ESIntegTestCase.client().admin().cluster().preparePutRepository("test-repo").setType("fs").setSettings(Settings.settingsBuilder().put(new Object[]{"location", testCase.randomRepoPath()}).put("compress", ESTestCase.randomBoolean()).put("chunk_size", (long)ESTestCase.randomIntBetween(100, 1000), ByteSizeUnit.BYTES)));
        ElasticsearchAssertions.assertAcked(ESIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(testCase.indexSettings()).setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", numberOfReplicas)));
        testCase.ensureGreen(new String[0]);
        logger.info("-->  indexing", new Object[0]);
        int numdocs = ESTestCase.randomIntBetween(10, 100);
        IndexRequestBuilder[] builders = new IndexRequestBuilder[numdocs];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = ESIntegTestCase.client().prepareIndex("test", "doc", Integer.toString(i)).setSource("foo", (Object)("bar" + i));
        }
        testCase.indexRandom(true, builders);
        testCase.flushAndRefresh(new String[0]);
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)ESIntegTestCase.client().admin().indices().prepareForceMerge(new String[]{"test"}).setFlush(true).setMaxNumSegments(1).get());
        CreateSnapshotResponse createSnapshotResponseFirst = (CreateSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareCreateSnapshot("test-repo", "test").setWaitForCompletion(true).setIndices(new String[]{"test"}).get();
        Assert.assertThat((Object)createSnapshotResponseFirst.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)createSnapshotResponseFirst.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponseFirst.getSnapshotInfo().totalShards()));
        Assert.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)ESIntegTestCase.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{"test"}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        SnapshotStatus snapshotStatus = (SnapshotStatus)((SnapshotsStatusResponse)ESIntegTestCase.client().admin().cluster().prepareSnapshotStatus("test-repo").setSnapshots(new String[]{"test"}).get()).getSnapshots().get(0);
        List shards = snapshotStatus.getShards();
        for (Object status : shards) {
            Assert.assertThat((Object)status.getStats().getProcessedFiles(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
        }
        actionBetweenSnapshots.run(new String[]{"test"}, numdocs);
        CreateSnapshotResponse createSnapshotResponseSecond = (CreateSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareCreateSnapshot("test-repo", "test-1").setWaitForCompletion(true).setIndices(new String[]{"test"}).get();
        Assert.assertThat((Object)createSnapshotResponseSecond.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)createSnapshotResponseSecond.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponseSecond.getSnapshotInfo().totalShards()));
        Assert.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)ESIntegTestCase.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{"test-1"}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        SnapshotStatus snapshotStatus2 = (SnapshotStatus)((SnapshotsStatusResponse)ESIntegTestCase.client().admin().cluster().prepareSnapshotStatus("test-repo").setSnapshots(new String[]{"test-1"}).get()).getSnapshots().get(0);
        List shards2 = snapshotStatus2.getShards();
        for (SnapshotIndexShardStatus status : shards2) {
            Assert.assertThat((Object)status.getStats().getProcessedFiles(), (Matcher)Matchers.equalTo((Object)0));
        }
        ESIntegTestCase.client().prepareDelete("test", "doc", "1").get();
        CreateSnapshotResponse createSnapshotResponseThird = (CreateSnapshotResponse)ESIntegTestCase.client().admin().cluster().prepareCreateSnapshot("test-repo", "test-2").setWaitForCompletion(true).setIndices(new String[]{"test"}).get();
        Assert.assertThat((Object)createSnapshotResponseThird.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)createSnapshotResponseThird.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponseThird.getSnapshotInfo().totalShards()));
        Assert.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)ESIntegTestCase.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{"test-2"}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        SnapshotStatus snapshotStatus3 = (SnapshotStatus)((SnapshotsStatusResponse)ESIntegTestCase.client().admin().cluster().prepareSnapshotStatus("test-repo").setSnapshots(new String[]{"test-2"}).get()).getSnapshots().get(0);
        List shards3 = snapshotStatus3.getShards();
        for (SnapshotIndexShardStatus status : shards3) {
            Assert.assertThat((Object)status.getStats().getProcessedFiles(), (Matcher)Matchers.equalTo((Object)2));
        }
    }

    public static interface AfterSnapshotAction {
        public static final AfterSnapshotAction NOOP = new AfterSnapshotAction(){

            @Override
            public void run(String[] indices, int numDocs) {
            }
        };

        public void run(String[] var1, int var2);
    }
}

