/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.EmptyClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocators;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.gateway.NoopGatewayAllocator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ESAllocationTestCase
extends ESTestCase {
    public static MockAllocationService createAllocationService() {
        return ESAllocationTestCase.createAllocationService(Settings.Builder.EMPTY_SETTINGS);
    }

    public static MockAllocationService createAllocationService(Settings settings) {
        return ESAllocationTestCase.createAllocationService(settings, ESAllocationTestCase.getRandom());
    }

    public static MockAllocationService createAllocationService(Settings settings, Random random) {
        return ESAllocationTestCase.createAllocationService(settings, new NodeSettingsService(Settings.Builder.EMPTY_SETTINGS), random);
    }

    public static MockAllocationService createAllocationService(Settings settings, NodeSettingsService nodeSettingsService, Random random) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, nodeSettingsService, random), new ShardsAllocators(settings, (GatewayAllocator)NoopGatewayAllocator.INSTANCE), (ClusterInfoService)EmptyClusterInfoService.INSTANCE);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterInfoService clusterInfoService) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, new NodeSettingsService(Settings.Builder.EMPTY_SETTINGS), ESAllocationTestCase.getRandom()), new ShardsAllocators(settings, (GatewayAllocator)NoopGatewayAllocator.INSTANCE), clusterInfoService);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator allocator) {
        return new MockAllocationService(settings, ESAllocationTestCase.randomAllocationDeciders(settings, new NodeSettingsService(Settings.Builder.EMPTY_SETTINGS), ESAllocationTestCase.getRandom()), new ShardsAllocators(settings, allocator), (ClusterInfoService)EmptyClusterInfoService.INSTANCE);
    }

    public static AllocationDeciders randomAllocationDeciders(Settings settings, NodeSettingsService nodeSettingsService, Random random) {
        List defaultAllocationDeciders = ClusterModule.DEFAULT_ALLOCATION_DECIDERS;
        ArrayList list = new ArrayList();
        for (Class deciderClass : ClusterModule.DEFAULT_ALLOCATION_DECIDERS) {
            try {
                try {
                    Constructor constructor = deciderClass.getConstructor(Settings.class, NodeSettingsService.class);
                    list.add(constructor.newInstance(settings, nodeSettingsService));
                }
                catch (NoSuchMethodException e) {
                    Constructor constructor = null;
                    constructor = deciderClass.getConstructor(Settings.class);
                    list.add(constructor.newInstance(settings));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ESAllocationTestCase.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)defaultAllocationDeciders.size()));
        for (AllocationDecider d : list) {
            ESAllocationTestCase.assertThat((Object)defaultAllocationDeciders.contains(d.getClass()), (Matcher)CoreMatchers.is((Object)true));
        }
        Collections.shuffle(list, random);
        return new AllocationDeciders(settings, list.toArray(new AllocationDecider[0]));
    }

    public static DiscoveryNode newNode(String nodeId) {
        return new DiscoveryNode(nodeId, (TransportAddress)DummyTransportAddress.INSTANCE, Version.CURRENT);
    }

    public static DiscoveryNode newNode(String nodeId, TransportAddress address) {
        return new DiscoveryNode(nodeId, address, Version.CURRENT);
    }

    public static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode("", nodeId, (TransportAddress)DummyTransportAddress.INSTANCE, attributes, Version.CURRENT);
    }

    public static DiscoveryNode newNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return new DiscoveryNode(nodeName, nodeId, (TransportAddress)DummyTransportAddress.INSTANCE, attributes, Version.CURRENT);
    }

    public static DiscoveryNode newNode(String nodeId, Version version) {
        return new DiscoveryNode(nodeId, (TransportAddress)DummyTransportAddress.INSTANCE, version);
    }

    public static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy) {
        List initializingShards = clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        if (initializingShards.isEmpty()) {
            return clusterState;
        }
        RoutingTable routingTable = strategy.applyStartedShards(clusterState, (List)CollectionUtils.arrayAsArrayList((Object[])new ShardRouting[]{(ShardRouting)initializingShards.get(ESAllocationTestCase.randomInt(initializingShards.size() - 1))})).routingTable();
        return ClusterState.builder((ClusterState)clusterState).routingTable(routingTable).build();
    }

    public static AllocationDeciders yesAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, new AllocationDecider[]{new TestAllocateDecision(Decision.YES)});
    }

    public static AllocationDeciders noAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, new AllocationDecider[]{new TestAllocateDecision(Decision.NO)});
    }

    public static AllocationDeciders throttleAllocationDeciders() {
        return new AllocationDeciders(Settings.EMPTY, new AllocationDecider[]{new TestAllocateDecision(Decision.THROTTLE)});
    }

    protected static class DelayedShardsMockGatewayAllocator
    extends GatewayAllocator {
        private final ReplicaShardAllocator replicaShardAllocator = new ReplicaShardAllocator(Settings.EMPTY){

            protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting shard, RoutingAllocation allocation) {
                return new AsyncShardFetch.FetchResult(shard.shardId(), null, Collections.emptySet(), Collections.emptySet());
            }
        };

        public DelayedShardsMockGatewayAllocator() {
            super(Settings.EMPTY, null, null);
        }

        public void applyStartedShards(StartedRerouteAllocation allocation) {
        }

        public void applyFailedShards(FailedRerouteAllocation allocation) {
        }

        public boolean allocateUnassigned(RoutingAllocation allocation) {
            RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
            boolean changed = false;
            while (unassignedIterator.hasNext()) {
                ShardRouting shard = unassignedIterator.next();
                if (shard.primary() || !shard.allocatedPostIndexCreate()) continue;
                changed |= this.replicaShardAllocator.ignoreUnassignedIfDelayed(unassignedIterator, shard);
            }
            return changed;
        }
    }

    protected static class MockAllocationService
    extends AllocationService {
        private Long nanoTimeOverride = null;

        public MockAllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocators shardsAllocators, ClusterInfoService clusterInfoService) {
            super(settings, allocationDeciders, shardsAllocators, clusterInfoService);
        }

        public void setNanoTimeOverride(long nanoTime) {
            this.nanoTimeOverride = nanoTime;
        }

        protected long currentNanoTime() {
            return this.nanoTimeOverride == null ? super.currentNanoTime() : this.nanoTimeOverride.longValue();
        }
    }

    public static class TestAllocateDecision
    extends AllocationDecider {
        private final Decision decision;

        public TestAllocateDecision(Decision decision) {
            super(Settings.EMPTY);
            this.decision = decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }
    }
}

