/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.impl.client.HttpClients;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.test.BackgroundIndexer;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.ExternalTestCluster;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.XContentTestUtils;
import org.elasticsearch.test.client.RandomizingClient;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.test.rest.client.http.HttpRequestBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

@LuceneTestCase.SuppressFileSystems(value={"ExtrasFS"})
@ReproduceInfoPrinter.Properties(value={"es.node.mode", "es.node.local", "tests.cluster", "tests.enable_mock_modules"})
public abstract class ESIntegTestCase
extends ESTestCase {
    public static final String SYSPROP_THIRDPARTY = "tests.thirdparty";
    public static final String SUITE_CLUSTER_NODE_PREFIX = "node_s";
    public static final String TEST_CLUSTER_NODE_PREFIX = "node_t";
    public static final String TESTS_CLIENT_RATIO = "tests.client.ratio";
    public static final String TESTS_CLUSTER = "tests.cluster";
    public static final String SETTING_INDEX_SEED = "index.tests.seed";
    public static final String TESTS_ENABLE_MOCK_MODULES = "tests.enable_mock_modules";
    private static final int FREQUENT_BULK_THRESHOLD = 300;
    private static final int ALWAYS_BULK_THRESHOLD = 3000;
    private static final int MAX_IN_FLIGHT_ASYNC_INDEXES = 150;
    private static final int MAX_BULK_INDEX_REQUEST_SIZE = 1000;
    protected static final int DEFAULT_MIN_NUM_SHARDS = 1;
    protected static final int DEFAULT_MAX_NUM_SHARDS = 10;
    private static TestCluster currentCluster;
    private static final double TRANSPORT_CLIENT_RATIO;
    private static final Map<Class<?>, TestCluster> clusters;
    private static ESIntegTestCase INSTANCE;
    private static Long SUITE_SEED;
    private static final String RANDOM_BOGUS_TYPE = "RANDOM_BOGUS_TYPE______";
    private AtomicInteger dummmyDocIdGenerator = new AtomicInteger();

    @BeforeClass
    public static void beforeClass() throws Exception {
        SUITE_SEED = ESIntegTestCase.randomLong();
        ESIntegTestCase.initializeSuiteScope();
    }

    protected final void beforeInternal() throws Exception {
        Scope currentClusterScope = this.getCurrentClusterScope();
        switch (currentClusterScope) {
            case SUITE: {
                assert (SUITE_SEED != null) : "Suite seed was not initialized";
                currentCluster = this.buildAndPutCluster(currentClusterScope, SUITE_SEED);
                break;
            }
            case TEST: {
                currentCluster = this.buildAndPutCluster(currentClusterScope, ESIntegTestCase.randomLong());
                break;
            }
            default: {
                ESIntegTestCase.fail((String)("Unknown Scope: [" + (Object)((Object)currentClusterScope) + "]"));
            }
        }
        ESIntegTestCase.cluster().beforeTest(ESIntegTestCase.getRandom(), this.getPerTestTransportClientRatio());
        ESIntegTestCase.cluster().wipe(this.excludeTemplates());
        this.randomIndexTemplate();
    }

    private void printTestMessage(String message) {
        if (ESIntegTestCase.isSuiteScopedTest(((Object)((Object)this)).getClass()) && this.getTestName().equals("<unknown>")) {
            this.logger.info("[{}]: {} suite", new Object[]{ESIntegTestCase.getTestClass().getSimpleName(), message});
        } else {
            this.logger.info("[{}#{}]: {} test", new Object[]{ESIntegTestCase.getTestClass().getSimpleName(), this.getTestName(), message});
        }
    }

    private MappedFieldType.Loading randomLoadingValues() {
        return ESIntegTestCase.randomFrom(MappedFieldType.Loading.values());
    }

    public void randomIndexTemplate() throws IOException {
        if (ESIntegTestCase.cluster().size() > 0) {
            Settings.Builder randomSettingsBuilder = this.setRandomIndexSettings(ESIntegTestCase.getRandom(), Settings.builder()).put(SETTING_INDEX_SEED, ESIntegTestCase.getRandom().nextLong());
            randomSettingsBuilder.put("index.number_of_shards", this.numberOfShards()).put("index.number_of_replicas", this.numberOfReplicas());
            LuceneTestCase.SuppressCodecs annotation = ((Object)((Object)this)).getClass().getAnnotation(LuceneTestCase.SuppressCodecs.class);
            if (annotation != null && annotation.value().length == 1 && "*".equals(annotation.value()[0])) {
                randomSettingsBuilder.put("index.codec", ESIntegTestCase.randomFrom("default", "best_compression"));
            } else {
                randomSettingsBuilder.put("index.codec", "lucene_default");
            }
            XContentBuilder mappings = null;
            if (ESIntegTestCase.frequently() && this.randomDynamicTemplates()) {
                mappings = XContentFactory.jsonBuilder().startObject().startObject("_default_");
                if (ESIntegTestCase.randomBoolean()) {
                    mappings.startObject("_timestamp").field("enabled", ESIntegTestCase.randomBoolean());
                    mappings.endObject();
                }
                mappings.startArray("dynamic_templates").startObject().startObject("template-strings").field("match_mapping_type", "string").startObject("mapping").startObject("fielddata").field("loading", (Object)this.randomLoadingValues()).endObject().endObject().endObject().endObject().startObject().startObject("template-longs").field("match_mapping_type", "long").startObject("mapping").field("doc_values", ESIntegTestCase.randomBoolean()).startObject("fielddata").field("loading", (Object)ESIntegTestCase.randomFrom(MappedFieldType.Loading.LAZY, MappedFieldType.Loading.EAGER)).endObject().endObject().endObject().endObject().startObject().startObject("template-doubles").field("match_mapping_type", "double").startObject("mapping").field("doc_values", ESIntegTestCase.randomBoolean()).startObject("fielddata").field("loading", (Object)ESIntegTestCase.randomFrom(MappedFieldType.Loading.LAZY, MappedFieldType.Loading.EAGER)).endObject().endObject().endObject().endObject().startObject().startObject("template-geo_points").field("match_mapping_type", "geo_point").startObject("mapping").field("doc_values", ESIntegTestCase.randomBoolean()).startObject("fielddata").field("loading", (Object)ESIntegTestCase.randomFrom(MappedFieldType.Loading.LAZY, MappedFieldType.Loading.EAGER)).endObject().endObject().endObject().endObject().startObject().startObject("template-booleans").field("match_mapping_type", "boolean").startObject("mapping").startObject("fielddata").field("format", ESIntegTestCase.randomFrom("array", "doc_values")).field("loading", (Object)ESIntegTestCase.randomFrom(MappedFieldType.Loading.LAZY, MappedFieldType.Loading.EAGER)).endObject().endObject().endObject().endObject().endArray();
                mappings.endObject().endObject();
            }
            for (String setting : randomSettingsBuilder.internalMap().keySet()) {
                ESIntegTestCase.assertThat((String)"non index. prefix setting set on index template, its a node setting...", (Object)setting, (Matcher)Matchers.startsWith((String)"index."));
            }
            PutIndexTemplateRequestBuilder putTemplate = ESIntegTestCase.client().admin().indices().preparePutTemplate("random_index_template").setTemplate("*").setOrder(0).setSettings(randomSettingsBuilder);
            if (mappings != null) {
                this.logger.info("test using _default_ mappings: [{}]", new Object[]{mappings.bytes().toUtf8()});
                putTemplate.addMapping("_default_", mappings);
            }
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)putTemplate.execute().actionGet());
        }
    }

    protected Settings.Builder setRandomIndexSettings(Random random, Settings.Builder builder) {
        ESIntegTestCase.setRandomIndexMergeSettings(random, builder);
        ESIntegTestCase.setRandomIndexTranslogSettings(random, builder);
        ESIntegTestCase.setRandomIndexNormsLoading(random, builder);
        if (random.nextBoolean()) {
            builder.put("index.merge.scheduler.auto_throttle", false);
        }
        if (random.nextBoolean()) {
            builder.put("index.requests.cache.enable", random.nextBoolean());
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.shard.check_on_startup", ESIntegTestCase.randomFrom(random, "false", "checksum", "true")});
        }
        if (ESIntegTestCase.randomBoolean()) {
            builder.put("index.unassigned.node_left.delayed_timeout", RandomInts.randomIntBetween((Random)random, (int)1, (int)15) + "ms");
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexMergeSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.compound_format", random.nextBoolean() ? (Constable)Double.valueOf(random.nextDouble()) : (Constable)Boolean.valueOf(random.nextBoolean())});
        }
        switch (random.nextInt(4)) {
            case 3: {
                int maxThreadCount = RandomInts.randomIntBetween((Random)random, (int)1, (int)4);
                int maxMergeCount = RandomInts.randomIntBetween((Random)random, (int)maxThreadCount, (int)(maxThreadCount + 4));
                builder.put("index.merge.scheduler.max_merge_count", maxMergeCount);
                builder.put("index.merge.scheduler.max_thread_count", maxThreadCount);
            }
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexNormsLoading(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.norms.loading", RandomPicks.randomFrom((Random)random, Arrays.asList(MappedFieldType.Loading.EAGER, MappedFieldType.Loading.LAZY))});
        }
        return builder;
    }

    private static Settings.Builder setRandomIndexTranslogSettings(Random random, Settings.Builder builder) {
        if (random.nextBoolean()) {
            builder.put("index.translog.flush_threshold_ops", RandomInts.randomIntBetween((Random)random, (int)1, (int)10000));
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.translog.flush_threshold_size", new ByteSizeValue((long)RandomInts.randomIntBetween((Random)random, (int)1, (int)300), ByteSizeUnit.MB)});
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.translog.flush_threshold_period", TimeValue.timeValueMinutes((long)RandomInts.randomIntBetween((Random)random, (int)1, (int)60))});
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.translog.interval", TimeValue.timeValueMillis((long)RandomInts.randomIntBetween((Random)random, (int)1, (int)10000))});
        }
        if (random.nextBoolean()) {
            builder.put("index.translog.disable_flush", random.nextBoolean());
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.translog.durability", RandomPicks.randomFrom((Random)random, (Object[])Translog.Durabilty.values())});
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"index.translog.fs.type", RandomPicks.randomFrom((Random)random, (Object[])TranslogWriter.Type.values())});
            if (ESIntegTestCase.rarely((Random)random)) {
                builder.put("index.translog.sync_interval", 0);
            } else {
                builder.put("index.translog.sync_interval", (long)RandomInts.randomIntBetween((Random)random, (int)100, (int)5000), TimeUnit.MILLISECONDS);
            }
        }
        return builder;
    }

    private TestCluster buildWithPrivateContext(final Scope scope, final long seed) throws Exception {
        return (TestCluster)RandomizedContext.current().runWithPrivateRandomness(new Randomness(seed, new SeedDecorator[0]), (Callable)new Callable<TestCluster>(){

            @Override
            public TestCluster call() throws Exception {
                return ESIntegTestCase.this.buildTestCluster(scope, seed);
            }
        });
    }

    private TestCluster buildAndPutCluster(Scope currentClusterScope, long seed) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        TestCluster testCluster = clusters.remove(clazz);
        ESIntegTestCase.clearClusters();
        switch (currentClusterScope) {
            case SUITE: {
                if (testCluster != null) break;
                testCluster = this.buildWithPrivateContext(currentClusterScope, seed);
                break;
            }
            case TEST: {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{testCluster});
                testCluster = this.buildTestCluster(currentClusterScope, seed);
            }
        }
        clusters.put(clazz, testCluster);
        return testCluster;
    }

    private static void clearClusters() throws IOException {
        if (!clusters.isEmpty()) {
            IOUtils.close(clusters.values());
            clusters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void afterInternal(boolean afterClass) throws Exception {
        boolean success = false;
        try {
            Scope currentClusterScope = this.getCurrentClusterScope();
            this.clearDisruptionScheme();
            try {
                if (ESIntegTestCase.cluster() != null) {
                    if (currentClusterScope != Scope.TEST) {
                        MetaData metaData = ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().execute().actionGet()).getState().getMetaData();
                        ESIntegTestCase.assertThat((String)("test leaves persistent cluster metadata behind: " + metaData.persistentSettings().getAsMap()), (Object)metaData.persistentSettings().getAsMap().size(), (Matcher)Matchers.equalTo((Object)0));
                        ESIntegTestCase.assertThat((String)("test leaves transient cluster metadata behind: " + metaData.transientSettings().getAsMap()), (Object)metaData.transientSettings().getAsMap().size(), (Matcher)Matchers.equalTo((Object)0));
                    }
                    this.ensureClusterSizeConsistency();
                    this.ensureClusterStateConsistency();
                    this.beforeIndexDeletion();
                    ESIntegTestCase.cluster().wipe(this.excludeTemplates());
                    if (afterClass || currentClusterScope == Scope.TEST) {
                        ESIntegTestCase.cluster().close();
                    }
                    ESIntegTestCase.cluster().assertAfterTest();
                }
            }
            finally {
                if (currentClusterScope == Scope.TEST) {
                    ESIntegTestCase.clearClusters();
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    protected Set<String> excludeTemplates() {
        return Collections.emptySet();
    }

    protected void beforeIndexDeletion() {
        ESIntegTestCase.cluster().beforeIndexDeletion();
    }

    public static TestCluster cluster() {
        return currentCluster;
    }

    public static boolean isInternalCluster() {
        return currentCluster instanceof InternalTestCluster;
    }

    public static InternalTestCluster internalCluster() {
        if (!ESIntegTestCase.isInternalCluster()) {
            throw new UnsupportedOperationException("current test cluster is immutable");
        }
        return (InternalTestCluster)currentCluster;
    }

    public ClusterService clusterService() {
        return ESIntegTestCase.internalCluster().clusterService();
    }

    public static Client client() {
        return ESIntegTestCase.client(null);
    }

    public static Client client(@Nullable String node) {
        if (node != null) {
            return ESIntegTestCase.internalCluster().client(node);
        }
        Object client = ESIntegTestCase.cluster().client();
        if (ESIntegTestCase.frequently()) {
            client = new RandomizingClient((Client)client, ESIntegTestCase.getRandom());
        }
        return client;
    }

    public static Client dataNodeClient() {
        Object client = ESIntegTestCase.internalCluster().dataNodeClient();
        if (ESIntegTestCase.frequently()) {
            client = new RandomizingClient((Client)client, ESIntegTestCase.getRandom());
        }
        return client;
    }

    public static Iterable<Client> clients() {
        return ESIntegTestCase.cluster();
    }

    protected int minimumNumberOfShards() {
        return 1;
    }

    protected int maximumNumberOfShards() {
        return 10;
    }

    protected int numberOfShards() {
        return ESIntegTestCase.between(this.minimumNumberOfShards(), this.maximumNumberOfShards());
    }

    protected int minimumNumberOfReplicas() {
        return 0;
    }

    protected int maximumNumberOfReplicas() {
        int maxNumReplicas = Math.max(0, ESIntegTestCase.cluster().maximumNumberOfReplicasThatCanBeReliablyAssigned());
        return ESIntegTestCase.frequently() ? Math.min(1, maxNumReplicas) : maxNumReplicas;
    }

    protected int numberOfReplicas() {
        return ESIntegTestCase.between(this.minimumNumberOfReplicas(), this.maximumNumberOfReplicas());
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        ESIntegTestCase.internalCluster().setDisruptionScheme(scheme);
    }

    public void clearDisruptionScheme() {
        if (ESIntegTestCase.isInternalCluster()) {
            ESIntegTestCase.internalCluster().clearDisruptionScheme();
        }
    }

    public Settings indexSettings() {
        int numberOfReplicas;
        Settings.Builder builder = Settings.builder();
        int numberOfShards = this.numberOfShards();
        if (numberOfShards > 0) {
            builder.put("index.number_of_shards", numberOfShards);
        }
        if ((numberOfReplicas = this.numberOfReplicas()) >= 0) {
            builder.put("index.number_of_replicas", numberOfReplicas);
        }
        if (ESIntegTestCase.randomInt(9) < 3) {
            String dataPath = ESIntegTestCase.randomAsciiOfLength(10);
            this.logger.info("using custom data_path for index: [{}]", new Object[]{dataPath});
            builder.put("index.data_path", dataPath);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createIndex(String ... names) {
        ArrayList<String> created = new ArrayList<String>();
        for (String name : names) {
            boolean success = false;
            try {
                ElasticsearchAssertions.assertAcked(this.prepareCreate(name));
                created.add(name);
                success = true;
            }
            finally {
                if (!success && !created.isEmpty()) {
                    ESIntegTestCase.cluster().wipeIndices(created.toArray(new String[created.size()]));
                }
            }
        }
    }

    public final CreateIndexRequestBuilder prepareCreate(String index) {
        return ESIntegTestCase.client().admin().indices().prepareCreate(index).setSettings(this.indexSettings());
    }

    public final CreateIndexRequestBuilder prepareCreate(String index, int numNodes) {
        return this.prepareCreate(index, numNodes, Settings.builder());
    }

    public CreateIndexRequestBuilder prepareCreate(String index, int numNodes, Settings.Builder settingsBuilder) {
        ESIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(numNodes);
        Settings.Builder builder = Settings.builder().put(this.indexSettings()).put(settingsBuilder.build());
        if (numNodes > 0) {
            this.getExcludeSettings(index, numNodes, builder);
        }
        return ESIntegTestCase.client().admin().indices().prepareCreate(index).setSettings(builder.build());
    }

    private Settings.Builder getExcludeSettings(String index, int num, Settings.Builder builder) {
        String exclude = Joiner.on((char)',').join(ESIntegTestCase.internalCluster().allDataNodesButN(num));
        builder.put("index.routing.allocation.exclude._name", exclude);
        return builder;
    }

    public void waitNoPendingTasksOnAll() throws Exception {
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).get());
        ESIntegTestCase.assertBusy(new Runnable(){

            @Override
            public void run() {
                for (Client client : ESIntegTestCase.clients()) {
                    ClusterHealthResponse clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(new String[0]).setLocal(true)).get();
                    Assert.assertThat((String)("client " + client + " still has in flight fetch"), (Object)clusterHealth.getNumberOfInFlightFetch(), (Matcher)Matchers.equalTo((Object)0));
                    PendingClusterTasksResponse pendingTasks = (PendingClusterTasksResponse)((PendingClusterTasksRequestBuilder)client.admin().cluster().preparePendingClusterTasks().setLocal(true)).get();
                    Assert.assertThat((String)("client " + client + " still has pending tasks " + pendingTasks.prettyPrint()), (Object)pendingTasks, (Matcher)Matchers.emptyIterable());
                    clusterHealth = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(new String[0]).setLocal(true)).get();
                    Assert.assertThat((String)("client " + client + " still has in flight fetch"), (Object)clusterHealth.getNumberOfInFlightFetch(), (Matcher)Matchers.equalTo((Object)0));
                }
            }
        });
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).get());
    }

    public void assertConcreteMappingsOnAll(String index, String type, String ... fieldNames) throws Exception {
        Set<String> nodes = ESIntegTestCase.internalCluster().nodesInclude(index);
        ESIntegTestCase.assertThat(nodes, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        for (String node : nodes) {
            IndicesService indicesService = ESIntegTestCase.internalCluster().getInstance(IndicesService.class, node);
            IndexService indexService = indicesService.indexService(index);
            ESIntegTestCase.assertThat((String)("index service doesn't exists on " + node), (Object)indexService, (Matcher)Matchers.notNullValue());
            DocumentMapper documentMapper = indexService.mapperService().documentMapper(type);
            ESIntegTestCase.assertThat((String)("document mapper doesn't exists on " + node), (Object)documentMapper, (Matcher)Matchers.notNullValue());
            for (String fieldName : fieldNames) {
                Collection matches = documentMapper.mappers().simpleMatchToFullName(fieldName);
                ESIntegTestCase.assertThat((String)("field " + fieldName + " doesn't exists on " + node), (Object)matches, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
            }
        }
        this.assertMappingOnMaster(index, type, fieldNames);
    }

    public void assertMappingOnMaster(String index, String type, String ... fieldNames) throws Exception {
        GetMappingsResponse response = (GetMappingsResponse)((GetMappingsRequestBuilder)ESIntegTestCase.client().admin().indices().prepareGetMappings(new String[]{index}).setTypes(new String[]{type})).get();
        ImmutableOpenMap mappings = (ImmutableOpenMap)response.getMappings().get((Object)index);
        ESIntegTestCase.assertThat((Object)mappings, (Matcher)Matchers.notNullValue());
        MappingMetaData mappingMetaData = (MappingMetaData)mappings.get((Object)type);
        ESIntegTestCase.assertThat((Object)mappingMetaData, (Matcher)Matchers.notNullValue());
        Map mappingSource = mappingMetaData.getSourceAsMap();
        ESIntegTestCase.assertFalse((boolean)mappingSource.isEmpty());
        ESIntegTestCase.assertTrue((boolean)mappingSource.containsKey("properties"));
        for (String fieldName : fieldNames) {
            Map mappingProperties = (Map)mappingSource.get("properties");
            if (fieldName.indexOf(46) != -1) {
                fieldName = fieldName.replace(".", ".properties.");
            }
            ESIntegTestCase.assertThat((String)("field " + fieldName + " doesn't exists in mapping " + mappingMetaData.source().string()), (Object)XContentMapValues.extractValue((String)fieldName, (Map)mappingProperties), (Matcher)Matchers.notNullValue());
        }
    }

    public void assertResultsAndLogOnFailure(long expectedResults, SearchResponse searchResponse) {
        if (searchResponse.getHits().getTotalHits() != expectedResults) {
            StringBuilder sb = new StringBuilder("search result contains [");
            sb.append(searchResponse.getHits().getTotalHits()).append("] results. expected [").append(expectedResults).append("]");
            String failMsg = sb.toString();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                sb.append("\n-> _index: [").append(hit.getIndex()).append("] type [").append(hit.getType()).append("] id [").append(hit.id()).append("]");
            }
            this.logger.warn(sb.toString(), new Object[0]);
            ESIntegTestCase.fail((String)failMsg);
        }
    }

    public void allowNodes(String index, int n) {
        Settings build;
        assert (index != null);
        ESIntegTestCase.internalCluster().ensureAtLeastNumDataNodes(n);
        Settings.Builder builder = Settings.builder();
        if (n > 0) {
            this.getExcludeSettings(index, n, builder);
        }
        if (!(build = builder.build()).getAsMap().isEmpty()) {
            this.logger.debug("allowNodes: updating [{}]'s setting to [{}]", new Object[]{index, build.toDelimitedString(';')});
            ESIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(build).execute().actionGet();
        }
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForRelocatingShards(0)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureGreen timed out, cluster state:\n{}\n{}", new Object[]{((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState().prettyPrint(), ((PendingClusterTasksResponse)ESIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint()});
            ESIntegTestCase.fail((String)"timed out waiting for green state");
        }
        ESIntegTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)ClusterHealthStatus.GREEN));
        this.logger.debug("indices {} are green", new Object[]{indices.length == 0 ? "[_all]" : indices});
        return actionGet.getStatus();
    }

    public ClusterHealthStatus waitForRelocation() {
        return this.waitForRelocation(null);
    }

    public ClusterHealthStatus waitForRelocation(ClusterHealthStatus status) {
        ClusterHealthResponse actionGet;
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])new String[0]).waitForRelocatingShards(0);
        if (status != null) {
            request.waitForStatus(status);
        }
        if ((actionGet = (ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().health(request).actionGet()).isTimedOut()) {
            this.logger.info("waitForRelocation timed out (status={}), cluster state:\n{}\n{}", new Object[]{status, ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState().prettyPrint(), ((PendingClusterTasksResponse)ESIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint()});
            ESIntegTestCase.assertThat((String)"timed out waiting for relocation", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        if (status != null) {
            ESIntegTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)status));
        }
        return actionGet.getStatus();
    }

    public long waitForDocs(long numDocs) throws InterruptedException {
        return this.waitForDocs(numDocs, null);
    }

    public long waitForDocs(long numDocs, @Nullable BackgroundIndexer indexer) throws InterruptedException {
        return this.waitForDocs(numDocs, 90, TimeUnit.SECONDS, indexer);
    }

    public long waitForDocs(final long numDocs, int maxWaitTime, TimeUnit maxWaitTimeUnit, final @Nullable BackgroundIndexer indexer) throws InterruptedException {
        final AtomicLong lastKnownCount = new AtomicLong(-1L);
        long lastStartCount = -1L;
        Predicate<Object> testDocs = new Predicate<Object>(){

            public boolean apply(Object o) {
                if (indexer != null) {
                    lastKnownCount.set(indexer.totalIndexedDocs());
                }
                if (lastKnownCount.get() >= numDocs) {
                    try {
                        long count = ((CountResponse)ESIntegTestCase.client().prepareCount(new String[0]).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet()).getCount();
                        if (count == lastKnownCount.get()) {
                            ESIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).get();
                        }
                        lastKnownCount.set(count);
                    }
                    catch (Throwable e) {
                        ESIntegTestCase.this.logger.debug("failed to executed count", e, new Object[0]);
                        return false;
                    }
                    ESIntegTestCase.this.logger.debug("[{}] docs visible for search. waiting for [{}]", new Object[]{lastKnownCount.get(), numDocs});
                } else {
                    ESIntegTestCase.this.logger.debug("[{}] docs indexed. waiting for [{}]", new Object[]{lastKnownCount.get(), numDocs});
                }
                return lastKnownCount.get() >= numDocs;
            }
        };
        while (!ESIntegTestCase.awaitBusy(testDocs, maxWaitTime, maxWaitTimeUnit)) {
            if (lastStartCount == lastKnownCount.get()) {
                ESIntegTestCase.fail((String)("failed to reach " + numDocs + "docs"));
            }
            lastStartCount = lastKnownCount.get();
        }
        return lastKnownCount.get();
    }

    public void setMinimumMasterNodes(int n) {
        ESIntegTestCase.assertTrue((boolean)((ClusterUpdateSettingsResponse)ESIntegTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.settingsBuilder().put("discovery.zen.minimum_master_nodes", n)).get()).isAcknowledged());
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForRelocatingShards(0).waitForYellowStatus().waitForEvents(Priority.LANGUID)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureYellow timed out, cluster state:\n{}\n{}", new Object[]{((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState().prettyPrint(), ((PendingClusterTasksResponse)ESIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint()});
            ESIntegTestCase.assertThat((String)"timed out waiting for yellow", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        this.logger.debug("indices {} are yellow", new Object[]{indices.length == 0 ? "[_all]" : indices});
        return actionGet.getStatus();
    }

    public void logClusterState() {
        this.logger.debug("cluster state:\n{}\n{}", new Object[]{((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState().prettyPrint(), ((PendingClusterTasksResponse)ESIntegTestCase.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint()});
    }

    public void logSegmentsState(String ... indices) throws Exception {
        IndicesSegmentResponse segsRsp = (IndicesSegmentResponse)ESIntegTestCase.client().admin().indices().prepareSegments(indices).get();
        this.logger.debug("segments {} state: \n{}", new Object[]{indices.length == 0 ? "[_all]" : indices, segsRsp.toXContent(JsonXContent.contentBuilder().prettyPrint(), ToXContent.EMPTY_PARAMS).string()});
    }

    public void logMemoryStats() {
        this.logger.info("memory: {}", new Object[]{XContentHelper.toString((ToXContent)((ToXContent)ESIntegTestCase.client().admin().cluster().prepareNodesStats(new String[0]).clear().setJvm(true).get()))});
    }

    void ensureClusterSizeConsistency() {
        if (ESIntegTestCase.cluster() != null) {
            this.logger.trace("Check consistency for [{}] nodes", new Object[]{ESIntegTestCase.cluster().size()});
            ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)ESIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(ESIntegTestCase.cluster().size())).get());
        }
    }

    protected void ensureClusterStateConsistency() throws IOException {
        if (ESIntegTestCase.cluster() != null) {
            ClusterState masterClusterState = ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().all().get()).getState();
            byte[] masterClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)masterClusterState);
            masterClusterState = ClusterState.Builder.fromBytes((byte[])masterClusterStateBytes, null);
            Map<String, Object> masterStateMap = XContentTestUtils.convertToMap((ToXContent)masterClusterState);
            int masterClusterStateSize = masterClusterState.toString().length();
            String masterId = masterClusterState.nodes().masterNodeId();
            for (Client client : ESIntegTestCase.cluster()) {
                ClusterState localClusterState = ((ClusterStateResponse)((ClusterStateRequestBuilder)client.admin().cluster().prepareState().all().setLocal(true)).get()).getState();
                byte[] localClusterStateBytes = ClusterState.Builder.toBytes((ClusterState)localClusterState);
                localClusterState = ClusterState.Builder.fromBytes((byte[])localClusterStateBytes, null);
                Map<String, Object> localStateMap = XContentTestUtils.convertToMap((ToXContent)localClusterState);
                int localClusterStateSize = localClusterState.toString().length();
                if (masterClusterState.version() != localClusterState.version() || !masterId.equals(localClusterState.nodes().masterNodeId())) continue;
                try {
                    ESIntegTestCase.assertEquals((String)"clusterstate UUID does not match", (Object)masterClusterState.stateUUID(), (Object)localClusterState.stateUUID());
                    ESIntegTestCase.assertEquals((String)"clusterstate size does not match", (long)masterClusterStateSize, (long)localClusterStateSize);
                    ESIntegTestCase.assertNull((String)"clusterstate JSON serialization does not match", (Object)XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder(masterStateMap, localStateMap));
                }
                catch (AssertionError error) {
                    this.logger.error("Cluster state from master:\n{}\nLocal cluster state:\n{}", new Object[]{masterClusterState.toString(), localClusterState.toString()});
                    throw error;
                }
            }
        }
    }

    protected ClusterHealthStatus ensureSearchable(String ... indices) {
        return this.ensureGreen(indices);
    }

    protected void ensureStableCluster(int nodeCount) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L));
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue) {
        this.ensureStableCluster(nodeCount, timeValue, false, null);
    }

    protected void ensureStableCluster(int nodeCount, @Nullable String viaNode) {
        this.ensureStableCluster(nodeCount, TimeValue.timeValueSeconds((long)30L), false, viaNode);
    }

    protected void ensureStableCluster(int nodeCount, TimeValue timeValue, boolean local, @Nullable String viaNode) {
        if (viaNode == null) {
            viaNode = ESIntegTestCase.randomFrom(ESIntegTestCase.internalCluster().getNodeNames());
        }
        this.logger.debug("ensuring cluster is stable with [{}] nodes. access node: [{}]. timeout: [{}]", new Object[]{nodeCount, viaNode, timeValue});
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)ESIntegTestCase.client(viaNode).admin().cluster().prepareHealth(new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForNodes(Integer.toString(nodeCount)).setTimeout(timeValue).setLocal(local)).setWaitForRelocatingShards(0).get();
        if (clusterHealthResponse.isTimedOut()) {
            ClusterStateResponse stateResponse = (ClusterStateResponse)ESIntegTestCase.client(viaNode).admin().cluster().prepareState().get();
            ESIntegTestCase.fail((String)("failed to reach a stable cluster of [" + nodeCount + "] nodes. Tried via [" + viaNode + "]. last cluster state:\n" + stateResponse.getState().prettyPrint()));
        }
        ESIntegTestCase.assertThat((Object)clusterHealthResponse.isTimedOut(), (Matcher)Matchers.is((Object)false));
    }

    protected final IndexResponse index(String index, String type, XContentBuilder source) {
        return (IndexResponse)ESIntegTestCase.client().prepareIndex(index, type).setSource(source).execute().actionGet();
    }

    protected final IndexResponse index(String index, String type, String id, Map<String, Object> source) {
        return (IndexResponse)ESIntegTestCase.client().prepareIndex(index, type, id).setSource(source).execute().actionGet();
    }

    protected final GetResponse get(String index, String type, String id) {
        return (GetResponse)ESIntegTestCase.client().prepareGet(index, type, id).execute().actionGet();
    }

    protected final IndexResponse index(String index, String type, String id, XContentBuilder source) {
        return (IndexResponse)ESIntegTestCase.client().prepareIndex(index, type, id).setSource(source).execute().actionGet();
    }

    public final IndexResponse index(String index, String type, String id, Object ... source) {
        return (IndexResponse)ESIntegTestCase.client().prepareIndex(index, type, id).setSource(source).execute().actionGet();
    }

    protected final IndexResponse index(String index, String type, String id, String source) {
        return (IndexResponse)ESIntegTestCase.client().prepareIndex(index, type, id).setSource(source).execute().actionGet();
    }

    public final RefreshResponse refresh() {
        this.waitForRelocation();
        RefreshResponse actionGet = (RefreshResponse)ESIntegTestCase.client().admin().indices().prepareRefresh(new String[0]).execute().actionGet();
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)actionGet);
        return actionGet;
    }

    public final void flushAndRefresh(String ... indices) {
        this.flush(indices);
        this.refresh();
    }

    protected final FlushResponse flush(String ... indices) {
        this.waitForRelocation();
        FlushResponse actionGet = (FlushResponse)ESIntegTestCase.client().admin().indices().prepareFlush(indices).setWaitIfOngoing(true).execute().actionGet();
        for (ShardOperationFailedException failure : actionGet.getShardFailures()) {
            ESIntegTestCase.assertThat((String)("unexpected flush failure " + failure.reason()), (Object)failure.status(), (Matcher)Matchers.equalTo((Object)RestStatus.SERVICE_UNAVAILABLE));
        }
        return actionGet;
    }

    protected ForceMergeResponse forceMerge() {
        this.waitForRelocation();
        ForceMergeResponse actionGet = (ForceMergeResponse)ESIntegTestCase.client().admin().indices().prepareForceMerge(new String[0]).setMaxNumSegments(1).execute().actionGet();
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)actionGet);
        return actionGet;
    }

    protected boolean indexExists(String index) {
        IndicesExistsResponse actionGet = (IndicesExistsResponse)ESIntegTestCase.client().admin().indices().prepareExists(new String[]{index}).execute().actionGet();
        return actionGet.isExists();
    }

    protected final void enableAllocation(String ... indices) {
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(indices).setSettings(Settings.builder().put("index.routing.allocation.enable", "all")).get();
    }

    protected final void disableAllocation(String ... indices) {
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(indices).setSettings(Settings.builder().put("index.routing.allocation.enable", "none")).get();
    }

    protected AdminClient admin() {
        return ESIntegTestCase.client().admin();
    }

    public void indexRandom(boolean forceRefresh, IndexRequestBuilder ... builders) throws InterruptedException, ExecutionException {
        this.indexRandom(forceRefresh, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, IndexRequestBuilder ... builders) throws InterruptedException, ExecutionException {
        this.indexRandom(forceRefresh, dummyDocuments, Arrays.asList(builders));
    }

    public void indexRandom(boolean forceRefresh, List<IndexRequestBuilder> builders) throws InterruptedException, ExecutionException {
        this.indexRandom(forceRefresh, forceRefresh, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, List<IndexRequestBuilder> builders) throws InterruptedException, ExecutionException {
        this.indexRandom(forceRefresh, dummyDocuments, true, builders);
    }

    public void indexRandom(boolean forceRefresh, boolean dummyDocuments, boolean maybeFlush, List<IndexRequestBuilder> builders) throws InterruptedException, ExecutionException {
        Object[] indices;
        Random random = ESIntegTestCase.getRandom();
        HashSet<String> indicesSet = new HashSet<String>();
        for (IndexRequestBuilder builder : builders) {
            indicesSet.add(((IndexRequest)builder.request()).index());
        }
        HashSet<Tuple> bogusIds = new HashSet<Tuple>();
        if (random.nextBoolean() && !builders.isEmpty() && dummyDocuments) {
            builders = new ArrayList<IndexRequestBuilder>(builders);
            indices = indicesSet.toArray(new String[indicesSet.size()]);
            int numBogusDocs = ESIntegTestCase.scaledRandomIntBetween(1, builders.size() * 2);
            int unicodeLen = ESIntegTestCase.between(1, 10);
            for (int i = 0; i < numBogusDocs; ++i) {
                String string = ESIntegTestCase.randomRealisticUnicodeOfLength(unicodeLen) + Integer.toString(this.dummmyDocIdGenerator.incrementAndGet());
                String index = (String)RandomPicks.randomFrom((Random)random, (Object[])indices);
                bogusIds.add(new Tuple((Object)index, (Object)string));
                builders.add(ESIntegTestCase.client().prepareIndex(index, RANDOM_BOGUS_TYPE, string).setSource("{}"));
            }
        }
        indices = indicesSet.toArray(new String[indicesSet.size()]);
        Collections.shuffle(builders, random);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ArrayList<CountDownLatch> inFlightAsyncOperations = new ArrayList<CountDownLatch>();
        if (builders.size() < 300 ? ESIntegTestCase.frequently() : builders.size() < 3000 && ESIntegTestCase.rarely()) {
            if (ESIntegTestCase.frequently()) {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", new Object[]{builders.size(), true, false});
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.execute(new PayloadLatchedActionListener(indexRequestBuilder, ESIntegTestCase.newLatch(inFlightAsyncOperations), errors));
                    this.postIndexAsyncActions((String[])indices, inFlightAsyncOperations, maybeFlush);
                }
            } else {
                this.logger.info("Index [{}] docs async: [{}] bulk: [{}]", new Object[]{builders.size(), false, false});
                for (IndexRequestBuilder indexRequestBuilder : builders) {
                    indexRequestBuilder.execute().actionGet();
                    this.postIndexAsyncActions((String[])indices, inFlightAsyncOperations, maybeFlush);
                }
            }
        } else {
            List partition = CollectionUtils.eagerPartition(builders, (int)Math.min(1000, Math.max(1, (int)((double)builders.size() * ESIntegTestCase.randomDouble()))));
            this.logger.info("Index [{}] docs async: [{}] bulk: [{}] partitions [{}]", new Object[]{builders.size(), false, true, partition.size()});
            Iterator iterator = partition.iterator();
            while (iterator.hasNext()) {
                List segmented = (List)iterator.next();
                BulkRequestBuilder bulkBuilder = ESIntegTestCase.client().prepareBulk();
                for (IndexRequestBuilder indexRequestBuilder2 : segmented) {
                    bulkBuilder.add(indexRequestBuilder2);
                }
                BulkResponse actionGet = (BulkResponse)bulkBuilder.execute().actionGet();
                ESIntegTestCase.assertThat((String)(actionGet.hasFailures() ? actionGet.buildFailureMessage() : ""), (Object)actionGet.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
            }
        }
        for (CountDownLatch countDownLatch : inFlightAsyncOperations) {
            countDownLatch.await();
        }
        ArrayList<Object> actualErrors = new ArrayList<Object>();
        for (Tuple tuple : errors) {
            if (ExceptionsHelper.unwrapCause((Throwable)((Throwable)tuple.v2())) instanceof EsRejectedExecutionException) {
                ((IndexRequestBuilder)tuple.v1()).execute().actionGet();
                continue;
            }
            actualErrors.add(tuple.v2());
        }
        ESIntegTestCase.assertThat(actualErrors, (Matcher)Matchers.emptyIterable());
        if (!bogusIds.isEmpty()) {
            for (Tuple doc : bogusIds) {
                DeleteResponse deleteResponse = (DeleteResponse)ESIntegTestCase.client().prepareDelete((String)doc.v1(), RANDOM_BOGUS_TYPE, (String)doc.v2()).get();
                if (deleteResponse.isFound()) continue;
                this.logger.warn("failed to delete a dummy doc [{}][{}]", new Object[]{doc.v1(), doc.v2()});
            }
        }
        if (forceRefresh) {
            ElasticsearchAssertions.assertNoFailures((BroadcastResponse)((RefreshRequestBuilder)ESIntegTestCase.client().admin().indices().prepareRefresh((String[])indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute().get());
        }
    }

    public static void disableTranslogFlush(String index) {
        Settings settings = Settings.builder().put("index.translog.disable_flush", true).build();
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
    }

    public static void enableTranslogFlush(String index) {
        Settings settings = Settings.builder().put("index.translog.disable_flush", false).build();
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
    }

    public static void disableIndexBlock(String index, String block) {
        Settings settings = Settings.builder().put(block, false).build();
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
    }

    public static void enableIndexBlock(String index, String block) {
        Settings settings = Settings.builder().put(block, true).build();
        ESIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).get();
    }

    public static void setClusterReadOnly(boolean value) {
        Settings settings = Settings.settingsBuilder().put("cluster.blocks.read_only", value).build();
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)ESIntegTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(settings).get());
    }

    private static CountDownLatch newLatch(List<CountDownLatch> latches) {
        CountDownLatch l = new CountDownLatch(1);
        latches.add(l);
        return l;
    }

    private void postIndexAsyncActions(String[] indices, List<CountDownLatch> inFlightAsyncOperations, boolean maybeFlush) throws InterruptedException {
        if (ESIntegTestCase.rarely()) {
            if (ESIntegTestCase.rarely()) {
                ((RefreshRequestBuilder)ESIntegTestCase.client().admin().indices().prepareRefresh(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute(new LatchedActionListener(ESIntegTestCase.newLatch(inFlightAsyncOperations)));
            } else if (maybeFlush && ESIntegTestCase.rarely()) {
                if (ESIntegTestCase.randomBoolean() || ESIntegTestCase.getMinimumVersionInCluster().before(Version.V_2_2_0)) {
                    ((FlushRequestBuilder)ESIntegTestCase.client().admin().indices().prepareFlush(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).execute(new LatchedActionListener(ESIntegTestCase.newLatch(inFlightAsyncOperations)));
                } else {
                    ESIntegTestCase.client().admin().indices().syncedFlush((SyncedFlushRequest)Requests.syncedFlushRequest((String[])indices).indicesOptions(IndicesOptions.lenientExpandOpen()), new LatchedActionListener(ESIntegTestCase.newLatch(inFlightAsyncOperations)));
                }
            } else if (ESIntegTestCase.rarely()) {
                ((ForceMergeRequestBuilder)ESIntegTestCase.client().admin().indices().prepareForceMerge(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen())).setMaxNumSegments(ESIntegTestCase.between(1, 10)).setFlush(maybeFlush && ESIntegTestCase.randomBoolean()).execute(new LatchedActionListener(ESIntegTestCase.newLatch(inFlightAsyncOperations)));
            }
        }
        while (inFlightAsyncOperations.size() > 150) {
            int waitFor = ESIntegTestCase.between(0, inFlightAsyncOperations.size() - 1);
            inFlightAsyncOperations.remove(waitFor).await();
        }
    }

    public void clearScroll(String ... scrollIds) {
        ClearScrollResponse clearResponse = (ClearScrollResponse)ESIntegTestCase.client().prepareClearScroll().setScrollIds(Arrays.asList(scrollIds)).get();
        ESIntegTestCase.assertThat((Object)clearResponse.isSucceeded(), (Matcher)Matchers.equalTo((Object)true));
    }

    private static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        if (clazz == Object.class || clazz == ESIntegTestCase.class) {
            return null;
        }
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return ESIntegTestCase.getAnnotation(clazz.getSuperclass(), annotationClass);
    }

    private Scope getCurrentClusterScope() {
        return ESIntegTestCase.getCurrentClusterScope(((Object)((Object)this)).getClass());
    }

    private static Scope getCurrentClusterScope(Class<?> clazz) {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(clazz, ClusterScope.class);
        return annotation == null ? Scope.SUITE : annotation.scope();
    }

    private int getNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numDataNodes();
    }

    private int getMinNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.minNumDataNodes() == -1 ? 1 : annotation.minNumDataNodes();
    }

    private int getMaxNumDataNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.maxNumDataNodes() == -1 ? InternalTestCluster.DEFAULT_MAX_NUM_DATA_NODES : annotation.maxNumDataNodes();
    }

    private int getNumClientNodes() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null ? -1 : annotation.numClientNodes();
    }

    private boolean randomDynamicTemplates() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        return annotation == null || annotation.randomDynamicTemplates();
    }

    protected Settings nodeSettings(int nodeOrdinal) {
        Settings.Builder builder = Settings.settingsBuilder().put("cluster.routing.allocation.disk.watermark.low", "1b").put("cluster.routing.allocation.disk.watermark.high", "1b").put("script.indexed", "on").put("script.inline", "on").put(new Object[]{"indices.store.delete.shard.timeout", new TimeValue(1L, TimeUnit.SECONDS)});
        return builder.build();
    }

    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Collections.emptyList();
    }

    protected Collection<Class<? extends Plugin>> transportClientPlugins() {
        return Collections.emptyList();
    }

    protected static Collection<Class<? extends Plugin>> pluginList(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings transportClientSettings() {
        return Settings.EMPTY;
    }

    private ExternalTestCluster buildExternalCluster(String clusterAddresses) throws UnknownHostException {
        String[] stringAddresses = clusterAddresses.split(",");
        TransportAddress[] transportAddresses = new TransportAddress[stringAddresses.length];
        int i = 0;
        for (String stringAddress : stringAddresses) {
            String[] split = stringAddress.split(":");
            if (split.length < 2) {
                throw new IllegalArgumentException("address [" + clusterAddresses + "] not valid");
            }
            try {
                transportAddresses[i++] = new InetSocketTransportAddress(InetAddress.getByName(split[0]), Integer.valueOf(split[1]).intValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("port is not valid, expected number but was [" + split[1] + "]");
            }
        }
        return new ExternalTestCluster(ESIntegTestCase.createTempDir(), this.externalClusterClientSettings(), this.transportClientPlugins(), transportAddresses);
    }

    protected Settings externalClusterClientSettings() {
        return Settings.EMPTY;
    }

    protected TestCluster buildTestCluster(Scope scope, long seed) throws IOException {
        int minNumDataNodes;
        int maxNumDataNodes;
        String nodePrefix;
        String clusterAddresses = System.getProperty(TESTS_CLUSTER);
        if (Strings.hasLength((String)clusterAddresses)) {
            this.logger.info("Connecting to external test cluster at {}", new Object[]{clusterAddresses});
            if (scope == Scope.TEST) {
                throw new IllegalArgumentException("Cannot run TEST scope test with tests.cluster");
            }
            return this.buildExternalCluster(clusterAddresses);
        }
        switch (scope) {
            case TEST: {
                nodePrefix = TEST_CLUSTER_NODE_PREFIX;
                break;
            }
            case SUITE: {
                nodePrefix = SUITE_CLUSTER_NODE_PREFIX;
                break;
            }
            default: {
                throw new ElasticsearchException("Scope not supported: " + (Object)((Object)scope), new Object[0]);
            }
        }
        NodeConfigurationSource nodeConfigurationSource = new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal) {
                return Settings.builder().put("http.enabled", false).put(ESIntegTestCase.this.nodeSettings(nodeOrdinal)).build();
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return ESIntegTestCase.this.nodePlugins();
            }

            @Override
            public Settings transportClientSettings() {
                return ESIntegTestCase.this.transportClientSettings();
            }

            @Override
            public Collection<Class<? extends Plugin>> transportClientPlugins() {
                return ESIntegTestCase.this.transportClientPlugins();
            }
        };
        int numDataNodes = this.getNumDataNodes();
        if (numDataNodes >= 0) {
            minNumDataNodes = maxNumDataNodes = numDataNodes;
        } else {
            minNumDataNodes = this.getMinNumDataNodes();
            maxNumDataNodes = this.getMaxNumDataNodes();
        }
        SuppressLocalMode noLocal = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), SuppressLocalMode.class);
        SuppressNetworkMode noNetwork = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), SuppressNetworkMode.class);
        String nodeMode = InternalTestCluster.configuredNodeMode();
        if (noLocal != null && noNetwork != null) {
            throw new IllegalStateException("Can't suppress both network and local mode");
        }
        if (noLocal != null) {
            nodeMode = "network";
        } else if (noNetwork != null) {
            nodeMode = "local";
        }
        boolean enableMockModules = this.enableMockModules();
        return new InternalTestCluster(nodeMode, seed, ESIntegTestCase.createTempDir(), minNumDataNodes, maxNumDataNodes, InternalTestCluster.clusterName(scope.name(), seed) + "-cluster", nodeConfigurationSource, this.getNumClientNodes(), true, nodePrefix, enableMockModules);
    }

    protected boolean enableMockModules() {
        return RandomizedTest.systemPropertyAsBoolean((String)TESTS_ENABLE_MOCK_MODULES, (boolean)true);
    }

    private static double transportClientRatio() {
        String property = System.getProperty(TESTS_CLIENT_RATIO);
        if (property == null || property.isEmpty()) {
            return Double.NaN;
        }
        return Double.parseDouble(property);
    }

    protected double getPerTestTransportClientRatio() {
        ClusterScope annotation = ESIntegTestCase.getAnnotation(((Object)((Object)this)).getClass(), ClusterScope.class);
        double perTestRatio = -1.0;
        if (annotation != null) {
            perTestRatio = annotation.transportClientRatio();
        }
        if (perTestRatio == -1.0) {
            return Double.isNaN(TRANSPORT_CLIENT_RATIO) ? ESIntegTestCase.randomDouble() : TRANSPORT_CLIENT_RATIO;
        }
        assert (perTestRatio >= 0.0 && perTestRatio <= 1.0);
        return perTestRatio;
    }

    public static String randomNumericFieldDataFormat() {
        return ESIntegTestCase.randomFrom(Arrays.asList("array", "doc_values"));
    }

    public static DateTimeZone randomDateTimeZone() {
        DateTimeZone timeZone;
        try {
            timeZone = DateTimeZone.forTimeZone((TimeZone)RandomizedTest.randomTimeZone());
        }
        catch (IllegalArgumentException e) {
            timeZone = DateTimeZone.forOffsetHours((int)ESIntegTestCase.randomIntBetween(-12, 12));
        }
        return timeZone;
    }

    public Path randomRepoPath() {
        return currentCluster.randomRepoPath();
    }

    protected NumShards getNumShards(String index) {
        MetaData metaData = ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().get()).getState().metaData();
        ESIntegTestCase.assertThat((Object)metaData.hasIndex(index), (Matcher)Matchers.equalTo((Object)true));
        int numShards = Integer.valueOf(metaData.index(index).getSettings().get("index.number_of_shards"));
        int numReplicas = Integer.valueOf(metaData.index(index).getSettings().get("index.number_of_replicas"));
        return new NumShards(numShards, numReplicas);
    }

    public Set<String> assertAllShardsOnNodes(String index, String ... pattern) {
        HashSet<String> nodes = new HashSet<String>();
        ClusterState clusterState = ((ClusterStateResponse)ESIntegTestCase.client().admin().cluster().prepareState().execute().actionGet()).getState();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (shardRouting.currentNodeId() == null || !index.equals(shardRouting.getIndex())) continue;
                    String name = clusterState.nodes().get(shardRouting.currentNodeId()).name();
                    nodes.add(name);
                    ESIntegTestCase.assertThat((String)("Allocated on new node: " + name), (Object)Regex.simpleMatch((String[])pattern, (String)name), (Matcher)Matchers.is((Object)true));
                }
            }
        }
        return nodes;
    }

    public static Version getMinimumVersionInCluster() {
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)ESIntegTestCase.client().admin().cluster().prepareNodesInfo(new String[0]).get();
        Version minimumVersionInCluster = Version.CURRENT;
        for (NodeInfo nodeInfo : nodesInfoResponse) {
            if (!nodeInfo.getVersion().before(minimumVersionInCluster)) continue;
            minimumVersionInCluster = nodeInfo.getVersion();
        }
        return minimumVersionInCluster;
    }

    private static boolean runTestScopeLifecycle() {
        return INSTANCE == null;
    }

    @Before
    public final void before() throws Exception {
        if (ESIntegTestCase.runTestScopeLifecycle()) {
            this.printTestMessage("setup");
            this.beforeInternal();
        }
        this.printTestMessage("starting");
    }

    @After
    public final void after() throws Exception {
        this.printTestMessage("finished");
        super.ensureAllSearchContextsReleased();
        if (ESIntegTestCase.runTestScopeLifecycle()) {
            this.printTestMessage("cleaning up after");
            this.afterInternal(false);
            this.printTestMessage("cleaned up after");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (!ESIntegTestCase.runTestScopeLifecycle()) {
            try {
                INSTANCE.printTestMessage("cleaning up after");
                INSTANCE.afterInternal(true);
            }
            finally {
                INSTANCE = null;
            }
        } else {
            ESIntegTestCase.clearClusters();
        }
        SUITE_SEED = null;
        currentCluster = null;
    }

    private static void initializeSuiteScope() throws Exception {
        Class targetClass = ESIntegTestCase.getTestClass();
        assert (INSTANCE == null);
        if (ESIntegTestCase.isSuiteScopedTest(targetClass)) {
            INSTANCE = (ESIntegTestCase)((Object)targetClass.newInstance());
            boolean success = false;
            try {
                INSTANCE.printTestMessage("setup");
                INSTANCE.beforeInternal();
                INSTANCE.setupSuiteScopeCluster();
                success = true;
            }
            finally {
                if (!success) {
                    ESIntegTestCase.afterClass();
                }
            }
        } else {
            INSTANCE = null;
        }
    }

    protected String routingKeyForShard(String index, String type, int shard) {
        return ESIntegTestCase.internalCluster().routingKeyForShard(index, type, shard, ESIntegTestCase.getRandom());
    }

    protected Settings prepareBackwardsDataDir(Path backwardsIndex, Object ... settings) throws IOException {
        Path[] list;
        Path indexDir = ESIntegTestCase.createTempDir();
        Path dataDir = indexDir.resolve("data");
        try (InputStream stream = Files.newInputStream(backwardsIndex, new OpenOption[0]);){
            TestUtil.unzip((InputStream)stream, (Path)indexDir);
        }
        ESIntegTestCase.assertTrue((boolean)Files.exists(dataDir, new LinkOption[0]));
        Path[] pathArray = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataDir);){
            ArrayList<Path> dirs = new ArrayList<Path>();
            for (Path p : stream) {
                if (p.getFileName().toString().startsWith("extra")) continue;
                dirs.add(p);
            }
            list = dirs.toArray(new Path[0]);
        }
        catch (Throwable dirs) {
            pathArray = dirs;
            throw dirs;
        }
        if (list.length != 1) {
            StringBuilder builder = new StringBuilder("Backwards index must contain exactly one cluster\n");
            for (Path line : list) {
                builder.append(line.toString()).append('\n');
            }
            throw new IllegalStateException(builder.toString());
        }
        Path src = list[0];
        Path dest = dataDir.resolve(ESIntegTestCase.internalCluster().getClusterName());
        ESIntegTestCase.assertTrue((boolean)Files.exists(src, new LinkOption[0]));
        Files.move(src, dest, new CopyOption[0]);
        ESIntegTestCase.assertFalse((boolean)Files.exists(src, new LinkOption[0]));
        ESIntegTestCase.assertTrue((boolean)Files.exists(dest, new LinkOption[0]));
        Settings.Builder builder = Settings.builder().put(settings).put(new Object[]{"path.data", dataDir.toAbsolutePath()});
        Path configDir = indexDir.resolve("config");
        if (Files.exists(configDir, new LinkOption[0])) {
            builder.put(new Object[]{"path.conf", configDir.toAbsolutePath()});
        }
        return builder.build();
    }

    protected HttpRequestBuilder httpClient() {
        NodesInfoResponse nodeInfos = (NodesInfoResponse)ESIntegTestCase.client().admin().cluster().prepareNodesInfo(new String[0]).get();
        NodeInfo[] nodes = (NodeInfo[])nodeInfos.getNodes();
        ESIntegTestCase.assertTrue((nodes.length > 0 ? 1 : 0) != 0);
        TransportAddress publishAddress = ESIntegTestCase.randomFrom(nodes).getHttp().address().publishAddress();
        ESIntegTestCase.assertEquals((long)1L, (long)publishAddress.uniqueAddressTypeId());
        InetSocketAddress address = ((InetSocketTransportAddress)publishAddress).address();
        return new HttpRequestBuilder(HttpClients.createDefault()).host(NetworkAddress.formatAddress((InetAddress)address.getAddress())).port(address.getPort());
    }

    protected void setupSuiteScopeCluster() throws Exception {
    }

    private static boolean isSuiteScopedTest(Class<?> clazz) {
        return clazz.getAnnotation(SuiteScopeTestCase.class) != null;
    }

    static {
        TRANSPORT_CLIENT_RATIO = ESIntegTestCase.transportClientRatio();
        clusters = new IdentityHashMap();
        INSTANCE = null;
        SUITE_SEED = null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CompatibilityVersion {
        public int version();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface SuppressNetworkMode {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface SuppressLocalMode {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface SuiteScopeTestCase {
    }

    protected static class NumShards {
        public final int numPrimaries;
        public final int numReplicas;
        public final int totalNumShards;
        public final int dataCopies;

        private NumShards(int numPrimaries, int numReplicas) {
            this.numPrimaries = numPrimaries;
            this.numReplicas = numReplicas;
            this.dataCopies = numReplicas + 1;
            this.totalNumShards = numPrimaries * this.dataCopies;
        }
    }

    private class PayloadLatchedActionListener<Response, T>
    extends LatchedActionListener<Response> {
        private final CopyOnWriteArrayList<Tuple<T, Throwable>> errors;
        private final T builder;

        public PayloadLatchedActionListener(T builder, CountDownLatch latch, CopyOnWriteArrayList<Tuple<T, Throwable>> errors) {
            super(latch);
            this.errors = errors;
            this.builder = builder;
        }

        @Override
        protected void addError(Throwable t) {
            this.errors.add(new Tuple(this.builder, (Object)t));
        }
    }

    private class LatchedActionListener<Response>
    implements ActionListener<Response> {
        private final CountDownLatch latch;

        public LatchedActionListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public final void onResponse(Response response) {
            this.latch.countDown();
        }

        public final void onFailure(Throwable t) {
            try {
                ESIntegTestCase.this.logger.info("Action Failed", t, new Object[0]);
                this.addError(t);
            }
            finally {
                this.latch.countDown();
            }
        }

        protected void addError(Throwable t) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ClusterScope {
        public Scope scope() default Scope.SUITE;

        public int numDataNodes() default -1;

        public int minNumDataNodes() default -1;

        public int maxNumDataNodes() default -1;

        public int numClientNodes() default -1;

        public double transportClientRatio() default -1.0;

        public boolean randomDynamicTemplates() default true;
    }

    public static enum Scope {
        SUITE,
        TEST;

    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @TestGroup(enabled=false, sysProperty="tests.thirdparty")
    public static @interface ThirdParty {
    }
}

