/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.TestSearchContext;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class ESSingleNodeTestCase
extends ESTestCase {
    private static Node NODE = null;

    private static void reset() {
        assert (NODE != null);
        ESSingleNodeTestCase.stopNode();
        ESSingleNodeTestCase.startNode();
    }

    private static void startNode() {
        assert (NODE == null);
        NODE = ESSingleNodeTestCase.newNode();
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)ESSingleNodeTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().get();
        ESSingleNodeTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
    }

    private static void stopNode() {
        Node node = NODE;
        NODE = null;
        Releasables.close((Releasable[])new Releasable[]{node});
    }

    static void cleanup(boolean resetNode) {
        ElasticsearchAssertions.assertAcked((DeleteIndexResponse)ESSingleNodeTestCase.client().admin().indices().prepareDelete(new String[]{"*"}).get());
        if (resetNode) {
            ESSingleNodeTestCase.reset();
        }
        MetaData metaData = ((ClusterStateResponse)ESSingleNodeTestCase.client().admin().cluster().prepareState().get()).getState().getMetaData();
        ESSingleNodeTestCase.assertThat((String)("test leaves persistent cluster metadata behind: " + metaData.persistentSettings().getAsMap()), (Object)metaData.persistentSettings().getAsMap().size(), (Matcher)Matchers.equalTo((Object)0));
        ESSingleNodeTestCase.assertThat((String)("test leaves transient cluster metadata behind: " + metaData.transientSettings().getAsMap()), (Object)metaData.transientSettings().getAsMap().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @After
    public void tearDown() throws Exception {
        this.logger.info("[{}#{}]: cleaning up after test", new Object[]{ESSingleNodeTestCase.getTestClass().getSimpleName(), this.getTestName()});
        super.tearDown();
        ESSingleNodeTestCase.cleanup(this.resetNodeAfterTest());
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        ESSingleNodeTestCase.stopNode();
        ESSingleNodeTestCase.startNode();
    }

    @AfterClass
    public static void tearDownClass() {
        ESSingleNodeTestCase.stopNode();
    }

    protected boolean resetNodeAfterTest() {
        return false;
    }

    private static Node newNode() {
        Node build = NodeBuilder.nodeBuilder().local(true).data(true).settings(Settings.builder().put("cluster.name", InternalTestCluster.clusterName("single-node-cluster", ESSingleNodeTestCase.randomLong())).put(new Object[]{"path.home", ESSingleNodeTestCase.createTempDir()}).put(new Object[]{"path.shared_data", ESSingleNodeTestCase.createTempDir().getParent()}).put("node.name", ESSingleNodeTestCase.nodeName()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("script.inline", "on").put("script.indexed", "on").put("processors", 1).put("http.enabled", false).put("config.ignore_system_properties", true)).build();
        build.start();
        ESSingleNodeTestCase.assertThat((Object)DiscoveryNode.localNode((Settings)build.settings()), (Matcher)Matchers.is((Object)true));
        return build;
    }

    public static Client client() {
        return NODE.client();
    }

    public static String nodeName() {
        return "node_s_0";
    }

    protected static Node node() {
        return NODE;
    }

    protected static <T> T getInstanceFromNode(Class<T> clazz) {
        return (T)NODE.injector().getInstance(clazz);
    }

    protected static IndexService createIndex(String index) {
        return ESSingleNodeTestCase.createIndex(index, Settings.EMPTY);
    }

    protected static IndexService createIndex(String index, Settings settings) {
        return ESSingleNodeTestCase.createIndex(index, settings, null, null);
    }

    protected static IndexService createIndex(String index, Settings settings, String type, XContentBuilder mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = ESSingleNodeTestCase.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (type != null && mappings != null) {
            createIndexRequestBuilder.addMapping(type, mappings);
        }
        return ESSingleNodeTestCase.createIndex(index, createIndexRequestBuilder);
    }

    protected static IndexService createIndex(String index, Settings settings, String type, Object ... mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = ESSingleNodeTestCase.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (type != null && mappings != null) {
            createIndexRequestBuilder.addMapping(type, mappings);
        }
        return ESSingleNodeTestCase.createIndex(index, createIndexRequestBuilder);
    }

    protected static IndexService createIndex(String index, CreateIndexRequestBuilder createIndexRequestBuilder) {
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)createIndexRequestBuilder.get());
        ClusterHealthResponse health = (ClusterHealthResponse)ESSingleNodeTestCase.client().admin().cluster().health(Requests.clusterHealthRequest((String[])new String[]{index}).waitForYellowStatus().waitForEvents(Priority.LANGUID).waitForRelocatingShards(0)).actionGet();
        ESSingleNodeTestCase.assertThat((Object)health.getStatus(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)ClusterHealthStatus.YELLOW));
        ESSingleNodeTestCase.assertThat((String)"Cluster must be a single node cluster", (Object)health.getNumberOfDataNodes(), (Matcher)Matchers.equalTo((Object)1));
        IndicesService instanceFromNode = ESSingleNodeTestCase.getInstanceFromNode(IndicesService.class);
        return instanceFromNode.indexServiceSafe(index);
    }

    protected static Engine engine(IndexService service) {
        return service.shard(0).engine();
    }

    protected static SearchContext createSearchContext(IndexService indexService) {
        BigArrays bigArrays = (BigArrays)indexService.injector().getInstance(BigArrays.class);
        ThreadPool threadPool = (ThreadPool)indexService.injector().getInstance(ThreadPool.class);
        PageCacheRecycler pageCacheRecycler = (PageCacheRecycler)indexService.injector().getInstance(PageCacheRecycler.class);
        return new TestSearchContext(threadPool, pageCacheRecycler, bigArrays, indexService);
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)ESSingleNodeTestCase.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForRelocatingShards(0)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureGreen timed out, cluster state:\n{}\n{}", new Object[]{((ClusterStateResponse)ESSingleNodeTestCase.client().admin().cluster().prepareState().get()).getState().prettyPrint(), ((PendingClusterTasksResponse)ESSingleNodeTestCase.client().admin().cluster().preparePendingClusterTasks().get()).prettyPrint()});
            ESSingleNodeTestCase.assertThat((String)"timed out waiting for green state", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        ESSingleNodeTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)ClusterHealthStatus.GREEN));
        this.logger.debug("indices {} are green", new Object[]{indices.length == 0 ? "[_all]" : indices});
        return actionGet.getStatus();
    }
}

