/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestUtil;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapForTesting;
import org.elasticsearch.cache.recycler.MockPageCacheRecycler;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.routing.DjbHashFunction;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.io.PathUtilsForTesting;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.test.junit.listeners.LoggingListener;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Listeners(value={ReproduceInfoPrinter.class, LoggingListener.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakLingering(linger=5000)
@TimeoutSuite(millis=1200000)
@LuceneTestCase.SuppressSysoutChecks(bugUrl="we log a lot on purpose")
@LuceneTestCase.SuppressCodecs(value={"SimpleText", "Memory", "CheapBastard", "Direct", "Compressing", "FST50", "FSTOrd50", "TestBloomFilteredLucenePostings", "MockRandom", "BlockTreeOrds", "LuceneFixedGap", "LuceneVarGapFixedInterval", "LuceneVarGapDocFreqInterval", "Lucene50"})
@LuceneTestCase.SuppressReproduceLine
@ReproduceInfoPrinter.Properties(value={"es.logger.level", "tests.assertion.disabled", "tests.security.manager", "tests.nightly", "tests.jvms", "tests.client.ratio", "tests.heap.size"})
public abstract class ESTestCase
extends LuceneTestCase {
    protected final ESLogger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    @Rule
    public RuleChain failureAndSuccessEvents = RuleChain.outerRule((TestRule)new TestRuleAdapter(){

        protected void afterIfSuccessful() throws Throwable {
            ESTestCase.this.afterIfSuccessful();
        }

        protected void afterAlways(List<Throwable> errors) throws Throwable {
            if (errors != null && !errors.isEmpty()) {
                ESTestCase.this.afterIfFailed(errors);
            }
            super.afterAlways(errors);
        }
    });
    public static boolean checkIndexFailed;
    private static final long AWAIT_BUSY_THRESHOLD = 1000L;

    protected void afterIfFailed(List<Throwable> errors) {
    }

    protected void afterIfSuccessful() throws Exception {
    }

    @BeforeClass
    public static void setFileSystem() throws Exception {
        PathUtilsForTesting.setup();
    }

    @AfterClass
    public static void restoreFileSystem() throws Exception {
        PathUtilsForTesting.teardown();
    }

    @BeforeClass
    public static void setContentType() throws Exception {
        Requests.CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
        Requests.INDEX_CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
    }

    @AfterClass
    public static void restoreContentType() {
        Requests.CONTENT_TYPE = XContentType.SMILE;
        Requests.INDEX_CONTENT_TYPE = XContentType.JSON;
    }

    @BeforeClass
    public static void setProcessors() {
        int numCpu = TestUtil.nextInt((Random)ESTestCase.random(), (int)1, (int)4);
        System.setProperty("es.processors.override", Integer.toString(numCpu));
        ESTestCase.assertEquals((long)numCpu, (long)EsExecutors.boundedNumberOfProcessors((Settings)Settings.EMPTY));
    }

    @AfterClass
    public static void restoreProcessors() {
        System.clearProperty("es.processors.override");
    }

    @After
    public final void ensureCleanedUp() throws Exception {
        MockPageCacheRecycler.ensureAllPagesAreReleased();
        MockBigArrays.ensureAllArraysAreReleased();
        Object[] entries = UninvertingReader.getUninvertedStats();
        ESTestCase.assertEquals((String)("fieldcache must never be used, got=" + Arrays.toString(entries)), (long)0L, (long)entries.length);
    }

    @After
    public final void ensureAllSearchContextsReleased() throws Exception {
        ESTestCase.assertBusy(new Runnable(){

            @Override
            public void run() {
                MockSearchService.assertNoInFLightContext();
            }
        });
    }

    @Before
    public final void resetCheckIndexStatus() throws Exception {
        checkIndexFailed = false;
    }

    @After
    public final void ensureCheckIndexPassed() throws Exception {
        ESTestCase.assertFalse((String)"at least one shard failed CheckIndex", (boolean)checkIndexFailed);
    }

    public static Random getRandom() {
        return ESTestCase.random();
    }

    public static int scaledRandomIntBetween(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween((int)min, (int)max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomInts.randomIntBetween((Random)ESTestCase.random(), (int)min, (int)max);
    }

    public static int iterations(int min, int max) {
        return ESTestCase.scaledRandomIntBetween(min, max);
    }

    public static int between(int min, int max) {
        return ESTestCase.randomIntBetween(min, max);
    }

    public static boolean frequently() {
        return !ESTestCase.rarely();
    }

    public static boolean randomBoolean() {
        return ESTestCase.random().nextBoolean();
    }

    public static byte randomByte() {
        return (byte)ESTestCase.random().nextInt();
    }

    public static short randomShort() {
        return (short)ESTestCase.random().nextInt();
    }

    public static int randomInt() {
        return ESTestCase.random().nextInt();
    }

    public static float randomFloat() {
        return ESTestCase.random().nextFloat();
    }

    public static double randomDouble() {
        return ESTestCase.random().nextDouble();
    }

    public static long randomLong() {
        return ESTestCase.random().nextLong();
    }

    public static int randomInt(int max) {
        return RandomizedTest.randomInt((int)max);
    }

    public static <T> T randomFrom(T ... array) {
        return (T)RandomPicks.randomFrom((Random)ESTestCase.random(), (Object[])array);
    }

    public static <T> T randomFrom(List<T> list) {
        return (T)RandomPicks.randomFrom((Random)ESTestCase.random(), list);
    }

    public static String randomAsciiOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomAsciiOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomAsciiOfLength(int codeUnits) {
        return RandomizedTest.randomAsciiOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomUnicodeOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLength((int)codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLength((int)codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLength((int)codePoints);
    }

    public static String[] generateRandomStringArray(int maxArraySize, int maxStringSize, boolean allowNull) {
        if (allowNull && ESTestCase.random().nextBoolean()) {
            return null;
        }
        String[] array = new String[ESTestCase.random().nextInt(maxArraySize)];
        for (int i = 0; i < array.length; ++i) {
            array[i] = RandomStrings.randomAsciiOfLength((Random)ESTestCase.random(), (int)maxStringSize);
        }
        return array;
    }

    public static String randomTimeValue() {
        String[] values = new String[]{"d", "H", "ms", "s", "S", "w"};
        return ESTestCase.randomIntBetween(0, 1000) + ESTestCase.randomFrom(values);
    }

    public static void assertBusy(Runnable codeBlock) throws Exception {
        ESTestCase.assertBusy(Executors.callable(codeBlock), 10L, TimeUnit.SECONDS);
    }

    public static void assertBusy(Runnable codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        ESTestCase.assertBusy(Executors.callable(codeBlock), maxWaitTime, unit);
    }

    public static <V> V assertBusy(Callable<V> codeBlock) throws Exception {
        return ESTestCase.assertBusy(codeBlock, 10L, TimeUnit.SECONDS);
    }

    public static <V> V assertBusy(Callable<V> codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long iterations = Math.max(Math.round(Math.log10(maxTimeInMillis) / Math.log10(2.0)), 1L);
        long timeInMillis = 1L;
        long sum = 0L;
        ArrayList<AssertionError> failures = new ArrayList<AssertionError>();
        int i = 0;
        while ((long)i < iterations) {
            try {
                return codeBlock.call();
            }
            catch (AssertionError e) {
                failures.add(e);
                sum += timeInMillis;
                Thread.sleep(timeInMillis);
                timeInMillis *= 2L;
                ++i;
            }
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        try {
            return codeBlock.call();
        }
        catch (AssertionError e) {
            for (AssertionError failure : failures) {
                ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)failure));
            }
            throw e;
        }
    }

    public static boolean awaitBusy(Predicate<?> breakPredicate) throws InterruptedException {
        return ESTestCase.awaitBusy(breakPredicate, 10L, TimeUnit.SECONDS);
    }

    public static boolean awaitBusy(Predicate<?> breakPredicate, long maxWaitTime, TimeUnit unit) throws InterruptedException {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakPredicate.apply(null)) {
                return true;
            }
            Thread.sleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        return breakPredicate.apply(null);
    }

    public static boolean terminate(ExecutorService ... services) throws InterruptedException {
        boolean terminated = true;
        for (ExecutorService service : services) {
            if (service == null) continue;
            terminated &= ThreadPool.terminate((ExecutorService)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        return terminated;
    }

    public static boolean terminate(ThreadPool service) throws InterruptedException {
        return ThreadPool.terminate((ThreadPool)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Path getDataPath(String relativePath) {
        try {
            return PathUtils.get((URI)((Object)((Object)this)).getClass().getResource(relativePath).toURI());
        }
        catch (Exception e) {
            throw new RuntimeException("resource not found: " + relativePath, e);
        }
    }

    public Path getBwcIndicesPath() {
        return this.getDataPath("/indices/bwc");
    }

    public String[] tmpPaths() {
        int numPaths = TestUtil.nextInt((Random)ESTestCase.random(), (int)1, (int)3);
        String[] absPaths = new String[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            absPaths[i] = ESTestCase.createTempDir().toAbsolutePath().toString();
        }
        return absPaths;
    }

    public NodeEnvironment newNodeEnvironment() throws IOException {
        return this.newNodeEnvironment(Settings.EMPTY);
    }

    public NodeEnvironment newNodeEnvironment(Settings settings) throws IOException {
        Settings build = Settings.builder().put(settings).put(new Object[]{"path.home", ESTestCase.createTempDir().toAbsolutePath()}).putArray("path.data", this.tmpPaths()).build();
        return new NodeEnvironment(build, new Environment(build));
    }

    public static Settings.Builder settings(Version version) {
        Settings.Builder builder = Settings.builder().put("index.version.created", version);
        if (version.before(Version.V_2_0_0_beta1)) {
            builder.put("index.legacy.routing.hash.type", DjbHashFunction.class);
        }
        return builder;
    }

    private static String threadName(Thread t) {
        return "Thread[id=" + t.getId() + ", name=" + t.getName() + ", state=" + (Object)((Object)t.getState()) + ", group=" + ESTestCase.groupName(t.getThreadGroup()) + "]";
    }

    private static String groupName(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return "{null group}";
        }
        return threadGroup.getName();
    }

    public static <T> List<T> randomSubsetOf(int size, T ... values) {
        if (size > values.length) {
            throw new IllegalArgumentException("Can't pick " + size + " random objects from a list of " + values.length + " objects");
        }
        ArrayList list = CollectionUtils.arrayAsArrayList((Object[])values);
        Collections.shuffle(list);
        return list.subList(0, size);
    }

    public static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public void assertPathHasBeenCleared(String path) throws Exception {
        this.assertPathHasBeenCleared(PathUtils.get((String)path, (String[])new String[0]));
    }

    public void assertPathHasBeenCleared(Path path) throws Exception {
        this.logger.info("--> checking that [{}] has been cleared", new Object[]{path});
        int count = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path file : stream) {
                    if (file.getFileName().toString().startsWith("extra")) continue;
                    this.logger.info("--> found file: [{}]", new Object[]{file.toAbsolutePath().toString()});
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        this.assertPathHasBeenCleared(file);
                        continue;
                    }
                    if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                    ++count;
                    sb.append(file.toAbsolutePath().toString());
                    sb.append("\n");
                }
            }
        }
        sb.append("]");
        ESTestCase.assertThat((String)(count + " files exist that should have been cleaned:\n" + sb.toString()), (Object)count, (Matcher)Matchers.equalTo((Object)0));
    }

    public static TestRuleMarkFailure getSuiteFailureMarker() {
        return suiteFailureMarker;
    }

    public static void assertArrayEquals(StackTraceElement[] expected, StackTraceElement[] actual) {
        ESTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ESTestCase.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        ESTestCase.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        ESTestCase.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        ESTestCase.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        ESTestCase.assertEquals((long)expected.getLineNumber(), (long)actual.getLineNumber());
        ESTestCase.assertEquals((Object)expected.isNativeMethod(), (Object)actual.isNativeMethod());
    }

    static {
        BootstrapForTesting.ensureInitialized();
    }
}

