/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.TestCluster;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class ExternalTestCluster
extends TestCluster {
    private static final ESLogger logger = Loggers.getLogger(ExternalTestCluster.class);
    private static final AtomicInteger counter = new AtomicInteger();
    public static final String EXTERNAL_CLUSTER_PREFIX = "external_";
    private final Client client;
    private final InetSocketAddress[] httpAddresses;
    private final String clusterName;
    private final int numDataNodes;
    private final int numMasterAndDataNodes;

    public ExternalTestCluster(Path tempDir, Settings additionalSettings, Collection<Class<? extends Plugin>> pluginClasses, TransportAddress ... transportAddresses) {
        super(0L);
        Settings clientSettings = Settings.settingsBuilder().put(additionalSettings).put("name", "transport_client_external_" + counter.getAndIncrement()).put("config.ignore_system_properties", true).put("client.transport.ignore_cluster_name", true).put(new Object[]{"path.home", tempDir}).put("node.mode", "network").build();
        TransportClient.Builder transportClientBuilder = TransportClient.builder().settings(clientSettings);
        for (Class<? extends Plugin> pluginClass : pluginClasses) {
            transportClientBuilder.addPlugin(pluginClass);
        }
        this.client = transportClientBuilder.build().addTransportAddresses(transportAddresses);
        NodesInfoResponse nodeInfos = (NodesInfoResponse)this.client.admin().cluster().prepareNodesInfo(new String[0]).clear().setSettings(true).setHttp(true).get();
        this.httpAddresses = new InetSocketAddress[((NodeInfo[])nodeInfos.getNodes()).length];
        this.clusterName = nodeInfos.getClusterName().value();
        int dataNodes = 0;
        int masterAndDataNodes = 0;
        for (int i = 0; i < ((NodeInfo[])nodeInfos.getNodes()).length; ++i) {
            NodeInfo nodeInfo = ((NodeInfo[])nodeInfos.getNodes())[i];
            this.httpAddresses[i] = ((InetSocketTransportAddress)nodeInfo.getHttp().address().publishAddress()).address();
            if (DiscoveryNode.dataNode((Settings)nodeInfo.getSettings())) {
                ++dataNodes;
                ++masterAndDataNodes;
                continue;
            }
            if (!DiscoveryNode.masterNode((Settings)nodeInfo.getSettings())) continue;
            ++masterAndDataNodes;
        }
        this.numDataNodes = dataNodes;
        this.numMasterAndDataNodes = masterAndDataNodes;
        logger.info("Setup ExternalTestCluster [{}] made of [{}] nodes", new Object[]{nodeInfos.getClusterName().value(), this.size()});
    }

    @Override
    public void afterTest() {
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public int size() {
        return this.httpAddresses.length;
    }

    @Override
    public int numDataNodes() {
        return this.numDataNodes;
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.numMasterAndDataNodes;
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        return this.httpAddresses;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            NodesStatsResponse nodeStats = (NodesStatsResponse)this.client().admin().cluster().prepareNodesStats(new String[0]).clear().setBreaker(true).setIndices(true).execute().actionGet();
            for (NodeStats stats : (NodeStats[])nodeStats.getNodes()) {
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + stats.getNode()), (Object)stats.getBreaker().getStats("fielddata").getEstimated(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public Iterator<Client> iterator() {
        return Collections.singleton(this.client).iterator();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }
}

