/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.MockEngineFactoryPlugin;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeMocksPlugin;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.store.MockFSIndexStore;
import org.elasticsearch.test.transport.AssertingLocalTransport;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class InternalTestCluster
extends TestCluster {
    private final ESLogger logger = Loggers.getLogger(this.getClass());
    static NodeConfigurationSource DEFAULT_SETTINGS_SOURCE = NodeConfigurationSource.EMPTY;
    public static final String SETTING_CLUSTER_NODE_SEED = "test.cluster.node.seed";
    public static final int PORTS_PER_JVM = 100;
    public static final int PORTS_PER_CLUSTER = 20;
    private static final int GLOBAL_TRANSPORT_BASE_PORT = 9300;
    private static final int GLOBAL_HTTP_BASE_PORT = 19200;
    private static final int JVM_ORDINAL = Integer.parseInt(System.getProperty("junit4.childvm.id", "0"));
    public static final int JVM_BASE_PORT_OFFEST = 100 * (JVM_ORDINAL + 1);
    private static final AtomicInteger clusterOrdinal = new AtomicInteger();
    private final int CLUSTER_BASE_PORT_OFFSET = JVM_BASE_PORT_OFFEST + clusterOrdinal.getAndIncrement() * 20 % 100;
    public final int TRANSPORT_BASE_PORT = 9300 + this.CLUSTER_BASE_PORT_OFFSET;
    public final int HTTP_BASE_PORT = 19200 + this.CLUSTER_BASE_PORT_OFFSET;
    static final int DEFAULT_MIN_NUM_DATA_NODES = 1;
    static final int DEFAULT_MAX_NUM_DATA_NODES = LuceneTestCase.TEST_NIGHTLY ? 6 : 3;
    static final int DEFAULT_NUM_CLIENT_NODES = -1;
    static final int DEFAULT_MIN_NUM_CLIENT_NODES = 0;
    static final int DEFAULT_MAX_NUM_CLIENT_NODES = 1;
    static final boolean DEFAULT_ENABLE_HTTP_PIPELINING = true;
    private final NavigableMap<String, NodeAndClient> nodes = new TreeMap<String, NodeAndClient>();
    private final Set<Path> dataDirToClean = new HashSet<Path>();
    private final String clusterName;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Settings defaultSettings;
    private AtomicInteger nextNodeId = new AtomicInteger(0);
    private final long[] sharedNodesSeeds;
    private final int numSharedDataNodes;
    private final int numSharedClientNodes;
    private final NodeConfigurationSource nodeConfigurationSource;
    private final ExecutorService executor;
    private final boolean enableMockModules;
    private final String nodePrefix;
    private final Path baseDir;
    private ServiceDisruptionScheme activeDisruptionScheme;
    private String nodeMode;
    public static final String TRANSPORT_CLIENT_PREFIX = "transport_client_";
    public static final RestartCallback EMPTY_CALLBACK = new RestartCallback(){

        @Override
        public Settings onNodeStopped(String node) {
            return null;
        }
    };

    public InternalTestCluster(String nodeMode, long clusterSeed, Path baseDir, int minNumDataNodes, int maxNumDataNodes, String clusterName, NodeConfigurationSource nodeConfigurationSource, int numClientNodes, boolean enableHttpPipelining, String nodePrefix, boolean enableMockModules) {
        super(clusterSeed);
        int numOfDataPaths;
        if (!"network".equals(nodeMode) && !"local".equals(nodeMode)) {
            throw new IllegalArgumentException("Unknown nodeMode: " + nodeMode);
        }
        this.nodeMode = nodeMode;
        this.baseDir = baseDir;
        this.clusterName = clusterName;
        if (minNumDataNodes < 0 || maxNumDataNodes < 0) {
            throw new IllegalArgumentException("minimum and maximum number of data nodes must be >= 0");
        }
        if (maxNumDataNodes < minNumDataNodes) {
            throw new IllegalArgumentException("maximum number of data nodes must be >= minimum number of  data nodes");
        }
        Random random = new Random(clusterSeed);
        this.numSharedDataNodes = RandomInts.randomIntBetween((Random)random, (int)minNumDataNodes, (int)maxNumDataNodes);
        assert (this.numSharedDataNodes >= 0);
        this.numSharedClientNodes = this.numSharedDataNodes == 0 ? 0 : (numClientNodes < 0 ? RandomInts.randomIntBetween((Random)random, (int)0, (int)1) : numClientNodes);
        assert (this.numSharedClientNodes >= 0);
        this.nodePrefix = nodePrefix;
        assert (nodePrefix != null);
        this.enableMockModules = enableMockModules;
        this.sharedNodesSeeds = new long[this.numSharedDataNodes + this.numSharedClientNodes];
        for (int i = 0; i < this.sharedNodesSeeds.length; ++i) {
            this.sharedNodesSeeds[i] = random.nextLong();
        }
        this.logger.info("Setup InternalTestCluster [{}] with seed [{}] using [{}] data nodes and [{}] client nodes", new Object[]{clusterName, SeedUtils.formatSeed((long)clusterSeed), this.numSharedDataNodes, this.numSharedClientNodes});
        this.nodeConfigurationSource = nodeConfigurationSource;
        Settings.Builder builder = Settings.settingsBuilder();
        if (random.nextInt(5) == 0 && (numOfDataPaths = random.nextInt(5)) > 0) {
            StringBuilder dataPath = new StringBuilder();
            for (int i = 0; i < numOfDataPaths; ++i) {
                dataPath.append(baseDir.resolve("d" + i).toAbsolutePath()).append(',');
            }
            builder.put("path.data", dataPath.toString());
        }
        builder.put(new Object[]{"path.shared_data", baseDir.resolve("custom")});
        builder.put(new Object[]{"path.home", baseDir});
        builder.put(new Object[]{"path.repo", baseDir.resolve("repos")});
        builder.put("transport.tcp.port", this.TRANSPORT_BASE_PORT + "-" + (this.TRANSPORT_BASE_PORT + 20));
        builder.put("http.port", this.HTTP_BASE_PORT + "-" + (this.HTTP_BASE_PORT + 20));
        builder.put("config.ignore_system_properties", true);
        builder.put("node.mode", nodeMode);
        builder.put("http.pipelining", enableHttpPipelining);
        if (Strings.hasLength((String)System.getProperty("es.logger.level"))) {
            builder.put("logger.level", System.getProperty("es.logger.level"));
        }
        if (Strings.hasLength((String)System.getProperty("es.logger.prefix"))) {
            builder.put("logger.prefix", System.getProperty("es.logger.prefix"));
        }
        builder.put("cluster.routing.allocation.disk.watermark.low", "1b");
        builder.put("cluster.routing.allocation.disk.watermark.high", "1b");
        if (LuceneTestCase.TEST_NIGHTLY) {
            builder.put("indices.recovery.concurrent_streams", RandomInts.randomIntBetween((Random)random, (int)10, (int)15));
            builder.put("indices.recovery.concurrent_small_file_streams", RandomInts.randomIntBetween((Random)random, (int)10, (int)15));
            builder.put("cluster.routing.allocation.node_concurrent_recoveries", RandomInts.randomIntBetween((Random)random, (int)5, (int)10));
        } else if (random.nextInt(100) <= 90) {
            builder.put("indices.recovery.concurrent_streams", RandomInts.randomIntBetween((Random)random, (int)3, (int)6));
            builder.put("indices.recovery.concurrent_small_file_streams", RandomInts.randomIntBetween((Random)random, (int)3, (int)6));
            builder.put("cluster.routing.allocation.node_concurrent_recoveries", RandomInts.randomIntBetween((Random)random, (int)2, (int)5));
        }
        builder.put(new Object[]{"indices.recovery.retry_delay_state_sync", TimeValue.timeValueMillis((long)RandomInts.randomIntBetween((Random)random, (int)20, (int)50))});
        this.defaultSettings = builder.build();
        this.executor = EsExecutors.newCached((String)"test runner", (long)0L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)EsExecutors.daemonThreadFactory((String)("test_" + clusterName)));
    }

    public static String configuredNodeMode() {
        Settings.Builder builder = Settings.builder();
        if (Strings.isEmpty((CharSequence)System.getProperty("es.node.mode")) && Strings.isEmpty((CharSequence)System.getProperty("es.node.local"))) {
            return "local";
        }
        if (Strings.hasLength((String)System.getProperty("es.node.mode"))) {
            builder.put("node.mode", System.getProperty("es.node.mode"));
        }
        if (Strings.hasLength((String)System.getProperty("es.node.local"))) {
            builder.put("node.local", System.getProperty("es.node.local"));
        }
        if (DiscoveryNode.localNode((Settings)builder.build())) {
            return "local";
        }
        return "network";
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public String[] getNodeNames() {
        return this.nodes.keySet().toArray(Strings.EMPTY_ARRAY);
    }

    private boolean isLocalTransportConfigured() {
        return "local".equals(this.nodeMode);
    }

    private Settings getSettings(int nodeOrdinal, long nodeSeed, Settings others) {
        Settings.Builder builder = Settings.settingsBuilder().put(this.defaultSettings).put(this.getRandomNodeSettings(nodeSeed));
        Settings settings = this.nodeConfigurationSource.nodeSettings(nodeOrdinal);
        if (settings != null) {
            if (settings.get("cluster.name") != null) {
                throw new IllegalStateException("Tests must not set a 'cluster.name' as a node setting set 'cluster.name': [" + settings.get("cluster.name") + "]");
            }
            builder.put(settings);
        }
        if (others != null) {
            builder.put(others);
        }
        builder.put("cluster.name", this.clusterName);
        return builder.build();
    }

    private Collection<Class<? extends Plugin>> getPlugins(long seed) {
        HashSet<Class<? extends Plugin>> plugins = new HashSet<Class<? extends Plugin>>(this.nodeConfigurationSource.nodePlugins());
        Random random = new Random(seed);
        if (this.enableMockModules && LuceneTestCase.usually((Random)random)) {
            plugins.add(MockTransportService.TestPlugin.class);
            plugins.add(MockFSIndexStore.TestPlugin.class);
            plugins.add(NodeMocksPlugin.class);
            plugins.add(MockEngineFactoryPlugin.class);
            plugins.add(MockSearchService.TestPlugin.class);
            if (this.isLocalTransportConfigured()) {
                plugins.add(AssertingLocalTransport.TestPlugin.class);
            }
        }
        return plugins;
    }

    private Settings getRandomNodeSettings(long seed) {
        Random random = new Random(seed);
        Settings.Builder builder = Settings.settingsBuilder().put(SETTING_CLUSTER_NODE_SEED, seed);
        if (!this.isLocalTransportConfigured()) {
            builder.put("transport.tcp.compress", LuceneTestCase.rarely((Random)random));
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"cache.recycler.page.type", RandomPicks.randomFrom((Random)random, (Object[])PageCacheRecycler.Type.values())});
        }
        if (random.nextInt(10) == 0) {
            builder.put(new Object[]{"search.keep_alive_interval", TimeValue.timeValueMillis((long)(10 + random.nextInt(2000)))});
        } else if (random.nextInt(10) != 0) {
            builder.put(new Object[]{"search.keep_alive_interval", TimeValue.timeValueSeconds((long)(10 + random.nextInt(300)))});
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"search.default_keep_alive", TimeValue.timeValueSeconds((long)(100 + random.nextInt(300)))});
        }
        if (random.nextInt(10) == 0) {
            builder.put("processors", 1 + EsExecutors.boundedNumberOfProcessors((Settings)Settings.EMPTY));
        }
        if (random.nextBoolean() && random.nextBoolean()) {
            builder.put("indices.fielddata.cache.size", (long)(1 + random.nextInt(1000)), ByteSizeUnit.MB);
        }
        if (random.nextBoolean()) {
            builder.put("transport.netty.worker_count", random.nextInt(3) + 1);
            builder.put("transport.connections_per_node.recovery", random.nextInt(2) + 1);
            builder.put("transport.connections_per_node.bulk", random.nextInt(3) + 1);
            builder.put("transport.connections_per_node.reg", random.nextInt(6) + 1);
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"indices.mapping.dynamic_timeout", new TimeValue((long)RandomInts.randomIntBetween((Random)random, (int)10, (int)30), TimeUnit.SECONDS)});
        }
        if (random.nextInt(10) == 0) {
            builder.put("indices.breaker.request.type", "noop");
            builder.put("indices.breaker.fielddata.type", "noop");
        }
        if (random.nextBoolean()) {
            builder.put("index.queries.cache.type", random.nextBoolean() ? "index" : "none");
        }
        if (random.nextBoolean()) {
            builder.put("index.queries.cache.everything", random.nextBoolean());
        }
        if (random.nextBoolean()) {
            if (random.nextInt(10) == 0) {
                builder.put(new Object[]{"indices.store.throttle.max_bytes_per_sec", new ByteSizeValue((long)RandomInts.randomIntBetween((Random)random, (int)1, (int)10), ByteSizeUnit.MB)});
            } else {
                builder.put(new Object[]{"indices.store.throttle.max_bytes_per_sec", new ByteSizeValue((long)RandomInts.randomIntBetween((Random)random, (int)10, (int)200), ByteSizeUnit.MB)});
            }
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"indices.store.throttle.type", RandomPicks.randomFrom((Random)random, (Object[])StoreRateLimiting.Type.values())});
        }
        if (random.nextBoolean()) {
            if (random.nextInt(10) == 0) {
                builder.put(new Object[]{"indices.recovery.max_bytes_per_sec", new ByteSizeValue((long)RandomInts.randomIntBetween((Random)random, (int)1, (int)10), ByteSizeUnit.MB)});
            } else {
                builder.put(new Object[]{"indices.recovery.max_bytes_per_sec", new ByteSizeValue((long)RandomInts.randomIntBetween((Random)random, (int)10, (int)200), ByteSizeUnit.MB)});
            }
        }
        if (random.nextBoolean()) {
            builder.put("indices.recovery.compress", random.nextBoolean());
        }
        if (random.nextBoolean()) {
            builder.put("indices.requests.cache.concurrency_level", RandomInts.randomIntBetween((Random)random, (int)1, (int)32));
            builder.put("indices.fielddata.cache.concurrency_level", RandomInts.randomIntBetween((Random)random, (int)1, (int)32));
        }
        if (random.nextBoolean()) {
            builder.put("transport.ping_schedule", RandomInts.randomIntBetween((Random)random, (int)100, (int)2000) + "ms");
        }
        if (random.nextBoolean()) {
            builder.put("script.cache.max_size", RandomInts.randomIntBetween((Random)random, (int)-100, (int)2000));
        }
        if (random.nextBoolean()) {
            builder.put(new Object[]{"script.cache.expire", TimeValue.timeValueMillis((long)RandomInts.randomIntBetween((Random)random, (int)750, (int)10000000))});
        }
        builder.put("index.unassigned.node_left.delayed_timeout", 0);
        return builder.build();
    }

    public static String clusterName(String prefix, long clusterSeed) {
        StringBuilder builder = new StringBuilder(prefix);
        int childVM = RandomizedTest.systemPropertyAsInt((String)"junit4.childvm.id", (int)0);
        builder.append("-CHILD_VM=[").append(childVM).append(']');
        builder.append("-CLUSTER_SEED=[").append(clusterSeed).append(']');
        builder.append("-HASH=[").append(SeedUtils.formatSeed((long)System.nanoTime())).append(']');
        return builder.toString();
    }

    private void ensureOpen() {
        if (!this.open.get()) {
            throw new RuntimeException("Cluster is already closed");
        }
    }

    private synchronized NodeAndClient getOrBuildRandomNode() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient;
        }
        NodeAndClient buildNode = this.buildNode();
        buildNode.node().start();
        this.publishNode(buildNode);
        return buildNode;
    }

    private synchronized NodeAndClient getRandomNodeAndClient() {
        Predicate all = Predicates.alwaysTrue();
        return this.getRandomNodeAndClient((Predicate<NodeAndClient>)all);
    }

    private synchronized NodeAndClient getRandomNodeAndClient(Predicate<NodeAndClient> predicate) {
        this.ensureOpen();
        Collection values = Collections2.filter(this.nodes.values(), predicate);
        if (!values.isEmpty()) {
            int whichOne = this.random.nextInt(values.size());
            for (NodeAndClient nodeAndClient : values) {
                if (whichOne-- != 0) continue;
                return nodeAndClient;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAtLeastNumDataNodes(int n) {
        ArrayList<ListenableFuture<String>> futures = new ArrayList<ListenableFuture<String>>();
        InternalTestCluster internalTestCluster = this;
        synchronized (internalTestCluster) {
            int size;
            for (int i = size = this.numDataNodes(); i < n; ++i) {
                this.logger.info("increasing cluster size from {} to {}", new Object[]{size, n});
                futures.add(this.startNodeAsync());
            }
        }
        try {
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to start nodes", (Throwable)e, new Object[0]);
        }
        if (!futures.isEmpty()) {
            internalTestCluster = this;
            synchronized (internalTestCluster) {
                ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)this.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(this.nodes.size())).get());
            }
        }
    }

    public synchronized void ensureAtMostNumDataNodes(int n) throws IOException {
        int size = this.numDataNodes();
        if (size <= n) {
            return;
        }
        UnmodifiableIterator values = n == 0 ? this.nodes.values().iterator() : Iterators.filter(this.nodes.values().iterator(), (Predicate)Predicates.and((Predicate)new DataNodePredicate(), (Predicate)Predicates.not((Predicate)new MasterNodePredicate(this.getMasterName()))));
        Iterator limit = Iterators.limit(values, (int)(size - n));
        this.logger.info("changing cluster size from {} to {}, {} data nodes", new Object[]{this.size(), n + this.numSharedClientNodes, n});
        HashSet<NodeAndClient> nodesToRemove = new HashSet<NodeAndClient>();
        while (limit.hasNext()) {
            NodeAndClient next = (NodeAndClient)limit.next();
            nodesToRemove.add(next);
            this.removeDisruptionSchemeFromNode(next);
            next.close();
        }
        for (NodeAndClient toRemove : nodesToRemove) {
            this.nodes.remove(toRemove.name);
        }
        if (!nodesToRemove.isEmpty() && this.size() > 0) {
            ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)this.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(this.nodes.size())).get());
        }
    }

    private NodeAndClient buildNode(Settings settings, Version version) {
        int ord = this.nextNodeId.getAndIncrement();
        return this.buildNode(ord, this.random.nextLong(), settings, version);
    }

    private NodeAndClient buildNode() {
        int ord = this.nextNodeId.getAndIncrement();
        return this.buildNode(ord, this.random.nextLong(), null, Version.CURRENT);
    }

    private NodeAndClient buildNode(int nodeId, long seed, Settings settings, Version version) {
        assert (Thread.holdsLock(this));
        this.ensureOpen();
        settings = this.getSettings(nodeId, seed, settings);
        Collection<Class<? extends Plugin>> plugins = this.getPlugins(seed);
        String name = this.buildNodeName(nodeId);
        assert (!this.nodes.containsKey(name));
        Settings finalSettings = Settings.settingsBuilder().put(new Object[]{"path.home", this.baseDir}).put(settings).put("name", name).put("discovery.id.seed", seed).build();
        MockNode node = new MockNode(finalSettings, version, plugins);
        return new NodeAndClient(name, node);
    }

    private String buildNodeName(int id) {
        return this.nodePrefix + id;
    }

    public String nodePrefix() {
        return this.nodePrefix;
    }

    @Override
    public synchronized Client client() {
        this.ensureOpen();
        return this.getOrBuildRandomNode().client(this.random);
    }

    public synchronized Client dataNodeClient() {
        this.ensureOpen();
        return this.getRandomNodeAndClient(new DataNodePredicate()).client(this.random);
    }

    public synchronized Client masterClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new MasterNodePredicate(this.getMasterName()));
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No master client found");
        return null;
    }

    public synchronized Client nonMasterClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient((Predicate<NodeAndClient>)Predicates.not((Predicate)new MasterNodePredicate(this.getMasterName())));
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No non-master client found");
        return null;
    }

    public synchronized Client clientNodeClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new ClientNodePredicate());
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.client(this.random);
        }
        int nodeId = this.nextNodeId.getAndIncrement();
        Settings settings = this.getSettings(nodeId, this.random.nextLong(), Settings.EMPTY);
        this.startNodeClient(settings);
        return this.getRandomNodeAndClient(new ClientNodePredicate()).client(this.random);
    }

    public synchronized Client startNodeClient(Settings settings) {
        this.ensureOpen();
        Settings.Builder builder = Settings.settingsBuilder().put(settings).put("node.client", true);
        if (this.size() == 0) {
            builder.put("discovery.initial_state_timeout", 0);
        }
        String name = this.startNode(builder);
        return ((NodeAndClient)this.nodes.get(name)).nodeClient();
    }

    public synchronized Client transportClient() {
        this.ensureOpen();
        return this.getOrBuildRandomNode().transportClient();
    }

    public synchronized Client client(String nodeName) {
        this.ensureOpen();
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            return nodeAndClient.client(this.random);
        }
        Assert.fail((String)("No node found with name: [" + nodeName + "]"));
        return null;
    }

    public synchronized Client smartClient() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        Assert.fail((String)"No smart client found");
        return null;
    }

    public synchronized Client client(final Predicate<Settings> filterPredicate) {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new Predicate<NodeAndClient>(){

            public boolean apply(NodeAndClient nodeAndClient) {
                return filterPredicate.apply((Object)nodeAndClient.node.settings());
            }
        });
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.client(this.random);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            if (this.activeDisruptionScheme != null) {
                this.activeDisruptionScheme.testClusterClosed();
                this.activeDisruptionScheme = null;
            }
            IOUtils.closeWhileHandlingException(this.nodes.values());
            this.nodes.clear();
            this.executor.shutdownNow();
        }
    }

    public String getNodeMode() {
        return this.nodeMode;
    }

    @Override
    public synchronized void beforeTest(Random random, double transportClientRatio) throws IOException, InterruptedException {
        super.beforeTest(random, transportClientRatio);
        this.reset(true);
    }

    private synchronized void reset(boolean wipeData) throws IOException {
        NodeAndClient nodeAndClient4;
        String buildNodeName;
        int i;
        for (NodeAndClient nodeAndClient2 : this.nodes.values()) {
            TransportService transportService = (TransportService)nodeAndClient2.node.injector().getInstance(TransportService.class);
            if (!(transportService instanceof MockTransportService)) continue;
            MockTransportService mockTransportService = (MockTransportService)transportService;
            mockTransportService.clearAllRules();
            mockTransportService.clearTracers();
        }
        this.randomlyResetClients();
        if (wipeData) {
            this.wipeDataDirectories();
        }
        if (this.nextNodeId.get() == this.sharedNodesSeeds.length && this.nodes.size() == this.sharedNodesSeeds.length) {
            this.logger.debug("Cluster hasn't changed - moving out - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", new Object[]{this.nodes.keySet(), this.nextNodeId.get(), this.sharedNodesSeeds.length});
            return;
        }
        this.logger.debug("Cluster is NOT consistent - restarting shared nodes - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", new Object[]{this.nodes.keySet(), this.nextNodeId.get(), this.sharedNodesSeeds.length});
        HashSet<NodeAndClient> sharedNodes = new HashSet<NodeAndClient>();
        assert (this.sharedNodesSeeds.length == this.numSharedDataNodes + this.numSharedClientNodes);
        boolean changed = false;
        for (i = 0; i < this.numSharedDataNodes; ++i) {
            buildNodeName = this.buildNodeName(i);
            nodeAndClient4 = (NodeAndClient)this.nodes.get(buildNodeName);
            if (nodeAndClient4 == null) {
                changed = true;
                nodeAndClient4 = this.buildNode(i, this.sharedNodesSeeds[i], null, Version.CURRENT);
                nodeAndClient4.node.start();
                this.logger.info("Start Shared Node [{}] not shared", new Object[]{nodeAndClient4.name});
            }
            sharedNodes.add(nodeAndClient4);
        }
        for (i = this.numSharedDataNodes; i < this.numSharedDataNodes + this.numSharedClientNodes; ++i) {
            buildNodeName = this.buildNodeName(i);
            nodeAndClient4 = (NodeAndClient)this.nodes.get(buildNodeName);
            if (nodeAndClient4 == null) {
                changed = true;
                Settings.Builder clientSettingsBuilder = Settings.builder().put("node.client", true);
                nodeAndClient4 = this.buildNode(i, this.sharedNodesSeeds[i], clientSettingsBuilder.build(), Version.CURRENT);
                nodeAndClient4.node.start();
                this.logger.info("Start Shared Node [{}] not shared", new Object[]{nodeAndClient4.name});
            }
            sharedNodes.add(nodeAndClient4);
        }
        if (!changed && sharedNodes.size() == this.nodes.size()) {
            this.logger.debug("Cluster is consistent - moving out - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", new Object[]{this.nodes.keySet(), this.nextNodeId.get(), this.sharedNodesSeeds.length});
            if (this.size() > 0) {
                this.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(this.sharedNodesSeeds.length)).get();
            }
            return;
        }
        for (NodeAndClient nodeAndClient3 : sharedNodes) {
            this.nodes.remove(nodeAndClient3.name);
        }
        Collection toShutDown = this.nodes.values();
        for (NodeAndClient nodeAndClient4 : toShutDown) {
            this.logger.debug("Close Node [{}] not shared", new Object[]{nodeAndClient4.name});
            nodeAndClient4.close();
        }
        this.nodes.clear();
        for (NodeAndClient nodeAndClient4 : sharedNodes) {
            this.publishNode(nodeAndClient4);
        }
        this.nextNodeId.set(this.sharedNodesSeeds.length);
        assert (this.size() == this.sharedNodesSeeds.length);
        if (this.size() > 0) {
            this.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(Integer.toString(this.sharedNodesSeeds.length)).get();
        }
        this.logger.debug("Cluster is consistent again - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", new Object[]{this.nodes.keySet(), this.nextNodeId.get(), this.sharedNodesSeeds.length});
    }

    @Override
    public synchronized void afterTest() throws IOException {
        this.wipeDataDirectories();
        this.randomlyResetClients();
    }

    @Override
    public void beforeIndexDeletion() {
        this.assertShardIndexCounter();
        this.assertSameSyncIdSameDocs();
    }

    private void assertSameSyncIdSameDocs() {
        HashMap<String, Long> docsOnShards = new HashMap<String, Long>();
        Collection nodesAndClients = this.nodes.values();
        for (NodeAndClient nodeAndClient : nodesAndClients) {
            IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
            for (IndexService indexService : indexServices) {
                for (IndexShard indexShard : indexService) {
                    try {
                        CommitStats commitStats = indexShard.engine().commitStats();
                        String syncId = (String)commitStats.getUserData().get("sync_id");
                        if (syncId == null) continue;
                        long liveDocsOnShard = commitStats.getNumDocs();
                        if (docsOnShards.get(syncId) != null) {
                            Assert.assertThat((String)("sync id is equal but number of docs does not match on node " + nodeAndClient.name + ". expected " + docsOnShards.get(syncId) + " but got " + liveDocsOnShard), docsOnShards.get(syncId), (Matcher)Matchers.equalTo((Object)liveDocsOnShard));
                            continue;
                        }
                        docsOnShards.put(syncId, liveDocsOnShard);
                    }
                    catch (EngineClosedException engineClosedException) {}
                }
            }
        }
    }

    private void assertShardIndexCounter() {
        Collection nodesAndClients = this.nodes.values();
        for (NodeAndClient nodeAndClient : nodesAndClients) {
            IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
            for (IndexService indexService : indexServices) {
                for (IndexShard indexShard : indexService) {
                    Assert.assertThat((String)("index shard counter on shard " + indexShard.shardId() + " on node " + nodeAndClient.name + " not 0"), (Object)indexShard.getOperationsCount(), (Matcher)Matchers.equalTo((Object)0));
                }
            }
        }
    }

    private void randomlyResetClients() throws IOException {
        if (RandomizedTest.isNightly() && LuceneTestCase.rarely((Random)this.random)) {
            Collection nodesAndClients = this.nodes.values();
            for (NodeAndClient nodeAndClient : nodesAndClients) {
                nodeAndClient.resetClient();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipeDataDirectories() {
        if (!this.dataDirToClean.isEmpty()) {
            try {
                for (Path path : this.dataDirToClean) {
                    try {
                        FileSystemUtils.deleteSubDirectories((Path[])new Path[]{path});
                        this.logger.info("Successfully wiped data directory for node location: {}", new Object[]{path});
                    }
                    catch (IOException e) {
                        this.logger.info("Failed to wipe data directory for node location: {}", new Object[]{path});
                    }
                }
            }
            finally {
                this.dataDirToClean.clear();
            }
        }
    }

    public ClusterService clusterService() {
        return this.clusterService(null);
    }

    public synchronized ClusterService clusterService(@Nullable String node) {
        return this.getInstance(ClusterService.class, node);
    }

    public synchronized <T> Iterable<T> getInstances(Class<T> clazz) {
        ArrayList<T> instances = new ArrayList<T>(this.nodes.size());
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            instances.add(this.getInstanceFromNode(clazz, nodeAndClient.node));
        }
        return instances;
    }

    public synchronized <T> Iterable<T> getDataNodeInstances(Class<T> clazz) {
        return this.getInstances(clazz, new DataNodePredicate());
    }

    private synchronized <T> Iterable<T> getInstances(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        Iterable filteredNodes = Iterables.filter(this.nodes.values(), predicate);
        ArrayList<T> instances = new ArrayList<T>();
        for (NodeAndClient nodeAndClient : filteredNodes) {
            instances.add(this.getInstanceFromNode(clazz, nodeAndClient.node));
        }
        return instances;
    }

    public synchronized <T> T getInstance(Class<T> clazz, final String node) {
        Object predicate = node != null ? new Predicate<NodeAndClient>(){

            public boolean apply(NodeAndClient nodeAndClient) {
                return node.equals(nodeAndClient.name);
            }
        } : Predicates.alwaysTrue();
        return this.getInstance(clazz, (Predicate<NodeAndClient>)predicate);
    }

    public synchronized <T> T getDataNodeInstance(Class<T> clazz) {
        return this.getInstance(clazz, new DataNodePredicate());
    }

    private synchronized <T> T getInstance(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(predicate);
        assert (randomNodeAndClient != null);
        return this.getInstanceFromNode(clazz, randomNodeAndClient.node);
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, (Predicate<NodeAndClient>)Predicates.alwaysTrue());
    }

    private synchronized <T> T getInstanceFromNode(Class<T> clazz, Node node) {
        return (T)node.injector().getInstance(clazz);
    }

    @Override
    public synchronized int size() {
        return this.nodes.size();
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (HttpServerTransport httpServerTransport : this.getInstances(HttpServerTransport.class)) {
            addresses.add(((InetSocketTransportAddress)httpServerTransport.boundAddress().publishAddress()).address());
        }
        return addresses.toArray(new InetSocketAddress[addresses.size()]);
    }

    public synchronized boolean stopRandomDataNode() throws IOException {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(new DataNodePredicate());
        if (nodeAndClient != null) {
            this.logger.info("Closing random node [{}] ", new Object[]{nodeAndClient.name});
            this.removeDisruptionSchemeFromNode(nodeAndClient);
            this.nodes.remove(nodeAndClient.name);
            nodeAndClient.close();
            return true;
        }
        return false;
    }

    public synchronized void stopRandomNode(final Predicate<Settings> filter) throws IOException {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(new Predicate<NodeAndClient>(){

            public boolean apply(NodeAndClient nodeAndClient) {
                return filter.apply((Object)nodeAndClient.node.settings());
            }
        });
        if (nodeAndClient != null) {
            this.logger.info("Closing filtered random node [{}] ", new Object[]{nodeAndClient.name});
            this.removeDisruptionSchemeFromNode(nodeAndClient);
            this.nodes.remove(nodeAndClient.name);
            nodeAndClient.close();
        }
    }

    public synchronized void stopCurrentMasterNode() throws IOException {
        this.ensureOpen();
        assert (this.size() > 0);
        String masterNodeName = this.getMasterName();
        assert (this.nodes.containsKey(masterNodeName));
        this.logger.info("Closing master node [{}] ", new Object[]{masterNodeName});
        this.removeDisruptionSchemeFromNode((NodeAndClient)this.nodes.get(masterNodeName));
        NodeAndClient remove = (NodeAndClient)this.nodes.remove(masterNodeName);
        remove.close();
    }

    public void stopRandomNonMasterNode() throws IOException {
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient((Predicate<NodeAndClient>)Predicates.not((Predicate)new MasterNodePredicate(this.getMasterName())));
        if (nodeAndClient != null) {
            this.logger.info("Closing random non master node [{}] current master [{}] ", new Object[]{nodeAndClient.name, this.getMasterName()});
            this.removeDisruptionSchemeFromNode(nodeAndClient);
            this.nodes.remove(nodeAndClient.name);
            nodeAndClient.close();
        }
    }

    public void restartRandomNode() throws Exception {
        this.restartRandomNode(EMPTY_CALLBACK);
    }

    public void restartRandomNode(RestartCallback callback) throws Exception {
        this.restartRandomNode((Predicate<NodeAndClient>)Predicates.alwaysTrue(), callback);
    }

    public void restartRandomDataNode() throws Exception {
        this.restartRandomDataNode(EMPTY_CALLBACK);
    }

    public void restartRandomDataNode(RestartCallback callback) throws Exception {
        this.restartRandomNode(new DataNodePredicate(), callback);
    }

    private void restartRandomNode(Predicate<NodeAndClient> predicate, RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(predicate);
        if (nodeAndClient != null) {
            this.logger.info("Restarting random node [{}] ", new Object[]{nodeAndClient.name});
            nodeAndClient.restart(callback);
        }
    }

    public void restartNode(String nodeName, RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            this.logger.info("Restarting node [{}] ", new Object[]{nodeAndClient.name});
            nodeAndClient.restart(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartAllNodes(boolean rollingRestart, RestartCallback callback) throws Exception {
        this.ensureOpen();
        ArrayList<NodeAndClient> toRemove = new ArrayList<NodeAndClient>();
        try {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                if (callback.doRestart(nodeAndClient.name)) continue;
                this.logger.info("Closing node [{}] during restart", new Object[]{nodeAndClient.name});
                toRemove.add(nodeAndClient);
                if (this.activeDisruptionScheme != null) {
                    this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
                }
                nodeAndClient.close();
            }
        }
        finally {
            for (NodeAndClient nodeAndClient : toRemove) {
                this.nodes.remove(nodeAndClient.name);
            }
        }
        this.logger.info("Restarting remaining nodes rollingRestart [{}]", new Object[]{rollingRestart});
        if (rollingRestart) {
            int numNodesRestarted = 0;
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
                this.logger.info("Restarting node [{}] ", new Object[]{nodeAndClient.name});
                if (this.activeDisruptionScheme != null) {
                    this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
                }
                nodeAndClient.restart(callback);
                if (this.activeDisruptionScheme == null) continue;
                this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
            }
        } else {
            int numNodesRestarted = 0;
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
                this.logger.info("Stopping node [{}] ", new Object[]{nodeAndClient.name});
                if (this.activeDisruptionScheme != null) {
                    this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
                }
                nodeAndClient.closeNode();
            }
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                this.logger.info("Starting node [{}] ", new Object[]{nodeAndClient.name});
                if (this.activeDisruptionScheme != null) {
                    this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
                }
                nodeAndClient.restart(callback);
                if (this.activeDisruptionScheme == null) continue;
                this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
            }
        }
    }

    public void fullRestart() throws Exception {
        this.fullRestart(EMPTY_CALLBACK);
    }

    public void rollingRestart() throws Exception {
        this.rollingRestart(EMPTY_CALLBACK);
    }

    public void rollingRestart(RestartCallback function) throws Exception {
        this.restartAllNodes(true, function);
    }

    public void fullRestart(RestartCallback function) throws Exception {
        this.restartAllNodes(false, function);
    }

    public String getMasterName() {
        return this.getMasterName(null);
    }

    public String getMasterName(@Nullable String viaNode) {
        try {
            Client client = viaNode != null ? this.client(viaNode) : this.client();
            ClusterState state = ((ClusterStateResponse)client.admin().cluster().prepareState().execute().actionGet()).getState();
            return state.nodes().masterNode().name();
        }
        catch (Throwable e) {
            this.logger.warn("Can't fetch cluster state", e, new Object[0]);
            throw new RuntimeException("Can't get master node " + e.getMessage(), e);
        }
    }

    synchronized Set<String> allDataNodesButN(int numNodes) {
        return this.nRandomDataNodes(this.numDataNodes() - numNodes);
    }

    private synchronized Set<String> nRandomDataNodes(int numNodes) {
        assert (this.size() >= numNodes);
        NavigableMap dataNodes = Maps.filterEntries(this.nodes, (Predicate)new EntryNodePredicate(new DataNodePredicate()));
        return Sets.newHashSet((Iterator)Iterators.limit(dataNodes.keySet().iterator(), (int)numNodes));
    }

    public synchronized Set<String> nodesInclude(String index) {
        if (this.clusterService().state().routingTable().hasIndex(index)) {
            List allShards = this.clusterService().state().routingTable().allShards(index);
            DiscoveryNodes discoveryNodes = this.clusterService().state().getNodes();
            HashSet<String> nodes = new HashSet<String>();
            for (ShardRouting shardRouting : allShards) {
                if (!shardRouting.assignedToNode()) continue;
                DiscoveryNode discoveryNode = discoveryNodes.get(shardRouting.currentNodeId());
                nodes.add(discoveryNode.getName());
            }
            return nodes;
        }
        return Collections.emptySet();
    }

    public synchronized String startNode() {
        return this.startNode(Settings.EMPTY, Version.CURRENT);
    }

    public synchronized String startNode(Version version) {
        return this.startNode(Settings.EMPTY, version);
    }

    public synchronized String startNode(Settings.Builder settings) {
        return this.startNode(settings.build(), Version.CURRENT);
    }

    public synchronized String startNode(Settings settings) {
        return this.startNode(settings, Version.CURRENT);
    }

    public synchronized String startNode(Settings settings, Version version) {
        NodeAndClient buildNode = this.buildNode(settings, version);
        buildNode.node().start();
        this.publishNode(buildNode);
        return buildNode.name;
    }

    public synchronized ListenableFuture<List<String>> startMasterOnlyNodesAsync(int numNodes) {
        return this.startMasterOnlyNodesAsync(numNodes, Settings.EMPTY);
    }

    public synchronized ListenableFuture<List<String>> startMasterOnlyNodesAsync(int numNodes, Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", true).put("node.data", false).build();
        return this.startNodesAsync(numNodes, settings1, Version.CURRENT);
    }

    public synchronized ListenableFuture<List<String>> startDataOnlyNodesAsync(int numNodes) {
        return this.startDataOnlyNodesAsync(numNodes, Settings.EMPTY);
    }

    public synchronized ListenableFuture<List<String>> startDataOnlyNodesAsync(int numNodes, Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", false).put("node.data", true).build();
        return this.startNodesAsync(numNodes, settings1, Version.CURRENT);
    }

    public synchronized ListenableFuture<String> startMasterOnlyNodeAsync() {
        return this.startMasterOnlyNodeAsync(Settings.EMPTY);
    }

    public synchronized ListenableFuture<String> startMasterOnlyNodeAsync(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", true).put("node.data", false).build();
        return this.startNodeAsync(settings1, Version.CURRENT);
    }

    public synchronized String startMasterOnlyNode(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", true).put("node.data", false).build();
        return this.startNode(settings1, Version.CURRENT);
    }

    public synchronized ListenableFuture<String> startDataOnlyNodeAsync() {
        return this.startDataOnlyNodeAsync(Settings.EMPTY);
    }

    public synchronized ListenableFuture<String> startDataOnlyNodeAsync(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", false).put("node.data", true).build();
        return this.startNodeAsync(settings1, Version.CURRENT);
    }

    public synchronized String startDataOnlyNode(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put("node.master", false).put("node.data", true).build();
        return this.startNode(settings1, Version.CURRENT);
    }

    public synchronized ListenableFuture<String> startNodeAsync() {
        return this.startNodeAsync(Settings.EMPTY, Version.CURRENT);
    }

    public synchronized ListenableFuture<String> startNodeAsync(Settings settings) {
        return this.startNodeAsync(settings, Version.CURRENT);
    }

    public synchronized ListenableFuture<String> startNodeAsync(Settings settings, Version version) {
        final SettableFuture future = SettableFuture.create();
        final NodeAndClient buildNode = this.buildNode(settings, version);
        Runnable startNode = new Runnable(){

            @Override
            public void run() {
                try {
                    buildNode.node().start();
                    InternalTestCluster.this.publishNode(buildNode);
                    future.set((Object)buildNode.name);
                }
                catch (Throwable t) {
                    future.setException(t);
                }
            }
        };
        this.executor.execute(startNode);
        return future;
    }

    public synchronized ListenableFuture<List<String>> startNodesAsync(int numNodes) {
        return this.startNodesAsync(numNodes, Settings.EMPTY, Version.CURRENT);
    }

    public synchronized ListenableFuture<List<String>> startNodesAsync(int numNodes, Settings settings) {
        return this.startNodesAsync(numNodes, settings, Version.CURRENT);
    }

    public synchronized ListenableFuture<List<String>> startNodesAsync(int numNodes, Settings settings, Version version) {
        ArrayList<ListenableFuture<String>> futures = new ArrayList<ListenableFuture<String>>();
        for (int i = 0; i < numNodes; ++i) {
            futures.add(this.startNodeAsync(settings, version));
        }
        return Futures.allAsList(futures);
    }

    public synchronized ListenableFuture<List<String>> startNodesAsync(Settings ... settings) {
        ArrayList<ListenableFuture<String>> futures = new ArrayList<ListenableFuture<String>>();
        for (Settings setting : settings) {
            futures.add(this.startNodeAsync(setting, Version.CURRENT));
        }
        return Futures.allAsList(futures);
    }

    private synchronized void publishNode(NodeAndClient nodeAndClient) {
        assert (!nodeAndClient.node().isClosed());
        NodeEnvironment nodeEnv = this.getInstanceFromNode(NodeEnvironment.class, nodeAndClient.node);
        if (nodeEnv.hasNodeFile()) {
            this.dataDirToClean.addAll(Arrays.asList(nodeEnv.nodeDataPaths()));
        }
        this.nodes.put(nodeAndClient.name, nodeAndClient);
        this.applyDisruptionSchemeToNode(nodeAndClient);
    }

    public void closeNonSharedNodes(boolean wipeData) throws IOException {
        this.reset(wipeData);
    }

    @Override
    public int numDataNodes() {
        return this.dataNodeAndClients().size();
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.dataAndMasterNodes().size();
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        this.clearDisruptionScheme();
        scheme.applyToCluster(this);
        this.activeDisruptionScheme = scheme;
    }

    public void clearDisruptionScheme() {
        if (this.activeDisruptionScheme != null) {
            TimeValue expectedHealingTime = this.activeDisruptionScheme.expectedTimeToHeal();
            this.logger.info("Clearing active scheme {}, expected healing time {}", new Object[]{this.activeDisruptionScheme, expectedHealingTime});
            this.activeDisruptionScheme.removeAndEnsureHealthy(this);
        }
        this.activeDisruptionScheme = null;
    }

    private void applyDisruptionSchemeToNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
        }
    }

    private void removeDisruptionSchemeFromNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
        }
    }

    private synchronized Collection<NodeAndClient> dataNodeAndClients() {
        return Collections2.filter(this.nodes.values(), (Predicate)new DataNodePredicate());
    }

    private synchronized Collection<NodeAndClient> dataAndMasterNodes() {
        return Collections2.filter(this.nodes.values(), (Predicate)new DataOrMasterNodePredicate());
    }

    synchronized String routingKeyForShard(String index, String type, int shard, Random random) {
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        for (NodeAndClient n : this.nodes.values()) {
            String routing;
            int targetShard;
            MockNode node = n.node;
            IndicesService indicesService = this.getInstanceFromNode(IndicesService.class, node);
            ClusterService clusterService = this.getInstanceFromNode(ClusterService.class, node);
            IndexService indexService = indicesService.indexService(index);
            if (indexService == null) continue;
            Assert.assertThat((Object)indexService.indexSettings().getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(shard)));
            OperationRouting operationRouting = (OperationRouting)indexService.injector().getInstance(OperationRouting.class);
            do {
                routing = RandomStrings.randomAsciiOfLength((Random)random, (int)10);
            } while (shard != (targetShard = operationRouting.indexShards(clusterService.state(), index, type, null, routing).shardId().getId()));
            return routing;
        }
        junit.framework.Assert.fail((String)("Could not find a node that holds " + index));
        return null;
    }

    @Override
    public synchronized Iterator<Client> iterator() {
        this.ensureOpen();
        final Iterator iterator = this.nodes.values().iterator();
        return new Iterator<Client>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Client next() {
                return ((NodeAndClient)iterator.next()).client(InternalTestCluster.this.random);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("");
            }
        };
    }

    public static Predicate<Settings> nameFilter(String ... nodeName) {
        return new NodeNamePredicate(new HashSet<String>(Arrays.asList(nodeName)));
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesFieldDataCache fdCache = this.getInstanceFromNode(IndicesFieldDataCache.class, nodeAndClient.node);
                fdCache.getCache().cleanUp();
                final String name = nodeAndClient.name;
                final CircuitBreakerService breakerService = this.getInstanceFromNode(CircuitBreakerService.class, nodeAndClient.node);
                CircuitBreaker fdBreaker = breakerService.getBreaker("fielddata");
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + name), (Object)fdBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                try {
                    ESTestCase.assertBusy(new Runnable(){

                        @Override
                        public void run() {
                            CircuitBreaker reqBreaker = breakerService.getBreaker("request");
                            Assert.assertThat((String)("Request breaker not reset to 0 on node: " + name), (Object)reqBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                        }
                    });
                }
                catch (Exception e) {
                    junit.framework.Assert.fail((String)("Exception during check for request breaker reset to 0: " + e));
                }
                NodeService nodeService = this.getInstanceFromNode(NodeService.class, nodeAndClient.node);
                NodeStats stats = nodeService.stats(CommonStatsFlags.ALL, false, false, false, false, false, false, false, false, false);
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + stats.getNode()), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public void assertAfterTest() throws IOException {
        super.assertAfterTest();
        for (NodeEnvironment env : this.getInstances(NodeEnvironment.class)) {
            Set shardIds = env.lockedShards();
            for (ShardId id : shardIds) {
                try {
                    env.shardLock(id, TimeUnit.SECONDS.toMillis(5L)).close();
                }
                catch (IOException ex) {
                    junit.framework.Assert.fail((String)("Shard " + id + " is still locked after 5 sec waiting"));
                }
            }
        }
    }

    public String unicastHosts() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (NodeAndClient node : this.nodes.values()) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append("localhost:").append(((TransportService)node.node().injector().getInstance(TransportService.class)).boundAddress().publishAddress().getPort());
        }
        return b.toString();
    }

    @Override
    protected Settings settingsForRandomRepoPath() {
        return this.getDefaultSettings();
    }

    public static class RestartCallback {
        public Settings onNodeStopped(String nodeName) throws Exception {
            return Settings.EMPTY;
        }

        public void doAfterNodes(int n, Client client) throws Exception {
        }

        public boolean clearData(String nodeName) {
            return false;
        }

        public boolean doRestart(String nodeName) {
            return true;
        }
    }

    private static final class NodeNamePredicate
    implements Predicate<Settings> {
        private final HashSet<String> nodeNames;

        public NodeNamePredicate(HashSet<String> nodeNames) {
            this.nodeNames = nodeNames;
        }

        public boolean apply(Settings settings) {
            return this.nodeNames.contains(settings.get("name"));
        }
    }

    private static final class EntryNodePredicate
    implements Predicate<Map.Entry<String, NodeAndClient>> {
        private final Predicate<NodeAndClient> delegateNodePredicate;

        EntryNodePredicate(Predicate<NodeAndClient> delegateNodePredicate) {
            this.delegateNodePredicate = delegateNodePredicate;
        }

        public boolean apply(Map.Entry<String, NodeAndClient> entry) {
            return this.delegateNodePredicate.apply((Object)entry.getValue());
        }
    }

    private static final class ClientNodePredicate
    implements Predicate<NodeAndClient> {
        private ClientNodePredicate() {
        }

        public boolean apply(NodeAndClient nodeAndClient) {
            return DiscoveryNode.clientNode((Settings)nodeAndClient.node.settings());
        }
    }

    private static final class MasterNodePredicate
    implements Predicate<NodeAndClient> {
        private final String masterNodeName;

        public MasterNodePredicate(String masterNodeName) {
            this.masterNodeName = masterNodeName;
        }

        public boolean apply(NodeAndClient nodeAndClient) {
            return this.masterNodeName.equals(nodeAndClient.name);
        }
    }

    private static final class DataOrMasterNodePredicate
    implements Predicate<NodeAndClient> {
        private DataOrMasterNodePredicate() {
        }

        public boolean apply(NodeAndClient nodeAndClient) {
            return DiscoveryNode.dataNode((Settings)nodeAndClient.node.settings()) || DiscoveryNode.masterNode((Settings)nodeAndClient.node.settings());
        }
    }

    private static final class DataNodePredicate
    implements Predicate<NodeAndClient> {
        private DataNodePredicate() {
        }

        public boolean apply(NodeAndClient nodeAndClient) {
            return DiscoveryNode.dataNode((Settings)nodeAndClient.node.settings());
        }
    }

    static class TransportClientFactory {
        private final boolean sniff;
        private final Settings settings;
        private final Path baseDir;
        private final String nodeMode;
        private final Collection<Class<? extends Plugin>> plugins;

        TransportClientFactory(boolean sniff, Settings settings, Path baseDir, String nodeMode, Collection<Class<? extends Plugin>> plugins) {
            this.sniff = sniff;
            this.settings = settings != null ? settings : Settings.EMPTY;
            this.baseDir = baseDir;
            this.nodeMode = nodeMode;
            this.plugins = plugins;
        }

        public Client client(Node node, String clusterName) {
            TransportAddress addr = ((TransportService)node.injector().getInstance(TransportService.class)).boundAddress().publishAddress();
            Settings nodeSettings = node.settings();
            Settings.Builder builder = Settings.settingsBuilder().put("client.transport.nodes_sampler_interval", "1s").put(new Object[]{"path.home", this.baseDir}).put("name", InternalTestCluster.TRANSPORT_CLIENT_PREFIX + node.settings().get("name")).put("cluster.name", clusterName).put("client.transport.sniff", this.sniff).put("node.mode", nodeSettings.get("node.mode", this.nodeMode)).put("node.local", nodeSettings.get("node.local", "")).put("logger.prefix", nodeSettings.get("logger.prefix", "")).put("logger.level", nodeSettings.get("logger.level", "INFO")).put("config.ignore_system_properties", true).put(this.settings);
            TransportClient.Builder clientBuilder = TransportClient.builder().settings(builder.build());
            for (Class<? extends Plugin> plugin : this.plugins) {
                clientBuilder.addPlugin(plugin);
            }
            TransportClient client = clientBuilder.build();
            client.addTransportAddress(addr);
            return client;
        }
    }

    private final class NodeAndClient
    implements Closeable {
        private MockNode node;
        private Client nodeClient;
        private Client transportClient;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final String name;

        NodeAndClient(String name, MockNode node) {
            this.node = node;
            this.name = name;
        }

        Node node() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.node;
        }

        Client client(Random random) {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            double nextDouble = random.nextDouble();
            if (nextDouble < InternalTestCluster.this.transportClientRatio) {
                if (InternalTestCluster.this.logger.isTraceEnabled()) {
                    InternalTestCluster.this.logger.trace("Using transport client for node [{}] sniff: [{}]", new Object[]{this.node.settings().get("name"), false});
                }
                return this.getOrBuildTransportClient();
            }
            return this.getOrBuildNodeClient();
        }

        Client nodeClient() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.getOrBuildNodeClient();
        }

        Client transportClient() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
            return this.getOrBuildTransportClient();
        }

        private Client getOrBuildNodeClient() {
            if (this.nodeClient != null) {
                return this.nodeClient;
            }
            this.nodeClient = this.node.client();
            return this.nodeClient;
        }

        private Client getOrBuildTransportClient() {
            if (this.transportClient != null) {
                return this.transportClient;
            }
            this.transportClient = new TransportClientFactory(false, InternalTestCluster.this.nodeConfigurationSource.transportClientSettings(), InternalTestCluster.this.baseDir, InternalTestCluster.this.nodeMode, InternalTestCluster.this.nodeConfigurationSource.transportClientPlugins()).client(this.node, InternalTestCluster.this.clusterName);
            return this.transportClient;
        }

        void resetClient() throws IOException {
            if (!this.closed.get()) {
                Releasables.close((Releasable[])new Releasable[]{this.nodeClient, this.transportClient});
                this.nodeClient = null;
                this.transportClient = null;
            }
        }

        void closeNode() {
            this.registerDataPath();
            this.node.close();
        }

        void restart(RestartCallback callback) throws Exception {
            NodeEnvironment nodeEnv;
            Settings newSettings;
            assert (callback != null);
            this.resetClient();
            if (!this.node.isClosed()) {
                this.closeNode();
            }
            if ((newSettings = callback.onNodeStopped(this.name)) == null) {
                newSettings = Settings.EMPTY;
            }
            if (callback.clearData(this.name) && (nodeEnv = (NodeEnvironment)InternalTestCluster.this.getInstanceFromNode(NodeEnvironment.class, this.node)).hasNodeFile()) {
                IOUtils.rm((Path[])nodeEnv.nodeDataPaths());
            }
            long newIdSeed = this.node.settings().getAsLong("discovery.id.seed", Long.valueOf(0L)) + 1L;
            Settings finalSettings = Settings.builder().put(this.node.settings()).put(newSettings).put("discovery.id.seed", newIdSeed).build();
            Collection<Class<? extends Plugin>> plugins = this.node.getPlugins();
            Version version = this.node.getVersion();
            this.node = new MockNode(finalSettings, version, plugins);
            this.node.start();
        }

        void registerDataPath() {
            NodeEnvironment nodeEnv = (NodeEnvironment)InternalTestCluster.this.getInstanceFromNode(NodeEnvironment.class, this.node);
            if (nodeEnv.hasNodeFile()) {
                InternalTestCluster.this.dataDirToClean.addAll(Arrays.asList(nodeEnv.nodeDataPaths()));
            }
        }

        @Override
        public void close() throws IOException {
            this.resetClient();
            this.closed.set(true);
            this.closeNode();
        }
    }
}

