/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.elasticsearch.common.regex.Regex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class MockLogAppender
extends AppenderSkeleton {
    private static final String COMMON_PREFIX = System.getProperty("es.logger.prefix", "org.elasticsearch.");
    private List<LoggingExpectation> expectations = new ArrayList<LoggingExpectation>();

    public void addExpectation(LoggingExpectation expectation) {
        this.expectations.add(expectation);
    }

    protected void append(LoggingEvent loggingEvent) {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.match(loggingEvent);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public void assertAllExpectationsMatched() {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.assertMatched();
        }
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("org.elasticsearch.")) {
            name = name.substring("org.elasticsearch.".length());
        }
        return COMMON_PREFIX + name;
    }

    public static class SeenEventExpectation
    extends AbstractEventExpectation {
        public SeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class UnseenEventExpectation
    extends AbstractEventExpectation {
        public UnseenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }

    public static abstract class AbstractEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String message;
        protected boolean saw;

        public AbstractEventExpectation(String name, String logger, Level level, String message) {
            this.name = name;
            this.logger = MockLogAppender.getLoggerName(logger);
            this.level = level;
            this.message = message;
            this.saw = false;
        }

        @Override
        public void match(LoggingEvent event) {
            if (event.getLevel() == this.level && event.getLoggerName().equals(this.logger)) {
                if (Regex.isSimpleMatchPattern((String)this.message)) {
                    if (Regex.simpleMatch((String)this.message, (String)event.getMessage().toString())) {
                        this.saw = true;
                    }
                } else if (event.getMessage().toString().contains(this.message)) {
                    this.saw = true;
                }
            }
        }
    }

    public static interface LoggingExpectation {
        public void match(LoggingEvent var1);

        public void assertMatched();
    }
}

