/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.hppc.ObjectArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class TestCluster
implements Iterable<Client>,
Closeable {
    protected final ESLogger logger = Loggers.getLogger(this.getClass());
    private final long seed;
    protected Random random;
    protected double transportClientRatio = 0.0;

    public TestCluster(long seed) {
        this.seed = seed;
    }

    public long seed() {
        return this.seed;
    }

    public void beforeTest(Random random, double transportClientRatio) throws IOException, InterruptedException {
        assert (transportClientRatio >= 0.0 && transportClientRatio <= 1.0);
        this.logger.debug("Reset test cluster with transport client ratio: [{}]", new Object[]{transportClientRatio});
        this.transportClientRatio = transportClientRatio;
        this.random = new Random(random.nextLong());
    }

    public void wipe(Set<String> excludeTemplates) {
        this.wipeIndices("_all");
        this.wipeAllTemplates(excludeTemplates);
        this.wipeRepositories(new String[0]);
    }

    public void beforeIndexDeletion() {
    }

    public void assertAfterTest() throws IOException {
        this.ensureEstimatedStats();
    }

    public abstract void afterTest() throws IOException;

    public abstract Client client();

    public abstract int size();

    public abstract int numDataNodes();

    public int maximumNumberOfReplicasThatCanBeReliablyAssigned() {
        return this.numDataNodes() - 1;
    }

    public abstract int numDataAndMasterNodes();

    public abstract InetSocketAddress[] httpAddresses();

    @Override
    public abstract void close() throws IOException;

    public void wipeIndices(String ... indices) {
        block6: {
            assert (indices != null && indices.length > 0);
            if (this.size() > 0) {
                try {
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(indices));
                }
                catch (IndexNotFoundException indexNotFoundException) {
                }
                catch (IllegalArgumentException e) {
                    if (!"_all".equals(indices[0])) break block6;
                    ClusterStateResponse clusterStateResponse = (ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet();
                    ObjectArrayList concreteIndices = new ObjectArrayList();
                    for (IndexMetaData indexMetaData : clusterStateResponse.getState().metaData()) {
                        concreteIndices.add((Object)indexMetaData.getIndex());
                    }
                    if (concreteIndices.isEmpty()) break block6;
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete((String[])concreteIndices.toArray(String.class)));
                }
            }
        }
    }

    public void wipeAllTemplates(Set<String> exclude) {
        if (this.size() > 0) {
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)this.client().admin().indices().prepareGetTemplates(new String[0]).get();
            for (IndexTemplateMetaData indexTemplate : response.getIndexTemplates()) {
                if (exclude.contains(indexTemplate.getName())) continue;
                try {
                    this.client().admin().indices().prepareDeleteTemplate(indexTemplate.getName()).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {}
            }
        }
    }

    public void wipeTemplates(String ... templates) {
        if (this.size() > 0) {
            if (templates.length == 0) {
                templates = new String[]{"*"};
            }
            for (String template : templates) {
                try {
                    this.client().admin().indices().prepareDeleteTemplate(template).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public void wipeRepositories(String ... repositories) {
        if (this.size() > 0) {
            if (repositories.length == 0) {
                repositories = new String[]{"*"};
            }
            for (String repository : repositories) {
                try {
                    this.client().admin().cluster().prepareDeleteRepository(repository).execute().actionGet();
                }
                catch (RepositoryMissingException repositoryMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public final Path randomRepoPath() {
        Path path;
        Environment environment = new Environment(this.settingsForRandomRepoPath());
        Path[] repoFiles = environment.repoFiles();
        assert (repoFiles.length > 0);
        while (Files.exists(path = repoFiles[0].resolve(ESTestCase.randomAsciiOfLength(10)), new LinkOption[0])) {
        }
        return path;
    }

    protected Settings settingsForRandomRepoPath() {
        throw new UnsupportedOperationException("unsupported cluster type");
    }

    public abstract void ensureEstimatedStats();

    public abstract String getClusterName();
}

