/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.HasHeaders;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.threadpool.ThreadPool;

public class TestSearchContext
extends SearchContext {
    final PageCacheRecycler pageCacheRecycler;
    final BigArrays bigArrays;
    final IndexService indexService;
    final IndexFieldDataService indexFieldDataService;
    final BitsetFilterCache fixedBitSetFilterCache;
    final ThreadPool threadPool;
    final Map<Class<?>, Collector> queryCollectors = new HashMap();
    final IndexShard indexShard;
    final Counter timeEstimateCounter = Counter.newCounter();
    final QuerySearchResult queryResult = new QuerySearchResult();
    ParsedQuery originalQuery;
    ParsedQuery postFilter;
    Query query;
    Float minScore;
    ContextIndexSearcher searcher;
    int size;
    private int terminateAfter = 0;
    private String[] types;
    private SearchContextAggregations aggregations;
    private final long originNanoTime = System.nanoTime();
    private final Map<String, FetchSubPhaseContext> subPhaseContexts = new HashMap<String, FetchSubPhaseContext>();

    public TestSearchContext(ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, IndexService indexService) {
        super(ParseFieldMatcher.STRICT, null);
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.indexService = indexService;
        this.indexFieldDataService = indexService.fieldData();
        this.fixedBitSetFilterCache = indexService.bitsetFilterCache();
        this.threadPool = threadPool;
        this.indexShard = indexService.shard(0);
    }

    public TestSearchContext() {
        super(ParseFieldMatcher.STRICT, null);
        this.pageCacheRecycler = null;
        this.bigArrays = null;
        this.indexService = null;
        this.indexFieldDataService = null;
        this.threadPool = null;
        this.fixedBitSetFilterCache = null;
        this.indexShard = null;
    }

    public void setTypes(String ... types) {
        this.types = types;
    }

    public void preProcess() {
    }

    public Query searchFilter(String[] types) {
        return null;
    }

    public long id() {
        return 0L;
    }

    public String source() {
        return null;
    }

    public ShardSearchRequest request() {
        return null;
    }

    public SearchType searchType() {
        return null;
    }

    public SearchContext searchType(SearchType searchType) {
        return null;
    }

    public SearchShardTarget shardTarget() {
        return null;
    }

    public int numberOfShards() {
        return 1;
    }

    public boolean hasTypes() {
        return false;
    }

    public String[] types() {
        return new String[0];
    }

    public float queryBoost() {
        return 0.0f;
    }

    public SearchContext queryBoost(float queryBoost) {
        return null;
    }

    public long getOriginNanoTime() {
        return this.originNanoTime;
    }

    protected long nowInMillisImpl() {
        return 0L;
    }

    public ScrollContext scrollContext() {
        return null;
    }

    public SearchContext scrollContext(ScrollContext scrollContext) {
        throw new UnsupportedOperationException();
    }

    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public <SubPhaseContext extends FetchSubPhaseContext> SubPhaseContext getFetchSubPhaseContext(FetchSubPhase.ContextFactory<SubPhaseContext> contextFactory) {
        String subPhaseName = contextFactory.getName();
        if (this.subPhaseContexts.get(subPhaseName) == null) {
            this.subPhaseContexts.put(subPhaseName, contextFactory.newContextInstance());
        }
        return (SubPhaseContext)this.subPhaseContexts.get(subPhaseName);
    }

    public SearchContextHighlight highlight() {
        return null;
    }

    public void highlight(SearchContextHighlight highlight) {
    }

    public SuggestionSearchContext suggest() {
        return null;
    }

    public void suggest(SuggestionSearchContext suggest) {
    }

    public List<RescoreSearchContext> rescore() {
        return null;
    }

    public void addRescore(RescoreSearchContext rescore) {
    }

    public boolean hasScriptFields() {
        return false;
    }

    public ScriptFieldsContext scriptFields() {
        return null;
    }

    public boolean sourceRequested() {
        return false;
    }

    public boolean hasFetchSourceContext() {
        return false;
    }

    public FetchSourceContext fetchSourceContext() {
        return null;
    }

    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        return null;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public void setSearcher(Engine.Searcher searcher) {
        this.searcher = new ContextIndexSearcher(searcher, (QueryCache)this.indexService.cache().query(), this.indexShard.getQueryCachingPolicy());
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public MapperService mapperService() {
        if (this.indexService != null) {
            return this.indexService.mapperService();
        }
        return null;
    }

    public AnalysisService analysisService() {
        return this.indexService.analysisService();
    }

    public IndexQueryParserService queryParserService() {
        return this.indexService.queryParserService();
    }

    public SimilarityService similarityService() {
        return null;
    }

    public ScriptService scriptService() {
        return (ScriptService)this.indexService.injector().getInstance(ScriptService.class);
    }

    public PageCacheRecycler pageCacheRecycler() {
        return this.pageCacheRecycler;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.fixedBitSetFilterCache;
    }

    public IndexFieldDataService fieldData() {
        return this.indexFieldDataService;
    }

    public long timeoutInMillis() {
        return 0L;
    }

    public void timeoutInMillis(long timeoutInMillis) {
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minScore;
    }

    public SearchContext sort(Sort sort) {
        return null;
    }

    public Sort sort() {
        return null;
    }

    public SearchContext trackScores(boolean trackScores) {
        return null;
    }

    public boolean trackScores() {
        return false;
    }

    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    public Query aliasFilter() {
        return null;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public int from() {
        return 0;
    }

    public SearchContext from(int from) {
        return null;
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SearchContext size(int size) {
        return null;
    }

    public boolean hasFieldNames() {
        return false;
    }

    public List<String> fieldNames() {
        return null;
    }

    public void emptyFieldNames() {
    }

    public boolean explain() {
        return false;
    }

    public void explain(boolean explain) {
    }

    public List<String> groupStats() {
        return null;
    }

    public void groupStats(List<String> groupStats) {
    }

    public boolean version() {
        return false;
    }

    public void version(boolean version) {
    }

    public int[] docIdsToLoad() {
        return new int[0];
    }

    public int docIdsToLoadFrom() {
        return 0;
    }

    public int docIdsToLoadSize() {
        return 0;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        return null;
    }

    public void accessed(long accessTime) {
    }

    public long lastAccessTime() {
        return 0L;
    }

    public long keepAlive() {
        return 0L;
    }

    public void keepAlive(long keepAlive) {
    }

    public SearchLookup lookup() {
        return new SearchLookup(this.mapperService(), this.fieldData(), null);
    }

    public DfsSearchResult dfsResult() {
        return null;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    public ScanContext scanContext() {
        return null;
    }

    public MappedFieldType smartNameFieldType(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().smartNameFieldType(name, this.types());
        }
        return null;
    }

    public MappedFieldType smartNameFieldTypeFromAnyType(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().smartNameFieldType(name);
        }
        return null;
    }

    public ObjectMapper getObjectMapper(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().getObjectMapper(name, this.types);
        }
        return null;
    }

    public void doClose() {
    }

    public Counter timeEstimateCounter() {
        return this.timeEstimateCounter;
    }

    public InnerHitsContext innerHits() {
        throw new UnsupportedOperationException();
    }

    public <V> V putInContext(Object key, Object value) {
        return null;
    }

    public void putAllInContext(ObjectObjectAssociativeContainer<Object, Object> map) {
    }

    public <V> V getFromContext(Object key) {
        return null;
    }

    public <V> V getFromContext(Object key, V defaultValue) {
        return defaultValue;
    }

    public boolean hasInContext(Object key) {
        return false;
    }

    public int contextSize() {
        return 0;
    }

    public boolean isContextEmpty() {
        return true;
    }

    public ImmutableOpenMap<Object, Object> getContext() {
        return ImmutableOpenMap.of();
    }

    public void copyContextFrom(HasContext other) {
    }

    public <V> void putHeader(String key, V value) {
    }

    public <V> V getHeader(String key) {
        return null;
    }

    public boolean hasHeader(String key) {
        return false;
    }

    public Set<String> getHeaders() {
        return Collections.EMPTY_SET;
    }

    public void copyHeadersFrom(HasHeaders from) {
    }

    public void copyContextAndHeadersFrom(HasContextAndHeaders other) {
    }

    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    public Profilers getProfilers() {
        return null;
    }
}

