/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.elasticsearch.Version;

public class VersionUtils {
    private static final List<Version> SORTED_VERSIONS;

    public static List<Version> allVersions() {
        return Collections.unmodifiableList(SORTED_VERSIONS);
    }

    public static Version getPreviousVersion(Version version) {
        int index = SORTED_VERSIONS.indexOf(version);
        assert (index > 0);
        return SORTED_VERSIONS.get(index - 1);
    }

    public static Version getPreviousVersion() {
        Version version = VersionUtils.getPreviousVersion(Version.CURRENT);
        assert (version.before(Version.CURRENT));
        return version;
    }

    public static Version getFirstVersion() {
        return SORTED_VERSIONS.get(0);
    }

    public static Version randomVersion(Random random) {
        return SORTED_VERSIONS.get(random.nextInt(SORTED_VERSIONS.size()));
    }

    public static Version randomVersionBetween(Random random, Version minVersion, Version maxVersion) {
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = SORTED_VERSIONS.indexOf(minVersion);
        }
        int maxVersionIndex = SORTED_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = SORTED_VERSIONS.indexOf(maxVersion);
        }
        if (minVersionIndex == -1) {
            throw new IllegalArgumentException("minVersion [" + minVersion + "] does not exist.");
        }
        if (maxVersionIndex == -1) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] does not exist.");
        }
        if (minVersionIndex > maxVersionIndex) {
            throw new IllegalArgumentException("maxVersion [" + maxVersion + "] cannot be less than minVersion [" + minVersion + "]");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return SORTED_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    static {
        Field[] declaredFields = Version.class.getDeclaredFields();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Field field : declaredFields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            try {
                Version object = (Version)field.get(null);
                ids.add(object.id);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList idList = new ArrayList(ids);
        Collections.sort(idList);
        ArrayList<Version> version = new ArrayList<Version>();
        for (Integer integer : idList) {
            version.add(Version.fromId((int)integer));
        }
        SORTED_VERSIONS = Collections.unmodifiableList(version);
    }
}

