/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.cluster;

import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.tasks.TaskManager;

public class NoopClusterService
implements ClusterService {
    final ClusterState state;

    public NoopClusterService() {
        this(ClusterState.builder((ClusterName)new ClusterName("noop")).build());
    }

    public NoopClusterService(ClusterState state) {
        if (state.getNodes().size() == 0) {
            state = ClusterState.builder((ClusterState)state).nodes(DiscoveryNodes.builder().put(new DiscoveryNode("noop_id", (TransportAddress)DummyTransportAddress.INSTANCE, Version.CURRENT)).localNodeId("noop_id")).build();
        }
        assert (state.getNodes().localNode() != null);
        this.state = state;
    }

    public DiscoveryNode localNode() {
        return this.state.getNodes().localNode();
    }

    public ClusterState state() {
        return this.state;
    }

    public void addInitialStateBlock(ClusterBlock block) throws IllegalStateException {
    }

    public void removeInitialStateBlock(ClusterBlock block) throws IllegalStateException {
    }

    public OperationRouting operationRouting() {
        return null;
    }

    public void addFirst(ClusterStateListener listener) {
    }

    public void addLast(ClusterStateListener listener) {
    }

    public void add(ClusterStateListener listener) {
    }

    public void remove(ClusterStateListener listener) {
    }

    public void add(LocalNodeMasterListener listener) {
    }

    public void remove(LocalNodeMasterListener listener) {
    }

    public void add(TimeValue timeout, TimeoutClusterStateListener listener) {
    }

    public void submitStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
    }

    public List<PendingClusterTask> pendingTasks() {
        return null;
    }

    public int numberOfPendingTasks() {
        return 0;
    }

    public TimeValue getMaxTaskWaitTime() {
        return TimeValue.timeValueMillis((long)0L);
    }

    public TaskManager getTaskManager() {
        return null;
    }

    public Lifecycle.State lifecycleState() {
        return null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public ClusterService start() {
        return null;
    }

    public ClusterService stop() {
        return null;
    }

    public void close() {
    }
}

